<?php
/*********************************************************
** Description : Create tables for Bear SQL         	**
** File Name   : create.php								**
** Version     : 1.01									**
** Modified    : 24 December 2008       			    **
** Author      : Tony Aslett							**
** Website     : http://bearsql.org 					**
** Email	   : tony@appcreator.com					**
**********************************************************/ 
/************************************************************************
    Bear SQL simplifies MySQL database management
    Copyright (C) 2008  Tony Aslett
    
    This file is part of Bear SQL.

    Bear SQL is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>
********************************************************************************/

/**
 * Control for create table functions
 */
function create_control(){	
  $output='';
  if(isset($_POST['cmd']) &&  $_POST['cmd'] !=""){
    $output='';
    $cmd=strtolower(str_replace(' ','', $_POST['cmd']));
    switch ($cmd){
  	case'createtable':
  	  $output.=numoffields();
  	break;
  	case 'step2':
  	  $output.=fieldtypes();
  	break;
  	case 'step3':
  	  $output.=fieldsizes();
  	break;
  	case 'buildtable':
  	  $output.=createtable();
  	break;
    }
  }
  return $output;
}

/**
 * Number of fields
 * 
 * @return Number of fields form
 */
function numoffields(){
  $output='';
  $output.='<form action="index.php" method="post" class="jscheck">';
  $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $output.='<div class="fieldset"><fieldset class="lone"><legend>Create a Table step 1</legend>';
  $output.='<div class="cb"><label for="tblname" class="required">Table Name:</label><input type="text" name="tblname" size="25" id="tblname" /></div>';
  $output.='<div class="cb"><label for="flds" class="required">Number of Fields:</label><input type="text" name="flds" size="5"  id="flds" /></div>';
  $output.='<input type="hidden" name="cmd" value="step2" />';
  $output.='<input class="but reset" type="reset" name="reset" value="Reset" />';
  $output.='<input class="but nextstep" type="submit" value="Step 2" />';
  $output.='</fieldset></div>';
  $output.='</form>';
  return $output;
}
		
/**
 * Create table
 * 
 * @return list of tables
 */
function createtable(){
  $prik="";
  $q=" ";
  $output='';
  $x=0;
  $iskey ="false";
  $flds = cleanvar($_POST['flds']);
  $leng = cleanvar($_POST['leng']);
  $fname= cleanvar($_POST['fname']);
  $ftype= cleanvar($_POST['ftype']);
       
  if(isset($_POST['others']) ){
    $others=cleanvar($_POST['others']);
  }
  $tablename=cleanvar($_POST['tblname']);
	
  $dbname=$_SESSION['dbname'];
  $query="Create table $tablename (";
  for($i=0; $i < $flds; $i++){
	$q.= " $fname[$i] ";
		// Field size
	if(isset($leng[$i]) && $leng[$i] !=""){
	  $leng[$i]=StripSlashes($leng[$i]);
	  $q .= "$ftype[$i](".$leng[$i] .") ";
	}else{
	  $q.= "$ftype[$i] ";
	}
	//Primary Key
	if(isset($_POST['pk'])){
      $pk=$_POST['pk'];
    }
	if(isset($pk[$i])&& $pk[$i]!=""){
	  $prik[$x] = $fname[$i] ;
	  $x ++;
	  $iskey="true";
	  if(!eregi("NOT NULL", $others[$i]) || !eregi("unique", $others[$i])){
		$q.="NOT NULL ";
	  }
	}
	//default
	if (isset($_POST['def'] )) {
      $def=$_POST['def'];  
      if( $def[$i] != ""){
		$q.="DEFAULT  '$def[$i]' " ;
      }
	}
	if(isset($_POST['nu'])){
	  $nu=$_POST['nu'];
      if(isset( $nu[$i] ) && $nu[$i]=='yes'){             
		$q.="NOT NULL ";
      }
	}
	//Other flags $others=$_POST['others'];
	if(isset($others[$i]) && $others[$i] !=""){
	  $q.=" ". $others[$i] ;
	}
		
	if($i < $flds-1){
	  $q.=", ";
	}
  }
  $pkey="";
  $npk=count($prik);
  if($npk >= 1){
    for($k = 0; $k < $npk; $k++){
      $pkey .= (isset($prik[$k]))?$prik[$k]:'';
		if ($k < $npk-1){
		  $pkey.= ", ";
		}
	 }
  }
  $prikey="";
  if($npk >= 1 && $iskey=="true"){
	$prikey=", PRIMARY KEY($pkey) ";
  }
  $query.= "$q $prikey )";

  $result=exequery($query);
  if($result){
    message( $tablename .' '.MSG_SCR);			
 }
  return listtables();
}

/**
 *  Field Sizes
 * 
 * @return field sizes form
 */
function fieldsizes(){
  $output='';
  if(isset($_POST['tblname'])){
	$tblname = $_POST['tblname'];
	$output.='<form action="index.php" method="post" class="jscheck">';
	$output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
	$output.='<div class="fieldset"><fieldset class="lone">';
	$output.='<legend>'.BTN_CTB.': <span>'.$tblname.'</span> '.LBL_STP3.'</legend>';
	$output.='<table id="fieldsize">';	
	$output.='<input type="hidden" name="tblname" value="'.$tblname.'" />';
	$output.='<input type="hidden" name="flds" value="'. $_POST["flds"].'" />';
	$output.="\n".'<thead><tr><th>'.LBL_PKY.'</th><th>'.LBL_FN.'</th><th>'.LBL_TYP.'</th><th>'.LBL_SSV.'</th>';
	$output.='<th>'.LBL_NUL.'</th><th>'.LBL_DEF.'</th><th>'.LBL_OFL.'</th></tr></thead>';
	if(isset($_POST['flds'])){
	  $flds=$_POST['flds'];
	  $fname=$_POST['fname'];
	  $ftype=$_POST['ftype'];
	  for($i=0; $i < $flds; $i++){
		$output.="\n".'<tr><td><input type="checkbox" value="pk" name="pk['.$i.']" title="'.$fname[$i].' '.LBL_SPK.'" /></td>';
		$output.='<td><input type="text" name="fname['.$i.']" value="'.$fname[$i].'" /></td>';
		$output.='<td><input type="text" name="ftype['.$i.']" value="'.$ftype[$i].'" /></td>';		
		$output.='<td>';		
		$ft=$ftype[$i];
		$output.=fieldformsize($ft, $i, '');		
		$output.='</td><td><select name="nu['.$i.']">';
		$output.='<option value="0"></option>';
		$output.='<option value="yes">Yes</option>';
		$output.='<option value="no">No</option>';
		$output.='</select></td>';
        if($ft=='SET' || $ft=='ENUM'){
          $output.='<td><input type="hidden" name="def['.$i.']" value=""></td>';
        }else{    
          $output.='<td><input type="text" name="def['.$i.']"></td>';
        }
		$output.='<td><input type="text" name="others['.$i.']">';
	
		$output.='</td></tr>';		
	  }
	  $output.='<input type="hidden" name="cmd" value="buildtable" /></td>';
	
	  $output.='<tr><td><input class="but clear" type="reset" name="reset" value="'.BTN_RST.'" /></td>';
	  $output.='<td><input class="but nextstep" type="submit" value="'.BTN_CTB.'" /></td>';
	  $output.='</tr>';
	  $output.='</table>';
	  $output.='</fieldset></div>';
	  $output.='</form>';
    }
  }	
  return $output;
}

/**
 *  Field types
 * 
 * @return field types form
 */
function fieldtypes(){
  $output='';
  require_once("settings.php");
  $fieldtypes=$GLOBALS['fieldtypes'];
  $dbname=$_SESSION['dbname'];
  if( !isset($_POST['tblname']) || $_POST['tblname'] ==''){
	$output.= message(MSG_BTN, 'warning', 'inline');
	$output.= goto(array( 'db'=> $dbname, 'class'=>'but create', 'cmd'=>'createtable', 'value'=>BTN_CTB )) ;
  }elseif($_POST['flds'] <= 0){
	$output.= message(MSG_NFN, 'warning', 'inline');
	$output.= goto(array( 'db'=> $dbname, 'class'=>'but create', 'cmd'=>'createtable', 'value'=>BTN_CTB )) ;
  }else{
	$flds= $_POST['flds'];
	$tblname= $_POST['tblname'];

    $output.='<form action="index.php" method="post" class="jscheck">';
    $output.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
	$output.='<div class="fieldset"><fieldset class="lone"><legend>'.BTN_CTB.': <span>'. $tblname.'</span> '.LBL_STP2.'</legend>';
	$output.='<table id="fieldtypes">';
	$output.='<input type="hidden" name="tblname" value="'. $tblname.'">';
	$output.='<input type="hidden" name="flds" value="'.$flds.'">';
	$output.='<tr><th></th><th class="lft">'.LBL_FN.':</th><th class="lft">'.LBL_TYP.':</th></tr>';
	for($i=0; $i < $flds; $i++){
	  $ia=$i+1;
	  $output.='<tr><td><label for="fn'.$i.'" class="required">'.LBL_FLD.' '.$ia.':</label></td><td><input type="text" name="fname['.$i.']" id="fn'.$i.'" title="'.LBL_FN.' '.$i.'" ></td>';
	  $output.='<td>';
	  $output.='<select name="ftype['.$i.']" title="'.LBL_FLD.' '.$i.' '.LBL_TYP.'" >';
	  for($f=0; $f < count($fieldtypes); $f ++){
		$output.='<option value="'.$fieldtypes[$f].'">'.$fieldtypes[$f].'</option>';
	  }
	  $output.='</select>';
	  $output.='</td></tr>';		
	}	
    $output.='<input type="hidden" name="cmd" value="step3" />';	
	$output.='<tr><td></td><td><input class="but reset" type="reset" name="reset" value="'.BTN_RST.'"></td>';
	$output.='<td><input class="but nextstep" type="submit" name="cmd" value="'.LBL_STP3.'" /></td>';
	$output.='</tr>';
	$output.='</table>';
	$output.='</fieldset></div>';
	$output.='</form>';
  }
  return $output;
}