<?php 
/********************************************************* 
** Description : Control for Bear SQL         			** 
** File Name   : control.php							** 
** Version     : 1.01									**
** Modified    : 24 December 2008       			    **
** Author      : Tony Aslett							**
** Website     : http://bearsql.org 					**
** Email	   : tony@appcreator.com					**
**********************************************************/ 
/************************************************************************
    Bear SQL simplifies MySQL database management
    Copyright (C) 2008  Tony Aslett
    
    This file is part of Bear SQL.

    Bear SQL is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>
********************************************************************************/
  $pageout='';
  $title='';
  require("reuseable.php"); 
  include_once("settings.php");

  // language support
  if(isset($_POST['language'])){
    $_SESSION['language']= $_POST['language'];
  }
  $lang = (isset($_SESSION['language']))?$_SESSION['language']: '';
  if(is_file('./languages/'.$lang.'.php')){
    include_once('languages/'.$lang.'.php');
  }else{
    include_once('languages/english.php');
  }
  
//******************* Session Logon ***********************
if(!isset($_SESSION['token'])){
    maketoken();
}elseif(isset($_POST['cmd']) && isset($_POST['token']) && !checktoken($_POST['token'])){
  //do something?
}
if(isset($_POST['userid']) && isset($_POST['pword'])){
    $_SESSION['user'] = $_POST['userid'];
    $_SESSION['password'] = $_POST['pword'];
    $link= connectmysql();
    if($link == FALSE){ 
      message("Unable to connect to the database server.",'error');
	  $_POST['cmd'] = 'logout';	 
	} 
}
  //*****dbname
  if(isset($_POST['dbname'])){
    $dbname=cleanvar($_POST['dbname']);
    $_SESSION['dbname']= $dbname;
  }
  //***** Host
  if(isset($_POST['host'])){
    $host=cleanvar($_POST['host']);
    $_SESSION['host']=$host;
  }
  //******set tablename
  if(isset($_POST['tablename'])){
    $tablename=cleanvar($_POST['tablename']);
  }
  //********** pagemax
  if(isset($_POST['pagemax'])){ 
    $pagemax=cleanvar($_POST['pagemax']);
    $isnum=true;
    for($o=0; $o<count($pagemax); $o++){
      if($pagemax[$o]>9){
        $isnum=false;
      }
    }
    if($pagemax >0 && $isnum){    
      $_SESSION['pagemax']=$pagemax;
    }
  }
  if(isset($_SESSION['pagemax'])){
    $pagemax=$_SESSION['pagemax'];
  }
 
//*********************************************

  if (isset($_SESSION['dbname']) || isset($_POST['dbna']) || isset($_POST['dbname'])){  
    if (isset($_SESSION['dbname'])){
      $dbsetname = $_SESSION['dbname'];
	}elseif(isset($_POST['dbname'])){
	  $dbsetname = cleanvar($_POST['dbname']);
	  $_SESSION['dbname'] = $dbsetname;
	}else{
	  $dbsetname = cleanvar($_POST['dbna']);
	  $_SESSION['dbname'] = $dbsetname;
	}
  } 
//*************************** we have a DB set       
  if(isset($dbsetname) && $dbsetname!=""){
	$link= connectmysql();
	$conn = connectdb($dbsetname, $link); 
  }			
  if(isset($_POST['cmd'])){
	$cmd=strtolower(str_replace(' ','', $_POST['cmd']));
	if(!isset($dbname) && isset($_SESSION['dbname'])){
	  $dbname=$_SESSION['dbname'];
	}
	$nav[]=array('home' => 'active', 'logout'=> 'active'); 
  $nav[]=array(
	 'dbstart' => 'active', 
	 'createtable' => 'active', 
	 'addrec' => 'active',
	'altertable' => 'active',
	'wyoq' => 'active',
	'users' => 'active'
  );   
	  
	switch($cmd){
	    case 'showtable':
	      $nav[]= array('name' =>  'searchtab', 'status' => 'active');
	      $query = "select * from $tablename"; 
	      $pageout.= showrecords($query);
	      $title = 'Show table: '. $tablename;
		break;
		case 'showpage':
		  $query=cleanvar($_POST['query']);
		  $pageout.=showrecords($query);
		break;
		case 'buildtable':
		case 'step3':
		case 'step2':
		case 'createtable':
		  require_once('create.php');
		  $title='Create Table';
	      $nav = change_nav_status($nav, 'altertable', 'disabled');
	      $nav = change_nav_status($nav, 'addrec', 'disabled');
	      $nav = change_nav_status($nav, 'createtable', 'current');
	      $nav = change_nav_status($nav, 'wyoq', 'disabled');
		  $pageout.=create_control();
		break;
		case 'changepassword':
		case 'password':
		case 'grantprivileges':  
		case 'privileges':
		case 'changename':
		case 'changeusername':
		case 'dropuser':
		case 'deleteuser':
		case 'adduser':
		case 'createuser':
		case 'manageusers':
		case 'edituser':
		  require_once('user.php');
		  $title= LBL_UMG;
		  $nav = change_nav_status($nav, 'altertable', 'disabled');
	      $nav = change_nav_status($nav, 'addrec', 'disabled');
	      $nav = change_nav_status($nav, 'users', 'current');  
         $nav[]=array(
        'adduser' => 'active',
        'dropuser' => 'active',
        'changename' => 'active',
        'changepass' => 'active',
        'grant' => 'active',
        );	
		
		  $pageout.=user_control($nav);
		break;  
		case 'renametable':
        case 'rename':
        case 'addindex':
        case 'submitindex':   
        case 'dropindex': 
        case 'submitdropindex':
        case 'addprimarykey':
        case 'addpk':
        case 'dropprimarykey':
        case 'addcolumn':
        case 'addcolumnnext':
        case 'submitaddcolumn': 
        case 'dropcolumn':
        case 'changecolumn':
        case 'submitchangecolumn':
        case 'submitdropcolumn':
        case 'altertable':
          require_once('alter.php');
		  $title='Alter Table '.$tablename;
		 // $nav = change_nav_status($nav, 'altertable', 'current'); 
		  $nav[]=altermenu( $cmd );
		  $pageout.= alter_control($cmd);	 
		break;
		case 'createdatabase':
		  $nav = change_nav_status($nav, 'dbstart', 'current'); 
		  $nav = change_nav_status($nav, 'altertable', 'disabled'); 
		  $nav = change_nav_status($nav, 'addrec', 'disabled'); 
		  $ndb=cleanvar($_POST['ndbname']);
		  $pageout.=createdb($ndb);
		break;
		case 'deletedb':
		  $nav = change_nav_status($nav, 'altertable', 'disabled'); 
	      $nav = change_nav_status($nav, 'addrec', 'disabled'); 
	      $nav = change_nav_status($nav, 'createtable', 'disabled');   
		  message(MSG_DDB.' '. $dbname,'warning');
		  message(MSG_CONTINUE,'warning');
		  $va=BTN_DRP.' '. $dbname; 
		  //$pageout.=goto( $dbname, $dbname ,'index.php', 'sml drdb', 'dropdb', $va, $va ); 
		  $pageout.=goto( array( 'db'=> $dbname ,'class'=> 'sml drdb', 'cmd'=> 'dropdb', 'alt'=> $va )); 
		break;
		case 'dropdb':
		  $dsql = "drop database $dbname"; 
		  message($dsql);
		  $result=exequery($dsql); 
		  unset($dbname);  
		  unset($_POST['dbname']);
		  unset($_SESSION['dbname']);
		  $nav = change_nav_status($nav, 'dbstart', 'current'); 
		  $nav = change_nav_status($nav, 'altertable', 'disabled'); 
		  $nav = change_nav_status($nav, 'addrec', 'disabled');  
		  $nav = change_nav_status($nav, 'createtable', 'disabled');  
		  $nav = change_nav_status($nav, 'users', 'disabled');    
		  $pageout.=showdb(); 
		break;
		case 'deletetable':
		  message(MSG_DTBL.' '. $tablename ,'warning');
		  message(MSG_CONTINUE ,'warning');
		  $va=BTN_DRP.' '. $tablename; 
		  //$pageout.=goto($tablename, $dbname,'index.php', 'deltable', 'Drop Table', $va, $va );
		  $pageout.=goto(array('table' => $tablename, 'class'=> 'but deltable', 'db'=> $dbname, 'cmd'=> 'deltable', 'value'=> BTN_DTB, 'alt'=> $va ));
		break;
		case 'droptable':
		  $nav = change_nav_status($nav, 'altertable', 'disabled');    
		  $nav = change_nav_status($nav, 'addrec', 'disabled');     
		  $dsql = "drop table $tablename"; 
		  $result=exequery($dsql); 
		  if($result){
		    message($tablename .' '. MSG_HBD, 'notice');
		  }
		  $pageout.=listtables();
		  unset($tablename);  
		  unset($_POST['tablename']);
		break;
		case 'delete':
		  $pk=cleanvar($_POST['pk']);
		  $pv=cleanvar($_POST['pv']);
		  $whr=buildwhr($pk, $pv); 
		  $sql = "delete from $tablename where $whr"; 
		  $result=exequery($sql); 
		  $pageout.=showrecords("select * from $tablename");
		break;
		case 'writequery':
		  $title='Write Your Own Query';
		  $nav = change_nav_status($nav, 'altertable', 'disabled');  
		  $nav = change_nav_status($nav, 'addrec', 'disabled');  
		  $nav = change_nav_status($nav, 'wyoq', 'current');  
		  $pageout.="<br />";
		  $pageout.=wyoq($dbname,"");
		  require_once('savedqueries.php');
		  $pageout.=listSavedQueries();
		break;
		case 'runquery':
		case 'savequery':
	    case 'deletequery':
	    case strtolower(str_replace(' ','', BTN_RQ)):
	    case strtolower(str_replace(' ','', BTN_SQ)):
	    case strtolower(str_replace(' ','', BTN_DQ)):
	      $title=BTN_WYOQ_ALT;
		  $nav = change_nav_status($nav, 'altertable', 'disabled');
		  $nav = change_nav_status($nav, 'addrec', 'disabled');  
		  $nav = change_nav_status($nav, 'wyoq', 'current');    
		  if(isset($_POST['wyoqta'])){
			$wyoqta = $_POST['wyoqta'];
			$pageout.=wyoqta($wyoqta, $dbname);
		  }
		break;
		case 'saveresults': 
		case strtolower(str_replace(' ','', BTN_SR)):     
		  if(isset($_POST['wyoqta'])){
		    include_once('savedqueries.php');
			$query = $_POST['wyoqta'];
			saveresults($query);
		  }
		  exit;
		break;
		case 'restore':
		  //require_once('backup.php');
		  $pageout.=restore();
		  $pageout.=showdb(); 
		break;
		case 'backup':
		case 'backupchecked':
		  require_once('backup.php');
		  backup();
		  $pageout.=showdb(); 
		case 'search':
		  if(isset($_POST['searchval'])){
			$searchval=cleanvar($_POST['searchval']);
		  }else{
		    $searchval="";
		  }
		  $query=searcht($tablename, $_SESSION['dbname'],  $searchval); 
		  $pageout.=showrecords($query, $searchval);
		break;
		case 'advancedsearch':
		  if(isset($_POST['advancedsearchval'])){
			$advancedsearchval=cleanvar($_POST['advancedsearchval']);
		  }else{
			$advancedsearchval="";
		  }
		  $query=advancedSearch($tablename, $_SESSION['dbname'],  $advancedsearchval); 
		  $pageout.=showrecords($query, $advancedsearchval);
		break;
		case 'submitaddrecord':
		  addeditrecord('add');
		  $query = "select * from $tablename"; 
		  $pageout.=showrecords($query);
		break;
		case 'addrecord':
		  $nav = change_nav_status($nav, 'addrec', 'current');  
		  $sql="Select * from $tablename";
		  $pageout.=addeditform($tablename, $sql, 'add' );
		  $title=BTN_ART;
		break;
		case 'edit':
		  $pk=cleanvar($_POST['pk']);
		  $pv=cleanvar($_POST['pv']);
		  $whr = buildwhr($pk , $pv); 
		  $sql= "Select * from $tablename where $whr"; 
		  $pageout.=addeditform($tablename, $sql, 'edit', $pk, $pv );
		break;
		case 'update':
		  addeditrecord('edit');
		  $pageout.=showrecords("SELECT * from $tablename");
		break;
		case 'optimizetable':
		  $tablename=($_POST['tablename'])?$_POST['tablename']: $tablename;
		  $query="OPTIMIZE table $tablename";
		  $result=exequery($query);
		  $nav = change_nav_status($nav, 'dbstart', 'current'); 
		  $nav = change_nav_status($nav, 'altertable', 'disabled'); 
		  $nav = change_nav_status($nav, 'addrec', 'disabled'); 
		  if($result){
			message($tablename.' '. MSG_HBO, 'notice');
		  }
		  $pageout.=listtables();
		break;
		case 'optimizechecked':
		  $tables=$_REQUEST['tables'];
		  $query="OPTIMIZE table $tables";
		  $result=exequery($query);
		  $nav = change_nav_status($nav, 'dbstart', 'current'); 
		  $nav = change_nav_status($nav, 'altertable', 'disabled'); 
		  $nav = change_nav_status($nav, 'addrec', 'disabled'); 
		  if($result){
			message($tables.' '. MSG_HBOM, 'notice');
		  }
		  $pageout.=listtables();
		  break;
		case 'logout':
		 unset($nav); 
		 $pageout = logout_user();
		break;
		case 'home':
		case 'login':
		  $nav=array(
	    'home' => 'current',
	   'logout' => 'active'
	    ); 
		  $pageout.=showdb(); 
		break;
		case 'listtables':
		case 'dbstart':
		case 'db':
		case 'view':
		default:
		  $title="Database";
		  $nav = change_nav_status($nav, 'dbstart', 'current'); 
		  $nav = change_nav_status($nav, 'altertable', 'disabled'); 
		  $nav = change_nav_status($nav, 'addrec', 'disabled'); 
		  $pageout.=listtables();  
		break;
	}
  }else{
    //not logged in
    $nav=FALSE;
	if(!isset($dbnamearray)){
		$dbnamearray='';
	}
	$pageout.=show_login($dbnamearray);
  }
 	
?>
  