/*********************************************************
** Description : bearsql.js JavaScript functions        **
** File Name   : bearsql.js                             **
** Version     : 1.01									**
** Modified    : 24 December 2008       			    **
** Author      : Tony Aslett							**
** Website     : http://bearsql.org 					**
** Email	   : tony@appcreator.com					**
**********************************************************/ 
/************************************************************************
    Bear SQL simplifies MySQL database management
    Copyright (C) 2008  Tony Aslett
    
    This file is part of Bear SQL.

    Bear SQL is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>
********************************************************************************/

$(document).ready(function(){
  $("td[@axis]").each(function(i){ //td with axis attribute
	setClickable(this, i);
	$(this).addClass('edit');
  })
  $('#optckd').click(function() {  
   appendchecked('#optckd'); 
  })	
   $('#savetables').click(function() { 
   appendchecked('#savetables'); 
  })  
  $('#checkall').change(function(){
    if($(this).attr("checked")){
	   $(':checkbox').each(function(){
		  $(this).attr('checked', 'checked');
	   })
	}else{
	   $(':checkbox').each(function(){
		  $(this).attr('checked', '');
	   })
	}
  })
  $('.mesg').hide();
  $('.mesg').fadeIn("slow");
  $('.jscheck :submit').click(function() {
    return validate_form($(this).parents('form'));
  })
  
   $('input.pagemax').change(function () {
     $(this).parents('form').submit();
   })
   
   $('#filebkup').hide();
   $('#bkdirfiles').hide();
   $('#backupdir').click(function() { 
     $('#bkdirfiles').show();
     $('#filebkup').hide();
   })
   $('#local').click(function() { 
     $('#filebkup').show();
     $('#bkdirfiles').hide();
   })
   
  if( navigator.vendor.indexOf('Konqueror')!=-1 || navigator.appVersion.indexOf("Mac")!=-1 && ( $.browser.safari || navigator.vendor.indexOf('Camino')!=-1)){
   inputtobutton();
  }
   
});

var locked=false;
var success=false;

function setClickable(obj, i) {
  $(obj).click(function() {
    if(!locked){
	   locked=true; //lock it
	   $('.edit').css('color', '#CCC');
	   var textarea = '<td class="edited"><textarea rows="4" cols="60">'+$(this).html()+'</textarea>';
	   var button	 = '<div><input type="button" name="save" class="sml saveButton" value="Save" /> <input type="button" name="cancel"  class="sml cancelButton"  value="Cancel" /></div></td>';
		
	   var revert = $(obj).html();
	   var cn=$(obj).attr("axis");
	   $(obj).after(textarea+button).remove();
	   $('.saveButton').click(function(){saveChanges(this, false, i, cn);});
	   $('.cancelButton').click(function(){saveChanges(this, revert, i, cn);});
	}
  })
}

function saveChanges(obj, cancel, n, cn) {
  if(!cancel) {
	var t = $(obj).parent().siblings(0).val();
	var pv='fval='+t;
	pv+='&fname='+cn;
    var x;
	var fc=$(obj).parent().parent().parent().find('td.c0').find('input');
	fc.each(function(i){
        if(this.value == cn){
         b=this.name.indexOf('[');
         e=this.name.indexOf(']');
         x=this.name.substring(b+1,e);
        }
		pv+='&'+this.name+'='+this.value;
	});
   
	$.ajax({
		type: "POST",
		dataType: "xml",
		url: "sub.php",
		data: pv,
		success: function(data){
		}
	});
  //find and update the hidden field value so that the edit button works.
     fc.each(function(z){
      if(this.name == "pv["+x+"]"){
      this.value=t;
      }
    });
  
  }else {
	var t = cancel;
  }
  $(obj).parent().parent().after('<td axis="'+cn+'" class="clickme">'+t+'</td>').remove();
  setClickable($('td.clickme'));
  if(!cancel){
	$('.clickme').css('color', 'green');
  }
  $('td.clickme').removeClass('clickme');
  locked=false;
  $('.edit').css('color', '#000');
}

function appendchecked(id){   
  var tas = [];
  $("input[@type=checkbox][@checked]").each(function() {      
    $(this).siblings('input[@name=tablename]').each(function() {
      if(this.value){
         tas.push(escape(this.value));
      }
    })
  })
  if(tas){
     tas=tas.join(',');
     $('<input type="hidden" name="tables" value="'+tas+'" />').appendTo(id);
     
  }
}

function validate_form(fid){
  var mesg='';
  var rt = true;
 
  $(fid).find('label.required').each(function(){
     id=$(this).attr('for');
     //alert(id);
     if($('#'+id).val() == '' || typeof($('#'+id).val()) == 'undefined'){
      rt=false;
      $('#'+id).css('background', '#f19603');
      mesg+='<li>Please enter a value for the '+$('#'+id).attr('type')+' field <a href="#'+id+'" onclick="document.getElementById(this.href.split(\'#\')[1]).focus();return false;">'+$(this).text()+'</a></li>';
    }
 })  
  if(mesg !=''){
       $('#message').append('Required fields:<ul class="mesg error">'+mesg +'</ul>'); 
    }  
  return rt;
}	

function inputtobutton(){
 $("input[@type='submit'],input[@type='reset']").each(function(){
   var button = '<button';
   if($(this).attr("class")!=""){
    button += ' class="'+$(this).attr("class")+'"';
   }
   if($(this).attr("id")!=""){
     button += ' id="'+$(this).attr("id")+'"';
   }
    if($(this).attr("name")!=""){
     button += ' name="'+$(this).attr("name")+'"';
   }
   if($(this).attr("type")!=""){
     button += ' type="'+$(this).attr("type")+'"';
   }
    if($(this).attr("value")!=""){
     button += ' value="'+$(this).attr("value")+'"';
     button +='>'+$(this).attr("value")+'</button>';
   }else{
    button +='></button>';
   }
    $(this).replaceWith( button ); 
   })
 }  