<?php
/*********************************************************
** Description : Backup functions for Bear SQL      	**
** File Name   : backup.php								**
** Version     : 1.01									**
** Modified    : 24 December 2008       			    **
** Author      : Tony Aslett							**
** Website     : http://bearsql.org 					**
** Email	   : tony@appcreator.com					**
**********************************************************/ 
/************************************************************************
    Bear SQL simplifies MySQL database management
    Copyright (C) 2008  Tony Aslett
    
    This file is part of Bear SQL.

    Bear SQL is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>
********************************************************************************/

/**
 * backup
 */
function backup(){
  $dbname = $_POST['dbname'];
  require_once('reuseable.php');
  connectmysql();
  $date=date("Y-m-d");
  $fname=$dbname.'_'.$date.".sql";
  if($GLOBALS['backup_prompt']===FALSE){	
    $backupdir=$GLOBALS['backupdir'];
	flush();
    $ss=$_SERVER['SERVER_SOFTWARE'];
    if (strpos($ss,"Win32")!=0) {
      $path = $backupdir."\\";    
    }else{
      $path = $backupdir."/";
    }
   
    $linkpath=$backupdir."/".$fname;
    $fname=$path.$fname;
     
    if (!is_dir($path)){
       mkdir($path, 0755);
    }  
     chmod($path, 0755);
  }
  
  if($f = fopen ($fname,"w")){
    $bkup="# Creation date: $date\n".
        "# Database: ".$dbname."\n".
        "# MySQL Server version: ".mysql_get_server_info()."\n\n" ;
    fwrite ($f,$bkup);
    fclose ($f);
    $tables=(isset($_POST['tables']) && $_POST['tables']!='' )? $_POST['tables']: NULL;
    if(isset($tables)){
	  $tables = explode(',', $tables);
    }else{
	  $result = exequery("Show tables from $dbname"); 
      while($table = mysql_fetch_array($result)){
		$tables[] = $table[0];	   
	  }	  
    }
	    		
    $i = 0;  	
    $f = fopen ($fname,"a");
	  foreach($tables as $tablename){
		if($tablename !=''){
		   $bkup = "# Table: ".$tablename;		
		   $bkup .= "\n";		
		   $bkup .= bkup_definition($dbname,$tablename );
		   $bkup .= "\n\n";
		   $bkup .= bkup_content($dbname, $tablename, $f);
		   $bkup .= "\n\n";
		   fwrite ($f,$bkup);
		   $i++;
		 }
	   }	      
	 fwrite ($f,"#EOF");
	 fclose ($f);
     if($GLOBALS['backup_prompt']){	
       filesaveheaders($fname);
       exit;
     }else{
        if(is_file($fname)){	
          message( MSG_BKC.' '.$i.' '.MSG_TSF.' <a href="'.$linkpath.'">'.$fname.'</a>', 'notice');
        }else{
	      message( MSG_UTB, "warning");
        }
     } 	
  }
}

/**
 * Backup definition of table
 *
 * @param database name $dbname
 * @param table name $tablename
 * @return table definition
 */
function bkup_definition($dbname, $tablename) {
    $qend=$GLOBALS['bkupsplit'];
    if($tablename !=''){
    $bkup = "DROP TABLE IF EXISTS $tablename$qend";
    $result = exequery("SHOW CREATE TABLE ".$dbname.".".$tablename);
    if($result){
      $row= mysql_fetch_array($result);
      $bkup.= $row[1].$qend;
    }
     return (stripslashes($bkup));
   }
}

/**
 * Backup table data
 *
 * @param database name $dbname
 * @param tablename $tablename
 * @param file $f
 * @return table data
 */

function bkup_content($dbname, $tablename, $f) {
  $qend=$GLOBALS['bkupsplit'];
  $bkup="";
  $result = exequery("SELECT * FROM ".$dbname.".".$tablename);
  $c=0;
  if($result){
     while($row = mysql_fetch_row($result)) {
         $insert = "INSERT INTO $tablename VALUES (";
         for($j=0; $j<mysql_num_fields($result);$j++) {
            if(!isset($row[$j])) $insert .= "NULL,";
            else if($row[$j] != "") $insert .= "'".addslashes($row[$j])."',";
            else $insert .= "'',";
         }
         $insert  = ereg_replace(",$","",$insert);
         $insert .= ")$qend";
         $bkup.= $insert;
         $c++;
         if ($c==5000){         	
	        fwrite($f,$bkup);       
	        $c = 0;
	        $bkup= '';
         }
     }
  }
  return $bkup;
} 