<?php 
/********************************************************* 
** Description : Alter page for Bear SQL        		** 
** File Name   : Alter.php								** 
** Version     : 1.01									**
** Modified    : 24 December 2008       			    **
** Author      : Tony Aslett							**
** Website     : http://bearsql.org 					**
** Email	   : tony@appcreator.com					**
**********************************************************/ 
/************************************************************************
    Bear SQL simplifies MySQL database management
    Copyright (C) 2008  Tony Aslett
    
    This file is part of Bear SQL.

    Bear SQL is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>
********************************************************************************/
/*
 *  Control for alter table functions
 */
function alter_control($cmd){
  $out='';
  $cmd=strtolower(str_replace(' ','', $cmd));
  switch ($cmd){
    case 'renametable':
      $tablename=cleanvar($_POST['tablename']);
      $out.='<form action="index.php" method="post" class="jscheck">';
      $out.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
      $out.='<div class="fieldset"><fieldset><legend>'.BTN_RNT.': '.$tablename.'</legend>';
      $out.='<input type="hidden" name="tablename" value="'.$tablename.'" />';
      $out.='<div class="cb"><label for="newtname" class="required">'.LBL_NTN.':</label><input type="text" id="newtname" name="newtname" value="'.$tablename.'" /></div>';
      $out.='<input  type="hidden" name="cmd" value="rename" />';
      $out.='<input class="but rename" type="submit" name="cmd" value="'.BTN_RN.'" />';
      $out.='</fieldset></div>';
      $out.='</form>';
	break;
	case 'rename':
	  $tablename=cleanvar($_POST['tablename']);
	  $dbname=$_SESSION['dbname'];
	  $newtname = cleanvar($_POST['newtname']);
	  $query="ALTER table $tablename RENAME as $newtname"; 
	  $result=exequery($query); 
	  if($result){ 
		$tablename= $newtname;
		message("Table Renamed successfully to $tablename.", 'notice', 'top' ); 
		$_SESSION['tablename']=$newtname;
		$_POST['tablename']=$newtname;
	  }	 
	break;
	case 'addindex':
	  $out.=addindexform();
	break;
	case 'submitindex':
	  $out.=addindex();
	break;
	case 'dropindex':
	  $out.=dropindexform();
	break;	
	case 'submitdropindex':
	  $out.=dropindex();
	break;
	case 'addprimarykey':
	  $out.=addprimarykeyform();
	break;
	case 'addpk':
	  $out.=addprimarykey();
	break;
	case 'dropprimarykey':
	  $out.=dropkey();
	break;
	case 'addcolumn':
	  $out.=addcolumnforma();
	break;
	case 'addcolumnnext':
	  $out.=addcolumnformb();
	break;
	case 'submitaddcolumn':
	  $out.=addcolumnformc();
	break;
	case 'changecolumn':
		$out.=changecolumnform();
	break;
	case 'submitchangecolumn':
	  $out.=changecolumn();
	break; 
	case 'dropcolumn':
	  $out.=dropcolumnform();
	break;
	case 'submitdropcolumn':
	  $out.=dropcolumn();
	break;
	case 'altertable': 
	  $out.=tablestructure();
	default:
	break;	 
  }
  return $out;
} 

/*
 * Menu for Alter 
 */
function altermenu($cmd=""){
  
  $buts=array( 
    'renametab' => 'active',
     'addindex'=> 'active',
     'dropidx'=> 'active',
     'addpk' => 'active', 
    'droppk'=> 'active',
     'addcol' => 'active', 
     'changecol'=> 'active', 
    'dropcol'=> 'active',
   );
   switch($cmd){
    case 'renametable':
      $buts = change_nav_status($buts, 'renametab', 'current');
      break;
    case 'addindex': 
       $buts = change_nav_status($buts, 'addindex', 'current');
      break;      
    case 'dropindex':   
       $buts = change_nav_status($buts, 'dropidx', 'current');
      break;   
    case 'addprimarykey': 
       $buts = change_nav_status($buts, 'addpk', 'current');
      break;     
    case 'dropprimarykey':
       $buts = change_nav_status($buts, 'droppk', 'current');
      break;
    case 'addcolumn':
       $buts = change_nav_status($buts, 'addcol', 'current');
      break;
    case 'addcolumnnext':
       $buts = change_nav_status($buts, 'addcol', 'current');
      break;     
    case 'dropcolumn':
       $buts = change_nav_status($buts, 'dropcol', 'current');
      break;
    case 'changecolumn':
       $buts = change_nav_status($buts, 'changecol', 'current');
      break;
   }
  return $buts;
}

/*
 * Add Index Form
 */ 
function addindexform(){ 
  $out='';
  $dbname=$_SESSION['dbname'];
  $tablename=cleanvar($_POST['tablename']);
  $result=exequery("SELECT * from $tablename");
  $num =  mysql_num_fields($result); 
  $fields = mysql_list_fields($dbname, $tablename); 
  $out.='<form action="index.php" method="post" class="jscheck">'."\n"; 
  $out.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $out.='<div class="fieldset"><fieldset class="lone"><legend>'.BTN_AIX.'</legend>';
  $out.='<input type="hidden" name="num" value="'.$num.'" />'; 
  $out.='<input type="hidden" name="tablename" value="'.$tablename.'" />'; 
  $out.='<div class="cb"><label>'.LBL_IXF.':</label><br />';
  for ( $c = 0; $c < $num; $c++){ 
	$fn =mysql_field_name($fields, $c); 
	$flagstring = mysql_field_flags ($result, $c);		 
	$out.='<label>'.$fn.'<input type="checkbox" name="idx['.$c.'] value="idx['.$c.']" /></label><br />'."\n";						 
	$out.="<input type='hidden' name=col[$c] value='$fn' />\n";		 
  } 
  $out.='</div>';
  $out.='<div class="cb"><label for="idxname" class="required">'.LBL_IXN.':</label>'; 
  $out.='<input type="text" name="idxname" id="idxname" value="" /></div>'; 
  $out.='<input type="hidden" name="cmd" value="submitindex" />';
  $out.='<input class="but addidx" type="submit" value="'.BTN_AIX.'" />'; 
  $out.='</fieldset></div>';
  $out.='</form>'; 
  return $out;
} 
 
/*
 * Add Index
 */ 
function addindex(){	
  $out='';
  $r=0; 
  $nks=" "; 
  $tablename=cleanvar($_POST['tablename']);
  $dbname=cleanvar($_SESSION['dbname']);
  $idxname=  cleanvar($_POST['idxname']);
  $idx=cleanvar($_POST['idx']);
  $col=cleanvar($_POST['col']);
  $num=cleanvar($_POST['num']);
  for ( $c = 0; $c < $num; $c++){ 
	if(isset($idx[$c])){ 
	  $r ++; 
	  if($r >1){ 
		$nks .= ", $col[$c]"; 
	  }else{ 
		$nks .= " $col[$c]"; 
	  } 
	}		 
  } 
  $query="ALTER table $tablename ADD index $idxname ($nks)"; 
  $result=exequery($query); 
  if($result){ 
    message("<span>$idxname</span>, ".MSG_IAS." <span>$tablename</span>."); 
  } 
} 

/*
 * Drop Index Form
 */ 
function dropindexform(){
  $out='';
  $dbname=$_SESSION['dbname'];
  $tablename=cleanvar($_POST['tablename']);
    $farray = array(); 
    $query="SHOW INDEX FROM $tablename"; 
    $sts = 0; 
    $result=exequery($query); 
    if($result){
     $num_rows = mysql_num_rows($result); 
     for ($t =0; $t < $num_rows; $t++){ 
	   $row= mysql_fetch_array($result); 
	   $op = "$row[2]"; 
	   if($op !="PRIMARY" && $op !=" "){ 
	     $farray[count($farray)]=$op;	 
	   } 
      } 
    }
  if (count($farray) >0){ 
	$farray = removearraycopy($farray); 
	$out.='<form action="index.php" method="post">';
	$out.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
	$out.='<div class="fieldset"><fieldset class="lone"><legend>Drop Index</legend>';
	$out.='<input type="hidden" name="dbname" value="'. $dbname.'" />';
	$out.='<input type="hidden" name="tablename" value="'. $tablename.'" />';
	$out.='<label>Index Name:<select name="idxname" />';
	for ($f=0; $f < count($farray); $f++){ 
	  $out.="<option value='$farray[$f]'>$farray[$f]</option>"; 
	} 	
	$out.='</select></label>';
	$out.='<input type="hidden" name="cmd" value="submitdropindex" />';
	$out.='<input class="but dropidx" type="submit"  value="'.BTN_DIX.'" />';
	$out.='</fieldset></div>';
	$out.='</form>';
  }else{ 
	message( MSG_NIT.' '.$tablename, 'notice'); 
  } 
  return $out;
} 
 
/*
 * Drop Index 
 */  
function dropindex(){	
  $out='';
  $dbname=$_SESSION['dbname'];
  $idxname= cleanvar( $_POST['idxname']);
  $tablename = cleanvar( $_POST['tablename']);
  $query="ALTER table $tablename DROP index $idxname"; 
  $result=exequery($query); 
  if($result){ 
	message($idxname .' '.MSG_IDS.' '.$tablename, 'notice'); 
  } 
  return $out;
} 
 
/*
 * Add Primary Key form
 */ 
function addprimarykeyform(){
  $out='';
  $tablename=(isset($_POST['tablename'])?cleanvar($_POST['tablename']):$_SESSION['tablename']);
  $dbname=$_SESSION['dbname'];
  $result=exequery("Select * from $tablename");
  $num =  mysql_num_fields($result); 
  $fields = mysql_list_fields($dbname, $tablename); 
  $foundkey="false"; 
 
  //Find any primary keys 
  for ( $c = 0; $c < $num; $c++){				 
    $flagstring = mysql_field_flags ($result, $c); 
    if(eregi("primary",$flagstring )){	 
      $foundkey ="true";	 
	}						 
  } 
  if($foundkey =="true"){ 
	message(MSG_EPK, 'notice');	 
	$out.= goto(array('table'=>$tablename, 'db'=> $dbname, 'class'=> 'but droppk', 'value'=> BTN_DPK ,'cmd'=> 'dropprimarykey')); 
  }else{// no primary keys  
	$out.='<form action="index.php" method="post">';
	$out.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';	
	$out.='<input type="hidden" name="tablename" value="'.$tablename.'" />';
	$out.='<input type="hidden" name="num" value="'.$num.'" />';
	$out.='<div class="fieldset"><fieldset class="lone"><legend>'.BTN_APK.'</legend>';
	$out.=message( MSG_SPK, 'notice', 'inline');	
	for ( $c = 0; $c < $num; $c++){ 
	  $fn =mysql_field_name($fields, $c); 
	  $flagstring = mysql_field_flags ($result, $c);  
	  $out.='<div class="cb"><label>'.$fn.'<input type="checkbox" name="key['.$c.']" value="key['.$c.']" /></label>'."\n";		 	  	 		 
	  $out.='<input type="hidden" name="col['.$c.']" value="'.$fn.'" />'."\n"; 
	  $out.='<input type="hidden" name="flagstring['.$c.']" value="'.$flagstring.'" /></div>'."\n"; 
	} 
	$out.='<input type="hidden" name="cmd" value="addpk" />';
	$out.='<input class="but addpk" type="submit"  value="'.BTN_APK.'" id="addpk" />';
	$out.='</fieldset></div>';
	$out.='</form>';	
  }//foundkey 
  return $out;
} 

/*
 * Add Primary Key
 */ 
function addprimarykey(){
  $out='';	
  $dbname=$_SESSION['dbname'];
  $tablename=cleanvar($_POST['tablename']);
  $flagstring=cleanvar($_POST['flagstring']);
  $col=cleanvar($_POST['col']);
  $key=cleanvar($_POST['key']);
  $num=cleanvar($_POST['num']);
  $opkflag=" "; 
  $nflag=0; 
  $r =0; 
  $nks=" "; 
  for ( $c = 0; $c < $num; $c++){ 
	if(isset($key[$c])){ 
	 // $out.="COL: $col[$c]";
	  $r ++; 
	  if($r >1){ 
		$nks .= ", $col[$c]"; 
	  }else{ 
		$nks .= " $col[$c]"; 
	  } 
	  //Make sure the chosen key field is not null. 
	  if(eregi("not_null", $flagstring[$c] ) || eregi("NOT NULL", $flagstring[$c] ) ){ 
		$nflag++; 
	  }	 
	}		 
	if (eregi("primary", $flagstring[$c] )){ 
	  $opkflag="true";	 
	} 
  } 
  if($nflag!=$r) {	 
	message( MSG_PNN, 'warning'); 
	//$out.=goto($tablename, $dbname, 'index.php', 'but changecol', 'changec', 'Change A Column' ); 
	$out.=goto(array('table'=>$tablename, 'db'=>$dbname, 'class'=> 'but changecol', 'cmd'=>'changec', 'value'=> BTN_CCOL )); 
	
  }elseif ($opkflag=="true"){//Drop old keys 
	message( MSG_EPK, 'warning'); 
	$out.=goto(array('table'=>$tablename, 'db'=>$dbname, 'class'=> 'but droppk', 'cmd'=>'dropprimarykey', 'value'=>BTN_DPK)); 
  }else{ 
    //add keys 
	$query="ALTER table $tablename ADD PRIMARY KEY ($nks)"; 
	$result=exequery($query); 
	if($result){ 
	  message(MSG_PKA.' '.$tablename, 'notice'); 
	} 
  } 
   return $out;
} 
 
/*
 * Drop Primary Key
 */ 
function dropkey(){	
  $out='';
  $dbname=$_SESSION['dbname'];
  $tablename=cleanvar($_POST['tablename']);
  $query="ALTER table $tablename DROP PRIMARY KEY";	 
  $result=exequery($query); 
  if($result){ 
	message(MSG_PKD.' '.$tablename, 'notice'); 
  } 
  return $out;
} 
 
/*
 * Add Column form 1
 */ 
function addcolumnforma(){
  $out='';
  $dbname=$_SESSION['dbname'];
  $tablename=cleanvar($_POST['tablename']);

  $out.='<form action="index.php" method="post" class="jscheck">';
  $out.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $out.='<div class="fieldset"><fieldset class="lone"><legend>'.LBL_ADC.': '.LBL_STP1.'</legend>';
  $out.='<input type="hidden" name="tablename" value="'.$tablename.'" />';
  $out.='<div class="cb"><label for="fieldn" class="required">'.LBL_FN.':</label>';
  $out.='<input type="text" name="fieldn" id="fieldn" /></div>';
  $out.='<div class="cb"><label for="ftype" class="required" >'.LBL_TYP.':</label>';
  $out.='<select name="ftype" id="ftype" title="'.LBL_SFT.'">';
   $out.='<option></option>';
  $fieldtypes=$GLOBALS['fieldtypes'];
  for($f=0; $f < count($fieldtypes); $f ++){ 
	$out.='<option value="'.$fieldtypes[$f].'">'.$fieldtypes[$f].'</option>'."\n"; 
  } 
  $out.='</select></div>';
  $out.='<input type="hidden" name="cmd" value="addcolumnnext" />';
  $out.='<input class="but next" type="submit" value="'.BTN_ACOL .' '.BTN_NXT.'" />';
  $out.='</fieldset></div>';
  $out.='</form>';
  return $out;
} 
 
/*
 * Add Column form 2
 */  
function addcolumnformb(){
  $out='';	
  $dbname=$_SESSION['dbname'];
  $tablename=cleanvar($_POST['tablename']);
  $fieldn=cleanvar($_POST['fieldn']);
  $ftype=cleanvar($_POST['ftype']);
  $out.='<form action="index.php" method="post">'."\n"; 
  $out.='<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $out.='<div class="fieldset"><fieldset><legend>'.LBL_ADC.': '.LBL_STP2.'</legend>';
  
  $out.='<input type="hidden" name="tablename" value="'.$tablename.'" />'."\n"; 
  $out.='<div class="cb"><label for="fieldn">'.LBL_FN.':</label><input type="text" name="fieldn" id="fieldn" value="'.$fieldn.'"  /></div>'."\n"; 
  $out.='<div class="cb"><label for="ftype">'.LBL_TYP.':</label><input type="text" name="ftype" id="ftype" value="'.$ftype.'"  /></div>'."\n"; 
  $out.='<div class="cb"><label for="leng">'.LBL_LEN.':</label>'.fieldformsize($ftype, 0, 0).'</div>';
  $out.='<div class="cb"><label for="flags">'.LBL_FLG.':</label><input type="text" name="flags" id="flags" /></div>';	 

  $out.= '<h4>'.GEN_CPO.'</h4>'."\n"; 
  $out.= GEN_COC.': <br />'."\n"; 
  $result=exequery("SELECT * from $tablename");
  $num =  mysql_num_fields($result); 
  $fields = mysql_list_fields($dbname, $tablename); 
  for ( $c = 0; $c < $num; $c++){ 
	$out.= '<span class="green">'.$c .' '. mysql_field_name($fields, $c). '</span> | '."\n"; 
  } 

  $out.= message(MSG_WPC, 'notice', 'inline');
  $out.= '<div class="cb">';
  for ( $p = 0; $p <= $num; $p++){ 
	$out.= '<label class="chkrdo"><input type="radio" name="placement" value="'.$p.'" />Col '.$p .'</label>'."\n"; 
  } 
  $out.= '</div>';
  $out.= '<input type="hidden" name="numfld" value="'.$num.'" />';
  $out.= message( MSG_CPD, 'notice', 'inline'); 
  $out.= '</div>'; 
  $out.= '<input type="hidden" name="cmd" value="submitaddcolumn" />'."\n";	
  $out.= '<input class="but addcol" type="submit" value="'.BTN_ACOL.'" />'."\n";	
  $out.= '</fieldset></div>';
  $out.= '</form>'."\n";	 
  return $out;
} 

/*
 * Add Column form 3
 */ 	 
function addcolumnformc(){
  $out= '';
  $tablename=cleanvar($_POST['tablename']);
  $dbname=$_SESSION['dbname'];
  if(isset($_POST['placement'])&& $_POST['placement']!=""){
	$placement=cleanvar($_POST['placement']);
  }else{
    $placement=cleanvar($_POST['numfld']);
  }
  $flags=cleanvar($_POST['flags']);
  $ftype=cleanvar($_POST['ftype']);
  $fieldn=cleanvar($_POST['fieldn']);
  $lenx=cleanvar($_POST['leng']);
  //if (isset($leng[0]) && $leng[0] >0){ 
  if(isset($lenx[0]) && $lenx[0] !=""){
	$siz = "$ftype($lenx[0]) "; 
  }else{ 
	$siz= "$ftype "; 
  } 
  $siz=StripSlashes($siz);
  if(! empty($flags)){ 
	$cng = " $siz $flags"; 
  }else{ 
	$cng="$siz"; 
  } 
  if (isset($placement)){ 
	if ($placement == 0){ 
	  $cng .= " first"; 
	}else{ 
	  $fields = mysql_list_fields($dbname, $tablename); 
	  $cng .= " after ". mysql_field_name($fields, $placement - 1); 
	} 
  } 
  $query="ALTER table $tablename ADD COLUMN $fieldn $cng"; 
 
  $result=exequery($query); 
  if($result){ 
	$out.=  message($fieldn.' '.MSG_CSA.' '.$tablename, 'notice'); 
  } 
  return $out;
 } 
 
function tablestructure(){
  $out = '';
  $dbname = $_SESSION['dbname'];
  $tablename = cleanvar($_POST['tablename']);
  $query = "Describe $tablename"; 
  $result = exequery($query); 
  $num = mysql_num_fields($result); 
  $out.= '<div id="struc">';
 
  $out.= '<table class="tables">';
  $out.= '<caption>'.GEN_CTS.' '.$tablename.'</caption>';
  $out.= '<thead><tr>';
  $out.= '<th>'.LBL_FN.'</th><th>'.LBL_TYP.'</th><th>'.LBL_NUL.'</th><th>'.LBL_KEY.'</th><th>'.LBL_DEF.'</th><th>'.LBL_EXT.'</th></tr>';
  $out.='</thead><tbody>';
  while($row= mysql_fetch_array($result)){ 
	$out.= "<tr>\n"; 
	for($x=0; $x < $num; $x++){ 
	  $out.= "<td>\n"; 
	  if(isset($row[$x])){ 
		$out.= "$row[$x]"; 
	  } 
	  $out.= "</td>\n"; 
	} 
	$out.="</tr>\n"; 
  } 
  $out.= '</tbody></table>';
  $out.= '</div>';
  return $out; 
}
 
/*
 * Change Column form
 */ 
function changecolumnform(){
  
  $out=tablestructure();
 
  message(MSG_TMS);
  message(MSG_MSN);
  
  $dbname=$_SESSION['dbname'];
  $tablename=cleanvar($_POST['tablename']);
  $query="Select * from $tablename"; 
  $result=exequery($query); 
 
  $num =  mysql_num_fields($result);	 
  $fields = mysql_list_fields($dbname, $tablename); 
  $out.= '<form action="index.php" method="post" class="jscheck">'."\n"; 
  $out.= '<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $out.= '<input type="hidden" name="dbname" value="'.$dbname.'">'."\n"; 
  $out.= '<input type="hidden"" name="tablename" value="'.$tablename.'">'."\n";
  $out.= '<fieldset class="lone">';	 
  $out.= '<div class="cb"><label for="fname" class="required">'.LBL_FLD.':</label>';
  $out.= '<select name="fname" id="fname" title="'.MSG_SFC.'">'."\n"; 
  $out.= '<option></option>'."\n"; 
  for ( $c = 0; $c < $num; $c++){		 
    $fn =mysql_field_name($fields, $c); 
    $out.= '<option value="'.$fn.'">'.$fn.'</option>'."\n"; 
  } 
  $out.= '</select></div>';
  $out.= '<div class="cb"><label for="fname">'.LBL_NFN.'</label><input type="text" name="fieldn" /></div>';
  $out.= '<div class="cb"><label for="ftype" class="required">'.LBL_TPS.'</label><input type="text" name="ftype" id="ftype"/></div>';
  $out.= '<div class="cb"><label for="extra">'.LBL_EXT.'</label><input type="text" name="extra" id="extra" size="50" /></div>';
  $out.= '<input  type="hidden" name="cmd" value="submitchangecolumn" />';
  $out.= '<input class="but changecol" type="submit" value="'.BTN_CCOL.'" />';
  $out.= '</fieldset>';
  $out.= '</form>';
  return $out;
} 

/*
 * Change Column
 */ 	
function changecolumn(){
   $out= '';
   $dbname=$_SESSION['dbname'];
   $tablename=cleanvar($_POST['tablename']);
   $fieldn=cleanvar($_POST['fieldn']);
   $fname=cleanvar($_POST['fname']);
   $ftype=cleanvar($_POST['ftype']);
   $extra=$_POST['extra'];
   if (isset($fieldn) && $fieldn !=" " && !empty($fieldn)){ 
     $cng=" $fieldn";	 
   }else{ 
     $cng=" $fname"; 
   } 
   if(! empty($ftype) && $ftype !=" "){ 
     $cng .= " $ftype"; 
   } 
   if(! empty($extra) && $extra !=" "){ 
     $cng .= " $extra"; 
   } 
   $query="ALTER TABLE $tablename CHANGE COLUMN $fname $cng"; 
	 
   $query=trim($query); 
   $result=exequery($query); 
   if($result){ 
	 message(MSG_CSC.' '.$tablename, 'notice'); 
   } 
  return $out;
} 
 
/*
 * Drop Column form
 */ 
function dropcolumnform(){
  $out= '';
  $tablename=cleanvar($_POST['tablename']);
  $dbname=$_SESSION['dbname'];
  $result=exequery("SELECT * from $tablename");
  $num =  mysql_num_fields($result); 
 // $fields = mysql_list_fields($dbname, $tablename); 
  $out.= '<form action="index.php" method="post" class="jscheck">';
  $out.= '<input type="hidden" name="token" value="'.$_SESSION['token'] .'" />';
  $out.= '<div class="fieldset"><fieldset class="lone"><legend>'.BTN_DCOL.'</legend>';
  $out.= '<input type="hidden" name="tablename" value="'.$tablename .'" />';
  $out.= '<input type="hidden" name="num" value="'.$num.'" />';	
  $out.= '<div class="cb"><label for="col" class="required">'.LBL_COL.':</label><select name="col" id="col">';
  $out.= '<option></option>';
  for ( $c = 0; $c < $num; $c++){ 
    $fn = mysql_field_name($result, $c); 
	$out.='<option value="'.$fn.'">'.$fn.'</option>'."\n";
  }
  $out.='</select></div>';
  $out.='<input type="hidden" name="cmd" value="submitdropcolumn" />'; 
  $out.='<input class="but dropcol" type="submit" value="'.BTN_DCOL.'" id="dropc" />'; 
  $out.='</fieldset></div>';
  $out.='</form>';
  return $out;
} 

/*
 * Drop Column
 */ 
function dropcolumn(){
  $out='';
  $dbname=$_SESSION['dbname'];
  $tablename=cleanvar($_POST['tablename']);
  $num=cleanvar($_POST['num']);
  $col=cleanvar($_POST['col']);
  $query="ALTER table $tablename DROP COLUMN $col"; 
  $result=exequery($query); 
  if($result){ 
	 message($col.' '.MSG_CSD.' '.$tablename, 'notice'); 
  } 
  return $out;
} 