<?php
    require_once('datagrid/database.class.php');
    require_once('datagrid/datagrid.class.php');
    require_once('datagrid/error.class.php');

	// DATABASE CONSTANTS
	$DB_USER='database_user';    
	$DB_PASS='password';            
	$DB_HOST='localhost';        
	$DB_NAME='database_name';    

	$db_handler = new MySql();    
	$db_handler->open($DB_HOST,$DB_USER,$DB_PASS,$DB_NAME);
	
	if (!$db_handler->connect_id){
		$error=new Error();
		$error->system_error("MYSQL ERROR: ".mysql_error());
		exit;
	}


    require_once('xajax/xajax.inc.php');
    
    // Instantiate the xajax object.  
    $xajax = new xajax(); 

    // Uncomment this line to turn debugging on
    //$xajax->debugOn(); 
        
    function fillDatagrid($sortField="1", $sortType="asc", $p="1", $page_size="10"){
		 
	    $sql  = " SELECT
					country_id,
					country_name,
					country_population,
					country_president
				FROM countries";
	    
		//////////////////////////////////////////////////////////////
		$dgrid = new DataGrid();
		$dgrid->dataSourse($db_handler->connect_id, $sql);
		$dgrid->sortByField($sortField, $sortType);
	
	    // Set view mode settings:
		$dgrid->setLayout(0); 
		$dgrid->setColumnsNoWrap("nowrap"); 
		$dgrid->setTableSettings(array("align"=>"center", "width"=>"650px", "border"=>"1", "bordercolor"=>"#535251", "cellspacing"=>"0", "cellpadding"=>"1"));
		$dgrid->allowSorting(true); 
	    $dgrid->allowPaging(true);  
	    $dgrid->setPagingSettings(array("results"=>true, "pages"=>true, "page_size"=>false)); // $lower/$upper:  

	    //  Edit Mode settings:
	    $dgrid->setMode(array("delete"=>false, "edit"=>false, "add"=>false));
        //$dgrid->setFieldsAsHypertext(array());
    
		// Bind datagrid
	    $text = $dgrid->bindXajax($p, $page_size);
	    
	    $objResponse = new xajaxResponse();
	    $objResponse->addAssign("divDatagrid","innerHTML",$text);	
	    return $objResponse;		    
    }


    // Specify the PHP functions to wrap. The JavaScript wrappers will be named xajax_functionname
    $xajax->registerFunction("fillDatagrid");
	
    // Process any requests.  Because our requestURI is the same as our html page,
    // this must be called before any headers or HTML output have been sent
    $xajax->processRequests();
    
?>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Ajax DataGrid</title>
<?php $xajax->printJavascript('../'); ?>
</head>

<body>

	<h3 align="center">PHP AJAX DataGrid Example</h3>
	 			
	<div id="divDatagrid" name="divDatagrid"></div>

	<script type="text/javascript">
	xajax_fillDatagrid('1', 'desc', '1', '10');			
	function callAjaxFunction(sort_field, sort_type, page, page_size){
		xajax_fillDatagrid(sort_field, sort_type, page, page_size);
	}
	</script>		
			
</body>
</html>