<?
//$Id: traffic.php,v 1.16 2004/10/26 13:59:10 eu Exp $
/*
Copyright (C) 2004 Radu Anghel <eu@celuloza.ro>
Copyright (C) 2004 Bogdan Andreias <toshy@celuloza.ro>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

require("config/config.php");
require("themes/$theme/theme.php");
require("include/sql.php");
require("include/functions.php");

if (!is_logged_in()) {
    header("Location: login.php");
}

$totalin = 0;
$totalout = 0;
$totalall = 0;

if ($use == "ipfm") {
    $dir = $ipfmdir;
}

if ($use == "pmacct") {
    $dir = $sql;
}

list($by, $selectedyear, $selectedmonth, $selectedday, $selectedhour, $selectedoff, $selectedsortby, $selectedsorttype) = split(" ", getvars($dir, $thisby, $thisyear, $thismonth, $thisday, $thishour, $thisoff, $thissortby, $thissorttype));

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
<head>
<link href="style.php" rel="stylesheet" type="text/css">
<?
echo "<meta http-equiv=\"refresh\" content=\"$refresh\">\n";
echo "<title>$title</title>\n";
?>
</head>
<?
echo "<body bgcolor=\"$background\">\n";
?>
<div>
<table class="table" align="center">
<tr><td align="center" valign="top" height="1%">

<table>
<tr><td align="center">
<p class="title">
<?
echo "<b>$title</b>";
?>
</p>
</td></tr>
<tr><td align="left">
<br /><br />
<p class="text">
<b>Year:</b>
<?
    $years = getavailableyears($dir);
    foreach ($years as $year) {
        if ($year == $selectedyear) {
	    echo "<font color=\"$color2\">\n";
	    echo "<b>[";
	    echo "<a href=\"traffic.php?by=year&year=$year&off=$selectedoff&sortby=$selectedsortby&sorttype=$selectedsorttype\">";
            echo "$year</a>]</b> \n";
	    echo "</font>\n";
        } else {
	    echo "<a href=\"traffic.php?by=year&year=$year&off=$selectedoff&sortby=$selectedsortby&sorttype=$selectedsorttype\">";
	    echo "$year</a> \n";
	}
    }
    echo "<br />\n";
?>

<b>Month:</b>
<?
    for ($i = 1; $i <= 12; $i++) {
        if ($i < 10) {
            $month = "0" . $i;
        } else {
            $month = $i;
        }
	if ($month == $selectedmonth) {
	    echo "<font color=\"$color2\">\n";
	    echo "<b>[";
	    echo "<a href=\"traffic.php?by=month&year=$selectedyear&month=$month&off=$selectedoff&sortby=$selectedsortby&sorttype=$selectedsorttype\">";
	    echo "$month</a>]</b> \n";
	    echo "</font>\n";
	} else {
	    echo "<a href=\"traffic.php?by=month&year=$selectedyear&month=$month&off=$selectedoff&sortby=$selectedsortby&sorttype=$selectedsorttype\">";
	    echo "$month</a> \n";
	}
    }
    echo "<br />\n";
?>

<b>Day:</b>
<?
    for ($i = 1; $i <= 31; $i++) {
        if ($i < 10) {
            $day = "0" . $i;
        } else {
            $day = $i;
        }
	if ($day == $selectedday) {
	    echo "<font color=\"$color2\">\n";
	    echo "<b>[";
	    echo "<a href=\"traffic.php?by=day&year=$selectedyear&month=$selectedmonth&day=$day&off=$selectedoff&sortby=$selectedsortby&sorttype=$selectedsorttype\">";
	    echo "$day</a>]</b> \n";
	    echo "</font>\n";
	} else {
	    echo "<a href=\"traffic.php?by=day&year=$selectedyear&month=$selectedmonth&day=$day&off=$selectedoff&sortby=$selectedsortby&sorttype=$selectedsorttype\">";
	    echo "$day</a> \n";
	}
    }
    echo "<br />\n";
?>

<b>Hour:</b>
<?
    for ($i = 0; $i < 24; $i++) {
        if ($i < 10) {
            $hour = "0" . $i;
        } else {
            $hour = $i;
        }
	if ($hour == $selectedhour) {
	    echo "<font color=\"$color2\">\n";
	    echo "<b>[";
	    echo "<a href=\"traffic.php?by=hour&year=$selectedyear&month=$selectedmonth&day=$selectedday&hour=$hour&off=$selectedoff&sortby=$selectedsortby&sorttype=$selectedsorttype\">";
	    echo "$hour</a>]</b> \n";
	    echo "</font>\n";
	} else {
	    echo "<a href=\"traffic.php?by=hour&year=$selectedyear&month=$selectedmonth&day=$selectedday&hour=$hour&off=$selectedoff&sortby=$selectedsortby&sorttype=$selectedsorttype\">";
	    echo "$hour</a> \n";
	}
    }
    echo "<br />\n";
?>

</p>
</td></tr>
</table>

</td></tr>
<tr><td align="center" valign="top">

<table width="700" cellpadding="0" cellspacing="0">
<tr>

<?
$url = "traffic.php?by=$by&";
switch($by) {
    case "year":
        $url = $url . "year=$year&off=$selectedoff";
        break;
    case "month":
        $url = $url . "year=$selectedyear&month=$selectedmonth&off=$selectedoff";
        break;
    case "day":
        $url = $url . "year=$selectedyear&month=$selectedmonth&day=$selectedday&off=$selectedoff";
        break;
    case "hour":
        $url = $url . "year=$selectedyear&month=$selectedmonth&day=$selectedday&hour=$selectedhour&off=$selectedoff";
        break;
}
?>

<?
    echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;id</td>";
    echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;";

    if ($selectedsortby == "ip") {
	switch($selectedsorttype) {
	    case "asc":
		$urlsort = $url . "&sortby=ip&sorttype=desc";
	        break;
	    case "desc":
		$urlsort = $url . "&sortby=ip&sorttype=asc";
		break;
	}
    } else {
	$urlsort = $url . "&sortby=ip&sorttype=desc";
    }
    echo "<a href=\"$urlsort\">";
    echo "host";
    echo "</a>";
    echo "&nbsp;&nbsp;&nbsp;</td>";
?>

<?
    echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;";
    if ($selectedsortby == "in") {
	switch($selectedsorttype) {
    	    case "asc":
        	$urlsort = $url . "&sortby=in&sorttype=desc";
        	break;
    	    case "desc":
        	$urlsort = $url . "&sortby=in&sorttype=asc";
        	break;
        }
    } else {
	$urlsort = $url . "&sortby=in&sorttype=desc";
    }
    echo "<a href=\"$urlsort\">";
    echo "in";
    echo "</a>";
    echo "&nbsp;&nbsp;&nbsp;</td>";
?>

<?
    echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;";
    if ($selectedsortby == "out") {
	switch($selectedsorttype) {
    	    case "asc":
        	$urlsort = $url . "&sortby=out&sorttype=desc";
        	break;
    	    case "desc":
        	$urlsort = $url . "&sortby=out&sorttype=asc";
        	break;
        }
    } else {
	$urlsort = $url . "&sortby=out&sorttype=desc";
    }
    echo "<a href=\"$urlsort\">";
    echo "out";
    echo "</a>";
    echo "&nbsp;&nbsp;&nbsp;</td>";
?>

<?
    echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;";
    if ($selectedsortby == "total") {
	switch($selectedsorttype) {
    	    case "asc":
        	$urlsort = $url . "&sortby=total&sorttype=desc";
        	break;
    	    case "desc":
        	$urlsort = $url . "&sortby=total&sorttype=asc";
        	break;
	}
    } else {
	$urlsort = $url . "&sortby=total&sorttype=desc";
    }
    echo "<a href=\"$urlsort\">";
    echo "total";
    echo "</a>";
    echo "&nbsp;&nbsp;&nbsp;</td>";
    echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;viteza&nbsp;&nbsp;&nbsp;</td>";

if ($col['status']) {
    echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;";
    if ($selectedsortby == "status") {
        switch($selectedsorttype) {
            case "asc":
                $urlsort = $url . "&sortby=status&sorttype=desc";
                break;
            case "desc":
	        $urlsort = $url . "&sortby=status&sorttype=asc";
	        break;
	}
    } else {
        $urlsort = $url . "&sortby=status&sorttype=desc";
    }
    echo "<a href=\"$urlsort\">";
    echo "status";
    echo "</a>";
    echo "&nbsp;&nbsp;&nbsp;</td>";
}
?>

</tr>


<?
$usr = $_SESSION['usr'];
$ips = getips($usr, $sql);
$ips_this_page = getipsforpage($ips, $max_hosts_per_page, $selectedoff);
$traffic = array();
foreach ($ips_this_page as $ip) {
    if ($by == "hour") {
        $t = gettrafficbyhour($dir, $ip, $selectedyear, $selectedmonth, $selectedday, $selectedhour);
    }
    if ($by == "day") {
        $t = gettrafficbyday($dir, $ip, $selectedyear, $selectedmonth, $selectedday);
    }
    if ($by == "month") {
        $t = gettrafficbymonth($dir, $ip, $selectedyear, $selectedmonth);
    }
    if ($by == "year") {
        $t = gettrafficbyyear($dir, $ip, $selectedyear);
    }
    $totalin = $totalin + $t['in'];
    $totalout = $totalout + $t['out'];
    $totalall = $totalall + $t['total'];
    $traffic = array_merge($traffic, array($t));
}

$traffic = sort_traffic($traffic, $selectedsortby, $selectedsorttype);
$nr = 0;
foreach ($traffic as $t) {
    $host = $t['ip'];
    $hostname = $host;
    if ($hostnames == 1) {
	$hostname = gethostbyaddr($host);
    }
    $client = $t['client'];
    $in = getbytes($t['in']);
    $out = getbytes($t['out']);
    $total = getbytes($t['total']);
    $status = $t['status'];
    $nr++;
    echo "<tr>\n";
    echo "<td class=\"tdcolumn\" align=\"center\">&nbsp;&nbsp;&nbsp;$nr&nbsp;&nbsp;&nbsp;</td>\n";
    echo "<td class=\"tdcolumn\" align=\"center\">&nbsp;&nbsp;&nbsp;<a href=\"info.php?host=$host\">$hostname</a>&nbsp;&nbsp;&nbsp;</td>\n";
    echo "<td class=\"tdcolumn\" align=\"center\">&nbsp;&nbsp;&nbsp;$in&nbsp;&nbsp;&nbsp;</td>\n";
    echo "<td class=\"tdcolumn\" align=\"center\">&nbsp;&nbsp;&nbsp;$out&nbsp;&nbsp;&nbsp;</td>\n";
    echo "<td class=\"tdcolumn\" align=\"center\">&nbsp;&nbsp;&nbsp;$total&nbsp;&nbsp;&nbsp;</td>\n";
    echo "<td class=\"tdcolumn\" align=\"center\">&nbsp;&nbsp;&nbsp;~ ".intval($t['total']/date(i)/60*8/1024)." kbs&nbsp;&nbsp;&nbsp;</td>\n";
    echo "</tr>\n";
}

$totalin = getbytes($totalin);
$totalout = getbytes($totalout);
$totalall = getbytes($totalall);

echo "<tr>\n";
echo "<td class=\"tdheader\" align=\"right\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\n";
echo "<td class=\"tdheader\" align=\"right\">&nbsp;&nbsp;&nbsp;total:&nbsp;&nbsp;&nbsp;</td>\n";
echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;$totalin&nbsp;&nbsp;&nbsp;</td>\n";
echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;$totalout&nbsp;&nbsp;&nbsp;</td>\n";
echo "<td class=\"tdheader\" align=\"center\">&nbsp;&nbsp;&nbsp;$totalall&nbsp;&nbsp;&nbsp;</td>\n";
echo "<td class=\"tdheader\" align=\"right\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\n";
echo "</tr>\n";

echo "<tr>\n";
$numpages = getnumpages($ips, $max_hosts_per_page);
if ($numpages > 1) {
    echo "<td colspan=\"4\" align=\"center\" class=\"tdcolumn\">&nbsp;&nbsp;&nbsp;\n";
    for ($i = 0;$i < $numpages; $i++) {
	$off = $i * $max_hosts_per_page;
	$npag = $i + 1;
	if ($off == $selectedoff) {
	    if ($by == "year") {
		echo "<font color=\"$color2\">\n";
            	echo "<b>[<a href=\"traffic.php?by=$by&year=$selectedyear&off=$off\">$npag</a>]</b> \n";
		echo "<font color=\"$color1\">\n";
    	    }
    	    if ($by == "month") {
		echo "<font color=\"$color2\">\n";
            	echo "<b>[<a href=\"traffic.php?by=$by&year=$selectedyear&month=$selectedmonth&off=$off\">$npag</a>]</b> \n";
		echo "<font color=\"$color1\">\n";
    	    }
    	    if ($by == "day") {
		echo "<font color=\"$color2\">\n";
            	echo "<b>[<a href=\"traffic.php?by=$by&year=$selectedyear&month=$selectedmonth&day=$selectedday&off=$off\">$npag</a>]</b> \n";
		echo "<font color=\"$color1\">\n";
    	    }
    	    if ($by == "hour") {
		echo "<font color=\"$color2\">\n";
            	echo "<b>[<a href=\"traffic.php?by=$by&year=$selectedyear&month=$selectedmonth&day=$selectedday&hour=$selectedhour&off=$off\">$npag</a>]</b> \n";
		echo "<font color=\"$color1\">\n";
	    }
	} else {
    	    if ($by == "year") {
		echo "<a href=\"traffic.php?by=$by&year=$selectedyear&off=$off\">$npag</a> \n";
    	    }
	    if ($by == "month") {
		echo "<a href=\"traffic.php?by=$by&year=$selectedyear&month=$selectedmonth&off=$off\">$npag</a> \n";
	    }
	    if ($by == "day") {
		echo "<a href=\"traffic.php?by=$by&year=$selectedyear&month=$selectedmonth&day=$selectedday&off=$off\">$npag</a> \n";
	    }
	    if ($by == "hour") {
		echo "<a href=\"traffic.php?by=$by&year=$selectedyear&month=$selectedmonth&day=$selectedday&hour=$selectedhour&off=$off\">$npag</a> \n";
	    }
	}
    }
    echo "&nbsp;&nbsp;&nbsp;</td>\n";
}

?>

</table>

<?
require("include/menu.php");
?>
