<?
//$Id: functions-ipfm.php,v 1.8 2004/10/26 13:59:11 eu Exp $
/*
Copyright (C) 2004 Radu Anghel <eu@celuloza.ro>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

$phpversion = explode(".", phpversion());

if ($phpversion[0] < 5) {
    require("functions-php4.php");
}

function getavailableyears($ipfmdir) {
    $dir = scandir($ipfmdir);
    $res = array();
    foreach ($dir as $f) {
	if (is_dir($ipfmdir . "/" . $f)) {
	    if (($f != ".") & ($f != "..")) {
	        $res = array_merge($res, array($f));
	    }
	}
    }
    return $res;
}

function getavailablemonths($ipfmdir, $year) {
    $mdir = $ipfmdir . "/" . $year;
    $dir = scandir($mdir);
    $res = array();
    foreach ($dir as $f) {
        if (is_dir($mdir . "/" . $f)) {
            if (($f != ".") & ($f != "..")) {
                $res = array_merge($res, array($f));
            }
        }
    }
    return $res;
}

function getavailabledays($ipfmdir, $year, $month) {
    $mdir = $ipfmdir . "/" . $year . "/" . $month;
    $dir = scandir($mdir);
    $res = array();
    foreach ($dir as $f) {
	if (is_dir($mdir . "/" . $f)) {
	    if (($f != ".") & ($f != "..")) {
		$res = array_merge($res, array($f));
	    }
	}
    }
    return $res;
}

function getavailablehours($ipfmdir, $year, $month, $day) {
    $mdir = $ipfmdir . "/" . $year . "/" . $month . "/" . $day;
    $dir = scandir($mdir);
    $res = array();
    foreach ($dir as $f) {
        if (is_file($mdir . "/" . $f)) {
            if (($f != ".") & ($f != "..")) {
                $res = array_merge($res, array($f));
            }
        }
    }
    return $res;
}

function gettrafficbyhour($ipfmdir, $ip, $year, $month, $day, $hour) {
    $file = $ipfmdir . "/" . $year . "/" . $month . "/" . $day . "/" . $hour;
    $longip = ip2long($ip);
    $res = array('ip' => $ip, 'in' => 0, 'out' => 0, 'total' => 0, 'longip' => $longip);
    if (is_readable($file)) {
	$lines = file($file);
	foreach ($lines as $line) {
	    if (!stristr($line, "#")) {
		$line = preg_replace('/\s+/', ' ', $line);
		list($host, $in, $out, $total) = split(" ", $line);
		if ("$host" == "$ip") {
		    $res = array('ip' => $ip, 'in' => $in, 'out' => $out, 'total' => $total, 'longip' => $longip);
		}
	    }
	}
    }
    return $res;
}

function gettrafficbyday($ipfmdir, $ip, $year, $month, $day) {
    $longip = ip2long($ip);
    $res = array('ip' => $ip, 'in' => 0, 'out' => 0, 'total' => 0);
    $hours = getavailablehours($ipfmdir, $year, $month, $day);
    foreach ($hours as $hour) {
	$tmp = gettrafficbyhour($ipfmdir, $ip, $year, $month, $day, $hour);
	$res['in'] = $res['in'] + $tmp['in'];
	$res['out'] = $res['out'] + $tmp['out'];
	$res['total'] = $res['total'] + $tmp['total'];
    }
    return $res;
}

function gettrafficbymonth($ipfmdir, $ip, $year, $month) {
    $longip = ip2long($ip);
    $res = array('ip' => $ip, 'in' => 0, 'out' => 0, 'total' => 0, 'longip' => $longip);
    $days = getavailabledays($ipfmdir, $year, $month);
    foreach ($days as $day) {
	$tmp = gettrafficbyday($ipfmdir, $ip, $year, $month, $day);
	$res['in'] = $res['in'] + $tmp['in'];
        $res['out'] = $res['out'] + $tmp['out'];
        $res['total'] = $res['total'] + $tmp['total'];
    }
    return $res;
}

function gettrafficbyyear($ipfmdir, $ip, $year) {
    $longip = ip2long($ip);
    $res = array('ip' => $ip, 'in' => 0, 'out' => 0, 'total' => 0, 'longip' => $longip);
    $months = getavailablemonths($ipfmdir, $year);
    foreach ($months as $month) {
	$tmp = gettrafficbymonth($ipfmdir, $ip, $year, $month);
	$res['in'] = $res['in'] + $tmp['in'];
        $res['out'] = $res['out'] + $tmp['out'];
        $res['total'] = $res['total'] + $tmp['total'];
    }
    return $res;
}

?>
