<?php

require_once('utilities/smart_backup_class.php');
require_once('utilities/archive.php');

class CLocalBackupWriter {

var $smartbackup;
var $smartbackup_type;
var $file_handle;
var $backupname;
var $compression;
var $saveDir;
var $zipfile;

function CLocalBackupWriter($smartbackup_, $smartbackup_type_, $compression_, $saveDir_){
	$this->smartbackup = $smartbackup_;
	$this->smartbackup_type = $smartbackup_type_;
	$this->compression = $compression_;
	$this->saveDir = str_replace('\\', '/', $saveDir_);

	if (substr($this->saveDir, -1) != '/') {
		$this->saveDir .= '/';
    }

    if(isset($this->smartbackup) && $this->smartbackup == 'true')
	{
		$this->backupname = 'smart_backup';
		$this->zipfile = new smart_backup($this->saveDir . $this->backupname);
		$this->zipfile->set_options(array('inmemory' => 1));
	}
	else
	{
		$rand = rand(1000,9999);
		$this->backupname = str_replace('date', date('d_M_Y_H-i-s'), '{date}_'.$rand.'_backup');

		if (isset($this->compression) && $this->compression == 'gzip') {
	        $this->backupname  .= '.tgz';
	        $this->zipfile = new gzip_file($this->saveDir . $this->backupname);
	    } else if (isset($this->compression) && $this->compression == 'zip') {
	        $this->backupname  .= '.zip';
	        $this->zipfile = new zip_file($this->saveDir . $this->backupname);
	    }
	}
}

function excludeExtensions($list){
	$this->zipfile->exclude_files_ext($list);
}

function includeOnlyExtensions($list){
	$this->zipfile->include_only_ext($list);
}

function excludeLarger($size){
	$this->zipfile->exclude_files_size($size);
}

function includeLarger($size){
	$this->zipfile->include_files_size($size);
}

function addFile($filename){
	$this->zipfile->add_file($filename);
}

function addDir($dirname){
	$this->zipfile->add_dir($dirname);
}

function close(){
	if(isset($this->smartbackup) && $this->smartbackup == 'true')
	{
		$pwd = getcwd();

		$this->zipfile->create_archive();

		$backPath = $this->saveDir.$this->backupname;
		//create root backup folder if needed
		if(!is_dir($backPath)) mkdir($backPath);

		//get old .smart.xml
		$oldXML = @file_get_contents($backPath.'/.smart.xml');
		$this->zipfile->compareXML($oldXML);

		//put new .smart.xml
		file_put_contents ($backPath.'/.smart.xml', $this->zipfile->newXML());

		//make dir structure
		$this->makeDirStructure($this->zipfile->getNewDir());

		//upload files
		$this->uploadFiles($this->zipfile->getNewFileArr());

		//toLog('getNewDirTree', $this->zipfile->getNewDirTree());
		//toLog('getNewFileArr', $this->zipfile->getNewFileArr());

		//toLog('getDeleteDirTree', $this->zipfile->getDeleteDir());
		//toLog('getDeleteFileArr', $this->zipfile->getDeleteFileArr());

		//clean up unused files and folders
		if($this->smartbackup_type == 'mirror')
		{
			//delete files
			$this->deleteFiles($this->zipfile->getDeleteFileArr());
			//delete folders
			$this->deleteDirs($this->zipfile->getDeleteDir());
		}

		chdir($pwd);
	}
	else
	{
		$this->zipfile->create_archive();
	}
}

function makeDirStructure($dirArr) {
	$pwd = $this->saveDir.$this->backupname;
	chdir($pwd);
	foreach($dirArr as $key => $value) {
		if(!is_dir($value['name']))
		{
			$this->mkdirs($value['name']);
			chdir($pwd);
		}
	}
}

function mkdirs($strPath)
{
	 if (is_dir($strPath)) return true;

	 $pStrPath = dirname($strPath);
	 if (!$this->mkdirs($pStrPath)) return false;
	 return mkdir($strPath);
}


function uploadFiles($fileArr) {
	$pwd = $this->saveDir.$this->backupname;
	chdir($pwd);
	foreach($fileArr as $key => $value) {
		copy($key, $value['name']);
		chdir($pwd);
	}
}

function deleteDirs($dirArr) {
	$pwd = $this->saveDir.$this->backupname;
	chdir($pwd);
	foreach($dirArr as $key => $value) {
		$this->rmdirs($value['name']);
		chdir($pwd);
	}
}

function rmdirs($dir){
	$current_dir = opendir($dir);
	while($entryname = readdir($current_dir)) {
		if(is_dir("$dir/$entryname") && ($entryname != "." && $entryname!="..")) {
			$this->rmdirs("${dir}/${entryname}");
		} elseif ($entryname != "." && $entryname != "..") {
			unlink("${dir}/${entryname}");
		}
	}
	closedir($current_dir);
	rmdir(${dir});
}

function deleteFiles($fileArr) {
	$pwd = $this->saveDir.$this->backupname;
	chdir($pwd);
	foreach($fileArr as $key => $value) {
		unlink($value['name']);
		chdir($pwd);
	}
}
}

?>