<?php

require_once('utilities/ftp_class.php');
require_once('utilities/ftp_class_pure.php');
require_once('utilities/utils.php');
require('utilities/zip.lib.php');

class CFTPWriter {

var $dump_buffer;
var $compression;
var $extension;
var $ftp_host;
var $login;
var $password;
var $saveDir;
var $filename;

function CFTPWriter($compression_, $extension_, $save_dir_, $ftp_host_, $login_, $password_,$filename_){
	$this->compression = $compression_;
	$this->extension = $extension_;
	$this->ftp_host = $ftp_host_;
	$this->login = $login_;
	$this->password = $password_;
	$this->saveDir = $save_dir_;
	
   //form file name. may be i will using macro-substitution in future	
	if(strcasecmp($filename_, '(date)_backup') != 0)
	{
	   	$this->filename = $filename_;
		$this->filename .= $this->extension;
   	}
	else
	{
		$this->filename = str_replace('date', gmdate('d_M_Y_H-i-s'), '{date}_backup');	
		$this->filename .= $this->extension;
	}
	if (isset($this->compression) && $this->compression == 'gzip') {
        $this->filename  .= '.gz';
    } else if (isset($this->compression) && $this->compression == 'zip') {
        $this->filename  .= '.zip';
    }	
}
	
function write($line){
	$this->dump_buffer .= $line;
 	return TRUE;
} 	

function close(){
    if (isset($this->compression) && $this->compression == 'zip') {
        if (@function_exists('gzcompress')) {
        	$zip = new zipfile();
        	$zip->addfile($this->dump_buffer, substr($this->filename, 0, -4));
            $this->dump_buffer = $zip->file();
        }
    }
    else if (isset($this->compression) && $this->compression == 'gzip') {
        if (@function_exists('gzencode')) {
            $this->dump_buffer = gzencode($this->dump_buffer);
        }
    }	
    
    $ftp = new ftp(TRUE); 
	$ftp->Verbose = TRUE;
	$ftp->LocalEcho = FALSE;
	if($ftp->SetServer($this->ftp_host) && $ftp->connect() && $ftp->login($this->login, $this->password)) {
		$ftp->chdir($this->saveDir); 
		$ftp->putBuffer($this->dump_buffer, $this->filename);
	}	
	
	$ftp->quit(); 
}

}

?>