<?php

require_once('utilities/ftp_class.php');
require_once('utilities/ftp_class_pure.php');
require_once('utilities/archive.php');
require_once('utilities/smart_backup_class.php');
require_once('utilities/utils.php');

class CFTPBackupWriter {

var $dump_buffer;
var $compression;
var $smartbackup;
var $smartbackup_type;
var $ftp_host;
var $login;
var $password;
var $saveDir;
var $backupname;
var $backPath;
var $zipfile;
var $ftp;

function CFTPBackupWriter($smartbackup_, $smartbackup_type_, $compression_, $save_dir_, $ftp_host_, $login_, $password_,$backupname_){
	$this->smartbackup = $smartbackup_;
	$this->smartbackup_type = $smartbackup_type_;
	$this->compression = $compression_;
	$this->ftp_host = $ftp_host_;
	$this->login = $login_;
	$this->password = $password_;
	$this->saveDir = $save_dir_;

	if(isset($this->smartbackup) && $this->smartbackup == 'true')
	{
		if(strlen(trim($backupname_)) != 0)
			$this->backupname = $backupname_;
		else
			$this->backupname = '';

		$this->zipfile = new smart_backup($this->saveDir . $this->backupname);
		$this->zipfile->set_options(array('inmemory' => 1));
	}
	else
	{
		if(strcasecmp($backupname_, '(date)_backup') != 0)
		{
			$this->backupname = $backupname_;
		}
		else
		{
			$rand = rand(1000,9999);
			$this->backupname = str_replace('date', date('d_M_Y_H-i-s'), '{date}_'.$rand.'_backup');
		}

		if (isset($this->compression) && $this->compression == 'gzip') {
	        $this->backupname  .= '.tgz';
	        $this->zipfile = new gzip_file($this->saveDir . $this->backupname);
	    } else if (isset($this->compression) && $this->compression == 'zip') {
	        $this->backupname  .= '.zip';
	        $this->zipfile = new zip_file($this->saveDir . $this->backupname);
	    }

	    $this->zipfile->set_options(array('inmemory' => 1));
	}
}

function excludeExtensions($list){
	$this->zipfile->exclude_files_ext($list);
}

function includeOnlyExtensions($list){
	$this->zipfile->include_only_ext($list);
}

function excludeLarger($size){
	$this->zipfile->exclude_files_size($size);
}

function includeLarger($size){
	$this->zipfile->include_files_size($size);
}

function addFile($filename){
	$this->zipfile->add_file($filename);
}

function addDir($dirname){
	$this->zipfile->add_dir($dirname);
}

function close(){
	$this->ftp = new ftp(TRUE);
	$this->ftp->Verbose = TRUE;
	$this->ftp->LocalEcho = FALSE;
	$ftpReady = $this->ftp->SetServer($this->ftp_host) && $this->ftp->connect() && $this->ftp->login($this->login, $this->password);

	if($ftpReady) {
		if(isset($this->smartbackup) && $this->smartbackup == 'true')
		{
			$this->zipfile->create_archive();

			$this->backPath = $this->saveDir;
			if($this->backupname != '')
			{
				$this->backPath = $this->saveDir.'/'.$this->backupname;
				//create root backup folder if needed
				if($this->ftp->is_exists($this->backPath) <= 0)
				{
					$this->ftp->chdir($this->saveDir);
					$this->ftp->mkdir($this->backupname);
					$this->ftp->cdup();
				}
			}

			$this->changeDir($this->backPath);

			//get old .smart.xml
			$oldXML = $this->ftp->getBuffer('.smart.xml');
			$this->zipfile->compareXML($oldXML);

			//put new .smart.xml
			$this->ftp->putBuffer($this->zipfile->newXML(), '.smart.xml');

			//make dir structure
			$this->makeDirStructure($this->backPath, $this->zipfile->getNewDirTree());

			//upload files
			$this->uploadFiles($this->zipfile->getNewFileArr());

			//toLog('getNewDirTree', $this->zipfile->getNewDirTree());
			//toLog('getNewFileArr', $this->zipfile->getNewFileArr());

			//toLog('getDeleteDirTree', $this->zipfile->getDeleteDir());
			//toLog('getDeleteFileArr', $this->zipfile->getDeleteFileArr());

			//clean up unused files and folders
			if($this->smartbackup_type == 'mirror')
			{
				//delete files
				$this->deleteFiles($this->zipfile->getDeleteFileArr());
				//delete folders
				$this->deleteDirs($this->zipfile->getDeleteDir());
			}
		}
		else
		{
			$this->zipfile->create_archive();
			$this->dump_buffer = $this->zipfile->archive;
			$this->ftp->chdir($this->saveDir);
			$this->ftp->putBuffer($this->dump_buffer, $this->backupname);
		}
	}
	$this->ftp->quit();
}

function makeDirStructure($currPath, $dirTreeArr) {
	$this->changeDir($currPath);
	foreach($dirTreeArr as $key => $value) {
		if($this->ftp->is_exists('/'.$key) <= 0)
		{
			$this->ftp->mkdir($key);
			if(count($value) > 0) {
				$this->makeDirStructure($key, $value);
				$this->ftp->cdup();
			}
		}
	}
}

function uploadFiles($fileArr) {
	$this->applyFileFunc($fileArr, 'put');
}

function deleteDirs($dirArr) {
	$this->applyFileFunc($dirArr, 'rmdir');
}

function deleteFiles($fileArr) {
	$this->applyFileFunc($fileArr, 'delete');
}

function applyFileFunc($fileArr, $func) {
	foreach($fileArr as $key => $value) {
		$path  = explode('/', $this->backPath.'/'.$value['name']);
		$fname = array_pop($path);

		$pwd = explode('/', substr($this->ftp->pwd(), 1));
		$i   = 0;
		while(isset($pwd[$i]) && $path[$i] == $pwd[$i]) {
			$i++;
		}

		if($i < count($pwd))
		{
			$this->changeDirUp(count($pwd)-$i);
		}
		if($i < count($path))
		{
			$this->changeDir(implode('/', array_slice($path, $i)));
		}

		switch($func) {
			case 'put':
				$this->ftp->put($key, $fname);
				break;
			case 'delete':
				$this->ftp->delete($fname);
				break;
			case 'rmdir':
				$this->ftp->rmdir($fname);
				break;
		}
	}
}

function changeDir($path) {
	$dirs = explode('/', $path);
	foreach($dirs as $dir)
	{
		if($this->ftp->chdir($dir) <= 0) break;
	}
}

function changeDirUp($times) {
	for($i = 0; $i < $times; $i++) $this->ftp->cdup();
}

}
?>