<?php

require_once('utilities/utils.php');
require('utilities/zip.lib.php');

class CFileWriter {
	
var $file_handle;
var $filename;
var $compression;
var $dump_buffer;
var $saveDir;
var $extension;

function CFileWriter($compression_, $extension_, $saveDir_){
	
	$this->compression = $compression_;
	$this->extension = $extension_;
	$this->saveDir = str_replace('\\', '/', $saveDir_);
		
	//form target directory. may be i will using macro-substitution in future
    if (substr($this->saveDir, -1) != '/') {
            $this->saveDir .= '/';
    }
 	
    //form file name. may be i will using macro-substitution in future
	$this->filename = str_replace('date', gmdate('d_M_Y_H-i-s'), '{date}_backup');	
	$this->filename .= $this->extension;
	
	if (isset($this->compression) && $this->compression == 'gzip') {
        $this->filename  .= '.gz';
    } else if (isset($this->compression) && $this->compression == 'zip') {
        $this->filename  .= '.zip';
    }
	
    $save_filename = $this->saveDir . $this->filename;
   	$this->file_handle = @fopen($save_filename, 'x');
	
}

function write($line){
	if (isset($this->compression) && ($this->compression == 'zip' | $this->compression == 'gzip')) {
        $this->dump_buffer .= $line;
	} else{
		@fwrite($this->file_handle, $line);
	}
 	return TRUE;
} 	

function close(){
    if (isset($this->compression) && $this->compression == 'zip') {
        if (@function_exists('gzcompress')) {
        	$zip = new zipfile();
        	$zip->addfile($this->dump_buffer, substr($this->filename, 0, -4));
            $this->dump_buffer = $zip->file();
            @fwrite($this->file_handle, $this->dump_buffer);
        }
    }
    else if (isset($this->compression) && $this->compression == 'gzip') {
        if (@function_exists('gzencode')) {
            $this->dump_buffer = gzencode($this->dump_buffer);
            @fwrite($this->file_handle, $this->dump_buffer);
        }
    }	
    @fclose($this->file_handle);
}

}
?>