<?php

require_once('utilities/utils.php');
require('utilities/class.phpmailer.php');
require('utilities/zip.lib.php');

class CEmailWriter {

var $filename;
var $compression;
var $dump_buffer;
var $mime_type;
var $send_type;
var $extension;
var $selected_database;

var $mail_to;
var $mail_cc;
var $mail_subject;
var $mail_format;
var $smtp_host;
var $smtp_port;
var $smtp_auth;
var $smtp_user;
var $smtp_passw;
var $sendmail_path;
var $adminuser;

function CEmailWriter($compression_, $mime_type_, $send_type_, $mail_to_, $mail_cc_, $mail_subject_, $mail_format_, $smtp_host_, $smtp_port_, $smtp_auth_, $smtp_user_, $smtp_passw_, $sendmail_path_, $extension_,$selected_database_, $adminuser){

    $this->compression = $compression_;
    $this->extension = $extension_;
    $this->send_type = $send_type_;
    $this->mime_type = $mime_type_;
    $this->mail_to = $mail_to_;
    $this->mail_cc = $mail_cc_;
    $this->mail_subject = stripslashes($mail_subject_);
    $this->mail_format = $mail_format_;
    $this->smtp_host = $smtp_host_;
    $this->smtp_port = $smtp_port_;
    $this->smtp_auth = $smtp_auth_;
    $this->smtp_user = $smtp_user_;
    $this->smtp_passw = $smtp_passw_;
    $this->sendmail_path = $sendmail_path_;
    $this->selected_database = $selected_database_;
    $this->adminuser = $adminuser;

    //form file name. may be i will using macro-substitution in future
    $this->filename = str_replace('date', gmdate('d_M_Y_H-i-s'), '{date}_backup');
    $this->filename .= $this->extension;

    if (isset($this->compression) && $this->compression == 'gzip') {
        $this->filename  .= '.gz';
    } else if (isset($this->compression) && $this->compression == 'zip') {
        $this->filename  .= '.zip';
    }

}

function write($line){
    $this->dump_buffer .= $line;
    return TRUE;
}

function close(){
    if (isset($this->compression) && $this->compression == 'zip') {
        if (@function_exists('gzcompress')) {
            $zip = new zipfile();
            $zip->addfile($this->dump_buffer, substr($this->filename, 0, -4));
            $this->dump_buffer = $zip->file();
         }
    }
    else if (isset($this->compression) && $this->compression == 'gzip') {
        if (@function_exists('gzencode')) {
            $this->dump_buffer = gzencode($this->dump_buffer);
        }
    }

    $mail = new PHPMailer();
    $mail->From = FROM_EMAIL;
    $mail->FromName = FROM_EMAIL_NAME;
    $mail->Subject = $this->mail_subject;
    $mail->AddAddress($this->mail_to);

    if($this->mail_cc != '') {
        $mail->AddCC($this->mail_cc,$this->mail_cc);
    }
    $mailbody = '';

    $mailbody = $GLOBALS['MAIL_BODY1']." ".$this->adminuser.","."\n\n";
    $mailbody.= $GLOBALS['MAIL_BODY2']." '".$this->selected_database."' ".$GLOBALS['MAIL_BODY3']."\n";
    $mailbody.= $GLOBALS['MAIL_BODY4'];

    $mail->Body = $mailbody;
    $mail->AddStringAttachment($this->dump_buffer, $this->filename, "base64", $this->mime_type);

    if (!isset($this->send_type) || $this->send_type == 'php_mail'){
        $mail->IsMail();
    } else if ($this->send_type == 'send_mail') {
        $mail->IsSendmail();
        $mail->Sendmail = $this->sendmail_path;
    } else if ($this->send_type == 'smtp_mail') {
        $mail->IsSMTP();

        $mail->Host = $this->smtp_host;
        $mail->Port = $this->smtp_port;
        $mail->SMTPAuth = $this->smtp_auth;
        $mail->Username = $this->smtp_user;
        $mail->Password = $this->smtp_passw;
    }

    if (isset($this->mail_format) && $this->mail_format == 'html'){
        $mail->IsHTML(true);
    }
    else {
        $mail->IsHTML(false);
    }

    if (!$mail->Send()){
        echo "Mailer Error: " . $mail->ErrorInfo;
    }
}
}

?>
