<?php

require_once('utilities/utils.php');
require('utilities/class.phpmailer.php');
require_once('utilities/archive.php');

class CEmailBackupWriter {

var $backupname;
var $compression;
var $dump_buffer;
var $mime_type;
var $send_type;
var $selected_files;

var $mail_to;
var $mail_cc;
var $mail_subject;
var $mail_format;
var $smtp_host;
var $smtp_port;
var $smtp_auth;
var $smtp_user;
var $smtp_passw;
var $sendmail_path;
var $zipfile;
var $adminuser;

function CEmailBackupWriter($compression_, $send_type_, $mail_to_, $mail_cc_, $mail_subject_, $mail_format_, $smtp_host_, $smtp_port_, $smtp_auth_, $smtp_user_, $smtp_passw_, $sendmail_path_,$selected_files_, $adminuser){

    $this->compression = $compression_;
    $this->send_type = $send_type_;
    $this->mail_to = $mail_to_;
    $this->mail_cc = $mail_cc_;
    $this->mail_subject = $mail_subject_;
    $this->mail_format = $mail_format_;
    $this->smtp_host = $smtp_host_;
    $this->smtp_port = $smtp_port_;
    $this->smtp_auth = $smtp_auth_;
    $this->smtp_user = $smtp_user_;
    $this->smtp_passw = $smtp_passw_;
    $this->sendmail_path = $sendmail_path_;
    $this->selected_files = $selected_files_;
    $this->adminuser = $adminuser;

    $this->backupname = str_replace('date', date('d_M_Y_H-i-s'), '{date}_backup');

    if (isset($this->compression) && $this->compression == 'gzip') {
        $this->backupname  .= '.tgz';
        $this->mime_type = 'application/x-gzip';
        $this->zipfile = new gzip_file($this->backupname);
    } else if (isset($this->compression) && $this->compression == 'zip') {
        $this->backupname  .= '.zip';
        $this->mime_type = 'application/zip';
        $this->zipfile = new zip_file($this->backupname);
    }

    $this->zipfile->set_options(array('inmemory' => 1));
}

function excludeExtensions($list){
    $this->zipfile->exclude_files_ext($list);
}

function includeOnlyExtensions($list){
    $this->zipfile->include_only_ext($list);
}

function excludeLarger($size){
    $this->zipfile->exclude_files_size($size);
}

function includeLarger($size){
    $this->zipfile->include_files_size($size);
}

function addFile($filename){
    $this->zipfile->add_file($filename);
}

function addDir($dirname){
    $this->zipfile->add_dir($dirname);
}

function close(){
    $this->zipfile->create_archive();
    $this->dump_buffer = $this->zipfile->archive;

    $mail = new PHPMailer();
    $mail->From = FROM_EMAIL;
    $mail->FromName = FROM_EMAIL_NAME;
    $mail->Subject = $this->mail_subject;
    $mail->AddAddress($this->mail_to);

    if($this->mail_cc != '') {
        $mail->AddCC($this->mail_cc,$this->mail_cc);
    }

    $mailbody = '';

    if (isset($this->mail_format) && $this->mail_format == 'html')
    {
        $mailbody = "Dear ".$this->adminuser.","."<br><br>";
        $mailbody.= "Your request for backup of : "."<br>";
        foreach($this->selected_files as $key=>$val)
                $mailbody.= $val."<br>";
        $mailbody.= "has successfully completed."."<br><br>";
        $mailbody.= "Please download the attachment to view the contents of this backup.";
    }
    else
    {
        $mailbody = $GLOBALS['MAIL_BODY1'].$this->adminuser.","."\n\n";
        $mailbody.= $GLOBALS['MAIL_BODY22']."\n";
        foreach($this->selected_files as $key=>$val)
                $mailbody.= $val."\n";
        $mailbody.= $GLOBALS['MAIL_BODY3']."\n";
        $mailbody.= $GLOBALS['MAIL_BODY4'];

        $mailbody = $GLOBALS['MAIL_BODY1'].$this->adminuser.","."\n\n";
        $mailbody.= $GLOBALS['MAIL_BODY2'].$this->selected_database.$GLOBALS['MAIL_BODY3']."\n";
        $mailbody.= $GLOBALS['MAIL_BODY4'];

    }



    $mail->Body = $mailbody;

    $mail->AddStringAttachment($this->dump_buffer, $this->backupname, "base64", $this->mime_type);

    if (!isset($this->send_type) || $this->send_type == 'php_mail'){
        $mail->IsMail();
    } else if ($this->send_type == 'send_mail') {
        $mail->IsSendmail();
        $mail->Sendmail = $this->sendmail_path;
    } else if ($this->send_type == 'smtp_mail') {
        $mail->IsSMTP();

        $mail->Host = $this->smtp_host;
        $mail->Port = $this->smtp_port;
        $mail->SMTPAuth = $this->smtp_auth;
        $mail->Username = $this->smtp_user;
        $mail->Password = $this->smtp_passw;
    }

    if (isset($this->mail_format) && $this->mail_format == 'html'){
        $mail->IsHTML(true);
    }
    else {
        $mail->IsHTML(false);
    }

    if (!$mail->Send()){
        echo "Mailer Error: " . $mail->ErrorInfo;
    }
}

}

?>
