<?php

require_once('archive.php');
require_once('myxml.inc.php');

class smart_backup extends archive {
	var $dir_arr = array();
	var $file_arr = array();

	var $newdir_arr = array();
	var $newfile_arr = array();

	var $deletedir_arr = array();
	var $deletefile_arr = array();

	var $dir_tree = array();


	function create_archive()
	{
		$this->make_list();
		$this->make_separate_list();
	}

	function make_separate_list() {
		foreach ($this->files as $current)
		{
			$params = array('name' => $this->preparePathName($current['name']));
			if ($current['type'] == 5) {
				$this->dir_arr[$current['name']] = array_merge($params, $current['stat']);
			} else if ($current['type'] == 0) {
				$this->file_arr[$current['name']] = array_merge($params, $current['stat']);
			}
		}

		uksort($this->file_arr, array($this, "cmp"));
	}

	function cmp($a, $b) {
	   return strcmp($a, $b);
	}

	function preparePathName($name) {
		$parts = explode('/', $name);
		$newname = array();
		foreach($parts as $part) {
			if(!preg_match("/:/i", $part)) $newname[] = $part;
		}
		return implode('/', $newname);
	}

	function makeDirTree($dir_arr) {
		$this->dir_tree = array();
		foreach($dir_arr as $dir) {
			$parts = explode('/', $dir['name']);
			$prev = &$this->dir_tree;
			foreach($parts as $part)
			{
				if(!is_array($prev[$part]))
				{
					$prev[$part] = array();
				}
				$prev = &$prev[$part];
			}
		}
	}

	function newXML() {
		$nl  = "\n";
		$tab = "\t";
		$xml = '<smart_backup>'.$nl;

			$xml .= $tab.'<dirs>'.$nl;
			foreach($this->dir_arr as $key => $value){
				$xml .= $tab.$tab.$this->arr2xml('dir', $value).$nl;
			}
			$xml .= $tab.'</dirs>'.$nl;

			$xml .= $tab.'<files>'.$nl;
			foreach($this->file_arr as $key => $value){
				$xml .= $tab.$tab.$this->arr2xml('file', $value).$nl;
			}
			$xml .= $tab.'</files>'.$nl;

		$xml .= '</smart_backup>';

		return $xml;
	}

	function arr2xml($nodeName, $arr) {
		$params = '';
		foreach($arr as $key => $value) {
			if(!is_int($key)) $params .= $key.'="'.$value.'" ';
		}
		return "<$nodeName $params/>";
	}

	function compareXML($oldXML) {
		if($oldXML == '')
		{
			$this->newdir_arr = $this->dir_arr;
			$this->newfile_arr = $this->file_arr;
			return;
		}

		foreach($this->dir_arr as $key => $dir) {
			$this->newdir_arr[$dir['name']] = array('name2' => $key, 'stat' => $dir);
		}

		foreach($this->file_arr as $key => $file) {
			$this->newfile_arr[$file['name']] = array('name2' => $key, 'stat' => $file);
		}

		$xmlDoc = new myXML($oldXML);
		foreach($xmlDoc->root->children as $child)
		{
			switch($child->name) {
				case 'DIRS':
					foreach($child->children as $dir)
					{
						$dirValue = $this->newdir_arr[$dir->attributes['NAME']];
						if(!isset($dirValue)) {
							$this->deletedir_arr[$dir->attributes['NAME']] = array_change_key_case($dir->attributes,  CASE_LOWER);
						} else if($dirValue['stat']['mtime'] == $dir->attributes['MTIME']){
							unset($this->newdir_arr[$dir->attributes['NAME']]);
						}
					}
					break;
				case 'FILES':
					foreach($child->children as $file)
					{
						$fileValue = $this->newfile_arr[$file->attributes['NAME']];
						if(!isset($fileValue))
						{
							$this->deletefile_arr[$file->attributes['NAME']] = array_change_key_case($file->attributes,  CASE_LOWER);
						}
						else if(
									$fileValue['stat']['mtime'] == $file->attributes['MTIME'] &&
									$fileValue['stat']['size'] == $file->attributes['SIZE']
							   )
						{
							unset($this->newfile_arr[$file->attributes['NAME']]);
						}
					}
					break;
			}
		}

		foreach($this->newdir_arr as $key => $dir) {
			$this->newdir_arr[$dir['name2']] = $dir['stat'];
			unset($this->newdir_arr[$key]);
		}

		foreach($this->newfile_arr as $key => $file) {
			$this->newfile_arr[$file['name2']] = $file['stat'];
			unset($this->newfile_arr[$key]);
		}
	}

	function getNewDirTree() {
		$this->makeDirTree($this->newdir_arr);
		return $this->dir_tree;
	}

	function getNewDir() {
		return $this->newdir_arr;
	}

	function getNewFileArr() {
		return $this->newfile_arr;
	}

	function getDeleteDir() {
		return $this->deletedir_arr;
	}

	function getDeleteFileArr() {
		return $this->deletefile_arr;
	}
}

?>