<?php

require_once('formatter_base.php');
ini_set("magic_quotes_runtime", "Off");

class CSqlFormatter extends CFormatterBase {

var $dump_buffer = '';
var $dump_buffer_len = 0;
var $save_filename = '';
var $sql_constraints;
var $drop_table;
var $use_backquotes;
var $sql_auto_increment;
var $if_not_exists;
var $sql_type;
var $sql_ignore;
var $delayed;
var $showcolumns;
var $extended_ins;
var $hexforbinary;
var $disable_fk;
var $use_transaction;
var $connection;
var $sql_dates;
var $header_comment;

function CSqlFormatter($drop_table, $use_backquotes_, $sql_auto_increment_, $if_not_exists_, $sql_type_, $sql_ignore_, $delayed_, $showcolumns_, $extended_ins_, $hexforbinary_, $disable_fk_, $use_transaction_, $writer_, $connection, $sql_dates, $header_comment) {
	$this->CFormatterBase();

	$this->drop_table = $drop_table;
	$this->use_backquotes = $use_backquotes_;
	$this->sql_auto_increment = $sql_auto_increment_;
	$this->if_not_exists = $if_not_exists_;
	$this->sql_type = $sql_type_;
	$this->sql_ignore = $sql_ignore_;
	$this->delayed = $delayed_;
	$this->showcolumns = $showcolumns_;
	$this->extended_ins = $extended_ins_;
	$this->hexforbinary = $hexforbinary_;
	$this->writer = $writer_;
	$this->disable_fk = $disable_fk_;
	$this->use_transaction = $use_transaction_;
	$this->connection = $connection;
	$this->sql_dates = $sql_dates;
	$this->header_comment = $header_comment;
}

function exportFooter() {
    $foot = '';
    if (isset($this->disable_fk)) {
        $foot .=  $this->crlf . 'SET FOREIGN_KEY_CHECKS=1;' . $this->crlf;
    }
    if (isset($this->use_transaction)) {
    	if ($this->use_transaction != "") {
        	$foot .=  $this->crlf . 'COMMIT;' . $this->crlf;
    	}
    }

    return $this->writer->write($foot);
}

function exportHeader() {
	$head = '';

	if ($this->header_comment != "") {
		$this->header_comment = eregi_replace('\\\n', $this->crlf .$this->comment_marker, $this->header_comment);
		$head .= $this->comment_marker ." ".$this->header_comment.$this->crlf
		.  $this->comment_marker ." " . '--------------------------------------------------------' . $this->crlf;
	}
    if (isset($this->disable_fk)) {
        $head .=  $this->crlf . 'SET FOREIGN_KEY_CHECKS=0;' . $this->crlf;
    }

    if (isset($this->use_transaction)) {
    	if ($this->use_transaction != "") {
	        $head .=  $this->crlf .'SET AUTOCOMMIT=0;' . $this->crlf
	                . 'START TRANSACTION;' . $this->crlf . $this->crlf;
    	}
    }

    return $this->writer->write($head);
}

function exportDBCreate($db) {
    $create_query = 'CREATE DATABASE ' . ($this->use_backquotes ? $this->backquote($db) : $db);
    $create_query .= ';' . $this->crlf;
    if (!$this->writer->write($create_query)) return FALSE;
    return $this->writer->write('USE ' . $db . ';' . $this->crlf);
}

function exportDBHeader($db) {
    $head = $this->comment_marker ." " . $this->crlf
          . $this->comment_marker ." " . chop($this->strDatabase).': ' . ($this->use_backquotes ? $this->backquote($db) : '\'' . $db . '\''). $this->crlf
          . $this->comment_marker ." " . $this->crlf;
    return $this->writer->write($head);
}

function exportDBFooter($db) {
    $result = TRUE;
    if (isset($this->sql_constraints)) {
        $result = $this->writer->write($this->sql_constraints);
        unset($this->sql_constraints);
    }
    return $result;
}

function exportStructure($db, $table, $connection) {
	$result = $connection->getAll('SHOW TABLE STATUS FROM ' . $this->backquote($db) . ' WHERE Name LIKE \'' . str_replace('\\', '\\\\', $table) . '\'', DB_FETCHMODE_ASSOC);
	if(is_array($result))
	{
		$create = $result[0]["Create_time"];
		$update = $result[0]["Update_time"];
	    $formatted_table_name = ($this->use_backquotes) ? $this->backquote($table) : '\'' . $table . '\'';
	    $dump = $this->crlf
	          .  $this->comment_marker ." " . '--------------------------------------------------------' . $this->crlf
	          .  $this->crlf . $this->comment_marker ." " . $this->crlf
	          .  $this->comment_marker ." ". $this->strTableStructure . ' ' . $formatted_table_name . $this->crlf
	          .  $this->comment_marker ." " . $this->crlf
	          .  $this->comment_marker ." " . $this->strCreation.": ".date("M d, Y", strtotime($create)). " at ". date("g:i A", strtotime($update)). $this->crlf
	          .  $this->comment_marker ." " . $this->strLastUpdate.": ".date("M d, Y", strtotime($update)). " at ". date("g:i A", strtotime($update)). $this->crlf
	          .  $this->comment_marker ." " . $this->crlf
	          .	 $this->getTableDef($db, $table, $connection) . ';' . $this->crlf
	          .  $this->getTableComments($db, $table);

	    return $this->writer->write($dump);
	}

	return FALSE;
}

function getTableComments($db, $table)
{
    $schema_create = '';

    return $schema_create;
}

function getTableDef($db, $table, $connection){
    $schema_create = '';
    $auto_increment = '';
    $new_crlf = $this->crlf;

    $result = $connection->getRow('SHOW TABLE STATUS FROM ' . $this->backquote($db) . ' WHERE Name LIKE \'' . str_replace('\\', '\\\\', $table) . '\'', DB_FETCHMODE_ASSOC);
    if (!DB::isError($result)) {
        if (count($result) > 0) {
            if ($this->sql_auto_increment && !empty($result['Auto_increment'])) {
                $auto_increment .= ' AUTO_INCREMENT=' . $result['Auto_increment'] . ' ';
            }
        }
       $connection->freeresult($result);
    } else {
    	$result->getMessage();
    }

    $schema_create .= $new_crlf;

    if (!empty($this->drop_table)) {
        $schema_create .= 'DROP TABLE IF EXISTS ' . $this->backquote($table) . ';' . $this->crlf;
    }

    if ($this->use_backquotes) {
        $connection->query('SET SQL_QUOTE_SHOW_CREATE = 1');
    } else {
        $connection->query('SET SQL_QUOTE_SHOW_CREATE = 0');
    }
    $result = $connection->getRow('SHOW CREATE TABLE ' . $this->backquote($db) . '.' . $this->backquote($table));
    if ($result != "") {
        $create_query = $result[1];
        unset($result);

        if (strpos($create_query, "(\r\n ")) {
            $create_query = str_replace("\r\n", $this->crlf, $create_query);
        } elseif (strpos($create_query, "(\n ")) {
            $create_query = str_replace("\n", $this->crlf, $create_query);
        } elseif (strpos($create_query, "(\r ")) {
            $create_query = str_replace("\r", $this->crlf, $create_query);
        }

        if ($this->if_not_exists) {
            $create_query = preg_replace('/^CREATE TABLE/', 'CREATE TABLE IF NOT EXISTS', $create_query);
        }

        if (preg_match('@CONSTRAINT|FOREIGN[\s]+KEY@', $create_query)) {

            $sql_lines = explode($this->crlf, $create_query);
            $sql_count = count($sql_lines);

            for ($i = 0; $i < $sql_count; $i++) {
                if (preg_match('@^[\s]*(CONSTRAINT|FOREIGN[\s]+KEY)@', $sql_lines[$i])) break;
            }

            if ($i != $sql_count) {

                $sql_lines[$i - 1] = preg_replace('@,$@', '', $sql_lines[$i - 1]);

                if (!isset($this->sql_constraints)) {
                        $this->sql_constraints = $this->crlf . $this->comment_marker ." " .
                        						 $this->crlf . $this->comment_marker ." " .
                                           		 $this->strConstraintsForDumped . $this->crlf . $this->comment_marker ." " . $this->crlf;
                }

                $this->sql_constraints .= $this->crlf . $this->comment_marker ." " .
                					$this->crlf . $this->comment_marker ." " . $this->strConstraintsForTable . ' ' . $this->backquote($table) .
                                  	$this->crlf . $this->comment_marker ." " . $this->crlf;

                $this->sql_constraints .= 'ALTER TABLE ' . $this->backquote($table) . $this->crlf;

                $first = TRUE;
                for($j = $i; $j < $sql_count; $j++) {
                    if (preg_match('@CONSTRAINT|FOREIGN[\s]+KEY@', $sql_lines[$j])) {
                        if (!$first) {
                            $this->sql_constraints .= $this->crlf;
                        }
                        if (strpos($sql_lines[$j], 'CONSTRAINT') === FALSE) {
                            $this->sql_constraints .= preg_replace('/(FOREIGN[\s]+KEY)/', 'ADD \1', $sql_lines[$j]);
                        } else {
                            $this->sql_constraints .= preg_replace('/(CONSTRAINT)/', 'ADD \1', $sql_lines[$j]);
                        }
                        $first = FALSE;
                    } else {
                        break;
                    }
                }
                $this->sql_constraints .= ';' . $this->crlf;
                $create_query = implode($this->crlf, array_slice($sql_lines, 0, $i)) . $this->crlf . implode($this->crlf, array_slice($sql_lines, $j, $sql_count - 1));
                unset($sql_lines);
            }
        }
        $schema_create .= $create_query;
    }

    $schema_create .= $auto_increment;

    #$connection->freeresult($result);
    return $schema_create;
}


function exportData($db, $table, $sql_query, $connection) {

    $formatted_table_name = ($this->use_backquotes) ? $this->backquote($table) : '\'' . $table . '\'';
    $head = $this->crlf
          . $this->comment_marker ." " . $this->crlf
          . $this->comment_marker ." " . $this->strDumpingData . ' ' . $formatted_table_name . $this->crlf
          . $this->comment_marker ." " . $this->crlf .$this->crlf;

    if (!$this->writer->write($head)) return FALSE;

    $buffer = '';

    $result = $connection->query($sql_query);
    $result_fields = $connection->tableInfo($result/*, DB_TABLEINFO_ORDERTABLE*/);
    #echo "<pre>";
    #var_dump($result_fields);
    #exit;
    if (!DB::isError($result_fields)) {
        $fields_cnt = count($result_fields);

        $fields_meta   = array();
    	$num_fields   = count($result_fields);
    	for ($i = 0; $i < $num_fields; $i++) {
        	$fields_meta[] = $result_fields[$i];
    	}
        $field_flags    = array();
        for ($j = 0; $j < $fields_cnt; $j++) {
            $field_flags[$j] = $result_fields[$j]["flags"];
        }
        for ($j = 0; $j < $fields_cnt; $j++) {
        	$field_set[$j] = $this->backquote($fields_meta[$j]["name"], $this->use_backquotes);
        }
        if (isset($this->sql_type) && $this->sql_type == 'update') {
            $schema_insert  = 'UPDATE ';
            if (isset($this->sql_ignore)) {
            	if ($this->sql_ignore != "") {
                	$schema_insert .= 'IGNORE ';
            	}
            }
            $schema_insert .= $this->backquote($table, $this->use_backquotes) . ' SET ';
        } else {
            if (isset($this->sql_type) && $this->sql_type == 'replace') {
                $sql_command    = 'REPLACE';
            } else {
                $sql_command    = 'INSERT';
            }

            if (isset($this->delayed)) {
            	if ($this->delayed != "") {
                	$insert_delayed = ' DELAYED';
            	}
            } else {
                $insert_delayed = '';
            }

            if (isset($this->sql_type) && $this->sql_type == 'insert' && isset($this->sql_ignore)) {
            	if ($this->sql_ignore != "") {
                	$insert_delayed .= ' IGNORE';
            	}
            }

            if (isset($this->showcolumns)) {
            	if ($this->showcolumns != "") {
                	$fields        = implode(', ', $field_set);
                	$schema_insert = $sql_command . $insert_delayed .' INTO ' . $this->backquote($table, $this->use_backquotes)
                               . ' (' . $fields . ') VALUES ';
            	} else {
	                $schema_insert = $sql_command . $insert_delayed .' INTO ' . $this->backquote($table, $this->use_backquotes)
			               . ' VALUES ';
            	}
            } else {
                $schema_insert = $sql_command . $insert_delayed .' INTO ' . $this->backquote($table, $this->use_backquotes)
                               . ' VALUES ';
            }
        }

        $search       = array("\x00", "\x0a", "\x0d", "\x1a");
        $replace      = array('\0', '\n', '\r', '\Z');
        $current_row  = 0;
        $query_size   = 0;
        $separator    = (isset($this->extended_ins) && ($this->extended_ins == "")) ? ',' : ';';

        while ($row = $result->fetchRow(DB_FETCHMODE_ORDERED)) {
            $current_row++;
            for ($j = 0; $j < $fields_cnt; $j++) {
                if (!isset($row[$j]) || is_null($row[$j])) {
                    $values[]     = 'NULL';
                } elseif (isset($fields_meta[$j]["numeric"]) && $fields_meta[$j]["type"] != 'timestamp'
                        && !isset($fields_meta[$j]["blob"])) {
                    $values[] = $row[$j];
                } else if (stristr($field_flags[$j], 'BINARY')
                        && isset($this->hexforbinary)
                        && $fields_meta[$j]["type"] != 'datetime'
                        && $fields_meta[$j]["type"] != 'date'
                        && $fields_meta[$j]["type"] != 'time'
                        && $fields_meta[$j]["type"] != 'timestamp'
                       ) {
                    if (empty($row[$j]) && $row[$j] != '0') {
                        $values[] = '\'\'';
                    } else {
                        $values[] = '0x' . bin2hex($row[$j]);
                    }
                } else {
                		//replaced this line with PEAR DB's quoteSmart function.
                		//this should fix the problem with enescaped quotes.
                		//$values[] = '\'' . str_replace($search, $replace, str_replace('\\', '\\\\', $row[$j])) . '\'';
                    $values[] = $connection->quoteSmart($row[$j]);
                }
            }

            if (isset($this->sql_type) && $this->sql_type == 'update') {

                $insert_line = $schema_insert;
                for ($i = 0; $i < $fields_cnt; $i++) {
                    if ($i > 0) {
                        $insert_line .= ', ';
                    }
                    $insert_line .= $field_set[$i] . ' = ' . $values[$i];
                }

                $insert_line .= ' WHERE ' . $this->getUvaCondition($result, $fields_cnt, $fields_meta, $row);

            } else {

                if ((isset($this->extended_ins)) && ($this->extended_ins == "")) {
                    if ($current_row == 1) {
                        $insert_line  = $schema_insert . '(' . implode(', ', $values) . ')';
                    } else {
                        $insert_line  = '(' . implode(', ', $values) . ')';
                        if (isset($this->max_query_size) && $this->max_query_size > 0 && $query_size + strlen($insert_line) > $this->max_query_size) {
                            if (!$this->writer->write(';' . $crlf)) return FALSE;
                            $query_size = 0;
                            $current_row = 1;
                            $insert_line = $schema_insert . $insert_line;
                        }
                    }
                    $query_size += strlen($insert_line);
                } else {
                    $insert_line = $schema_insert . '(' . implode(', ', $values) . ')';
                }
            }
            unset($values);

            if (!$this->writer->write(($current_row == 1 ? '' : $separator . $this->crlf) . $insert_line)) return FALSE;

        }
        if ($current_row > 0) {
            if (!$this->writer->write(';' . $this->crlf)) return FALSE;
        }
    }
    $connection->freeresult($result);

	return TRUE;
}
function __toString() {
	return "Need to define __toString() method to get some real content";
}
}

?>