<?php

require_once('formatter_base.php'); 

class CLaTeXFormatter extends CFormatterBase  { 

var $latex_caption;
var $latex_data_caption;
var $latex_data_label;
var $showcolumns;
var $latex_data_continued_caption;
var $replace_null;
var $connection;


function CLaTeXFormatter($latex_caption_, $latex_data_caption_, $latex_data_label_, $showcolumns_, 
						 $latex_data_continued_caption_, $replace_null_, $latex_structure_continued_caption_, 
						 $latex_structure_caption_, $latex_structure_label_, $writer_, $connection) {
	$this->CFormatterBase();

	$this->writer = $writer_;
	$this->latex_caption = $latex_caption_;
	$this->latex_data_caption = $latex_data_caption_;
	$this->latex_data_label = $latex_data_label_;
	$this->showcolumns = $showcolumns_;
	$this->latex_data_continued_caption = $latex_data_continued_caption_;
	$this->replace_null = $replace_null_;
	$this->latex_structure_continued_caption = $latex_structure_continued_caption_;
	$this->latex_structure_caption = $latex_structure_caption_;
	$this->latex_structure_label = $latex_structure_label_;
	$this->connection = $connection;
} 	

function exportFooter() { 
    return TRUE; 
}

function exportHeader() { 	
    return TRUE; 
}

function exportDBCreate($db) { 
	return TRUE; 
}

function exportDBHeader($db) { 
    $head = '% ' . $this->crlf
          . '% ' . $this->strDatabase . ': ' . $this->backquote($db) . $this->crlf
          . '% ' . $this->crlf;
    return $this->writer->write($head); 
}

function exportDBFooter($db) { 
	return TRUE;
}

function exportStructure($db, $table, $connection) { 
    $keys_query     = 'SHOW KEYS FROM ' . $this->backquote($table) . ' FROM '. $this->backquote($db);
    $result = $connection->query($keys_query);
	if (DB::isError($result)) {
    	die ("<font size='1'>".date("m.d.Y H:i:s")." :: handler.class.php -> Error in query $keys_query</font><br>");
	}
    $unique_keys    = array();
    while ($row = $result->fetchRow(DB_FETCHMODE_OBJECT)) {
        if ($key['Non_unique'] == 0) 
        	$unique_keys[] = $row->Column_name;
    }
    $connection->freeresult($result);
    
    $local_query = 'SHOW FIELDS FROM ' . $this->backquote($db) . '.' . $this->backquote($table);
    $result = $connection->query($local_query);
    $fields_cnt  = $connection->numrows($result);

    $buffer = $this->crlf . '%' . $this->crlf . '% ' . $this->strStructure . ': ' . $table  . $this->crlf . '%' . $this->crlf
                 . ' \\begin{longtable}{';
    if (!$this->writer->write($buffer)) 
    	return FALSE;

    $columns_cnt = 4;
    $alignment = '|l|c|c|c|';
    $buffer = $alignment . '} ' . $this->crlf ;

    $header = ' \\hline ';
    $header .= '\\multicolumn{1}{|c|}{\\textbf{' . $this->strField . '}} & \\multicolumn{1}{|c|}{\\textbf{' . $this->strType . '}} & \\multicolumn{1}{|c|}{\\textbf{' . $this->strNull . '}} & \\multicolumn{1}{|c|}{\\textbf{' . $this->strDefault . '}}';

    $local_buffer = $this->escapeString($table);

     if (isset($this->latex_caption)) {
        $buffer .= ' \\caption{'. str_replace('__TABLE__', $this->escapeString($table), $this->latex_structure_caption)
                   . '} \\label{' . str_replace('__TABLE__', $table, $this->latex_structure_label)
                   . '} \\\\' . $this->crlf;
    }
    $buffer .= $header . ' \\\\ \\hline \\hline' . $this->crlf . '\\endfirsthead' . $this->crlf;

    if (isset($this->latex_caption)) {
        $buffer .= ' \\caption{'. str_replace('__TABLE__', $this->escapeString($table), $this->latex_structure_continued_caption)
                   . '} \\\\ ' . $this->crlf;
    }
    $buffer .= $header . ' \\\\ \\hline \\hline \\endhead \\endfoot ';

    if (!$this->writer->write($buffer)) 
    	return FALSE;

    while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC)) {

        $type             = $row['Type'];

        if (eregi('^(set|enum)\((.+)\)$', $type, $tmp = array())) {
            $tmp[2]       = substr(ereg_replace('([^,])\'\'', '\\1\\\'', ',' . $tmp[2]), 1);
            $type         = $tmp[1] . '(' . str_replace(',', ', ', $tmp[2]) . ')';
            $type_nowrap  = '';

            $binary       = 0;
            $unsigned     = 0;
            $zerofill     = 0;
        } else {
            $type_nowrap  = ' nowrap="nowrap"';
            $type         = eregi_replace('BINARY', '', $type);
            $type         = eregi_replace('ZEROFILL', '', $type);
            $type         = eregi_replace('UNSIGNED', '', $type);
            if (empty($type)) {
                $type     = '&nbsp;';
            }

            $binary       = eregi('BINARY', $row['Type'], $test = array());
            $unsigned     = eregi('UNSIGNED', $row['Type'], $test = array());
            $zerofill     = eregi('ZEROFILL', $row['Type'], $test = array());
        }
        $strAttribute     = '&nbsp;';
        if ($binary) {
            $strAttribute = 'BINARY';
        }
        if ($unsigned) {
            $strAttribute = 'UNSIGNED';
        }
        if ($zerofill) {
            $strAttribute = 'UNSIGNED ZEROFILL';
        }
        if (!isset($row['Default'])) {
            if ($row['Null'] != '') {
                $row['Default'] = 'NULL';
            }
        } else {
            $row['Default'] = $row['Default'];
        }

        $field_name = $row['Field'];

        $local_buffer = $field_name . "\000" . $type . "\000" . (($row['Null'] == '') ? $this->strNo : $this->strYes)  . "\000" . (isset($row['Default']) ? $row['Default'] : '');

        $local_buffer = $this->escapeString($local_buffer);
        if ($row['Key']=='PRI') {
            $pos=strpos($local_buffer, "\000");
            $local_buffer = '\\textit{' . substr($local_buffer,0,$pos) . '}' . substr($local_buffer,$pos);
        }
        if (in_array($field_name, $unique_keys)) {
            $pos=strpos($local_buffer, "\000");
            $local_buffer = '\\textbf{' . substr($local_buffer,0,$pos) . '}' . substr($local_buffer,$pos);
        }
        $buffer = str_replace("\000", ' & ', $local_buffer);
        $buffer .= ' \\\\ \\hline ' . $this->crlf;

        if (!$this->writer->write($buffer)) 
        	return FALSE;
    } 
    $connection->freeresult($result);

    $buffer = ' \\end{longtable}' . $this->crlf;
    return $this->writer->write($buffer); 
}

function exportData($db, $table, $sql_query, $connection) {

	#$result      = $connection->query($sql_query);
	$result = $connection->query($sql_query);
	$result_fields = $connection->tableInfo($result/*, DB_TABLEINFO_ORDERTABLE*/);
	
    #$columns_cnt = $result->numfields($result);
    $columns_cnt = count($result_fields);
    for ($i = 0; $i < $columns_cnt; $i++) {
        #$columns[$i] = Db::field_name($result, $i);
        $columns[$i] = $result_fields[$i]["name"];
    }
    unset($i);

    $buffer      = $this->crlf . '%' . $this->crlf . '% ' . $this->strData . ': ' . $table . $this->crlf . '%' . $this->crlf
                 . ' \\begin{longtable}{|';

    for ($index=0; $index < $columns_cnt; $index++) {
       $buffer .= 'l|';
    }
    $buffer .= '} ' . $this->crlf ;

    $buffer .= ' \\hline \\endhead \\hline \\endfoot \\hline ' . $this->crlf;
    if (isset($this->latex_caption)) {
        $buffer .= ' \\caption{' . str_replace('__TABLE__', $this->escapeString($table), $this->latex_data_caption)
                   . '} \\label{' . str_replace('__TABLE__', $table, $this->latex_data_label) . '} \\\\';
    }
    if (!$this->writer->write($buffer)) 
    	return FALSE;

    if (isset($this->showcolumns)) {
        $buffer = '\\hline ';
        for ($i = 0; $i < $columns_cnt; $i++) {
            $buffer .= '\\multicolumn{1}{|c|}{\\textbf{' . $this->escapeString(stripslashes($columns[$i])) . '}} & ';
          }

        $buffer = substr($buffer,0,-2) . '\\\\ \\hline \hline ';
        if (!$this->writer->write($buffer . ' \\endfirsthead ' . $this->crlf)) 
        	return FALSE;
        if (isset($this->latex_caption)) {
            if (!$this->writer->write('\\caption{' . str_replace('__TABLE__', $this->escapeString($table), $this->latex_data_continued_caption) . '} \\\\ ')) 
            	return FALSE;
        }
        if (!$this->writer->write($buffer . '\\endhead \\endfoot' . $this->crlf)) 
        	return FALSE;
    } else {
        if (!$this->writer->write('\\\\ \hline')) 
        	return FALSE;
    }

    while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC)) {

        $buffer = '';
        for ($i = 0; $i < $columns_cnt; $i++) {
            if ( isset($record[$columns[$i]]) && (!function_exists('is_null') || !is_null($record[$columns[$i]]))) {
                $column_value = $this->escapeString(stripslashes($record[$columns[$i]]));
            } else {
                $column_value = $this->replace_null;
            }

            if ($i == ($columns_cnt - 1)) {
                $buffer .= $column_value;
            } else {
                $buffer .= $column_value . " & ";
            }
        }
        $buffer .= ' \\\\ \\hline ' . $this->crlf;
        if (!$this->writer->write($buffer)) 
        	return FALSE;
    }

    $buffer = ' \\end{longtable}' . $this->crlf;
    if (!$this->writer->write($buffer)) 
    	return FALSE;

    $connection->freeresult($result);
    return TRUE;
}

}

?>