<?php

require_once('formatter_base.php'); 

class CHtmlWordFormatter extends CFormatterBase { 

var $shownames; 
var $replace_null;
var $connection; 

function CHtmlWordFormatter($shownames_, $replace_null_, $writer_, $connection) {
	$this->CFormatterBase();

	$this->shownames = $shownames_; 
	$this->replace_null = $replace_null_; 
	$this->writer = $writer_;
	$this->connection = $connection;
} 	

function exportFooter() { 
	$footer = '</body></html>';
    return $this->writer->write($footer); 
}

function exportHeader() { 	
	$header = '<html xmlns:o="urn:schemas-microsoft-com:office:office"
	xmlns:x="urn:schemas-microsoft-com:office:word"
	xmlns="http://www.w3.org/TR/REC-html40">

	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html>
	<head>
		<meta http-equiv="Content-type" content="text/html;charset=utf-8" />
	</head>
	<body>'; 	
    return $this->writer->write($header); 
}

function exportDBCreate($db) { 
	return $this->writer->write('<h1>' . $this->strDatabase . ' ' . $db . '</h1>'); 
}

function exportDBHeader($db) { 
	return TRUE;
}

function exportDBFooter($db) { 
	return TRUE;
}

function exportStructure($db, $table, $connection) { 

    if (!$this->writer->write('<h2>' . $this->strTableStructure . ' ' .$table . '</h2>')) 
    	return FALSE;

    $keys_query     = 'SHOW KEYS FROM ' . $this->backquote($table) . ' FROM '. $this->backquote($db);
    $keys_result    = $connection->query($keys_query);
    $unique_keys    = array();
    
    while ($key = $keys_result->fetchRow(DB_FETCHMODE_ASSOC)) {
        if ($key['Non_unique'] == 0) $unique_keys[] = $key['Column_name'];
    }
    $connection->freeresult($keys_result);

    #Db::select_db($db);
    $local_query = 'SHOW FIELDS FROM ' . $this->backquote($db) . '.' . $this->backquote($table);
    $result = $connection->query($local_query);
    #$result      = Db::query($local_query);
    #$fields_cnt  = Db::num_rows($result);
    $fields_cnt  = $connection->numrows($result);

    if (!$this->writer->write('<table class="width100" cellspacing="1">')) 
    	return FALSE;

    $columns_cnt = 4;
 
    $schema_insert = '<tr class="print-category">';
    $schema_insert .= '<th class="print">' . htmlspecialchars($this->strField) . '</th>';
    $schema_insert .= '<td class="print"><b>' . htmlspecialchars($this->strType) . '</b></td>';
    $schema_insert .= '<td class="print"><b>' . htmlspecialchars($this->strNull) . '</b></td>';
    $schema_insert .= '<td class="print"><b>' . htmlspecialchars($this->strDefault) . '</b></td>';
    $schema_insert .= '</tr>';

    if (!$this->writer->write($schema_insert)) return FALSE;

    while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC)) {

        $schema_insert = '<tr class="print-category">';
        $type             = $row['Type'];
        if (eregi('^(set|enum)\((.+)\)$', $type, $tmp = array())) {
            $tmp[2]       = substr(ereg_replace('([^,])\'\'', '\\1\\\'', ',' . $tmp[2]), 1);
            $type         = $tmp[1] . '(' . str_replace(',', ', ', $tmp[2]) . ')';
            $type_nowrap  = '';

            $binary       = 0;
            $unsigned     = 0;
            $zerofill     = 0;
        } else {
            $type_nowrap  = ' nowrap="nowrap"';
            $type         = eregi_replace('BINARY', '', $type);
            $type         = eregi_replace('ZEROFILL', '', $type);
            $type         = eregi_replace('UNSIGNED', '', $type);
            if (empty($type)) {
                $type     = '&nbsp;';
            }

            $binary       = eregi('BINARY', $row['Type'], $test = array());
            $unsigned     = eregi('UNSIGNED', $row['Type'], $test = array());
            $zerofill     = eregi('ZEROFILL', $row['Type'], $test = array());
        }
        $strAttribute     = '&nbsp;';
        if ($binary) {
            $strAttribute = 'BINARY';
        }
        if ($unsigned) {
            $strAttribute = 'UNSIGNED';
        }
        if ($zerofill) {
            $strAttribute = 'UNSIGNED ZEROFILL';
        }
        if (!isset($row['Default'])) {
            if ($row['Null'] != '') {
                $row['Default'] = 'NULL';
            }
        } else {
            $row['Default'] = $row['Default'];
        }

        $fmt_pre = '';
        $fmt_post = '';
        if (in_array($row['Field'], $unique_keys)) {
            $fmt_pre = '<b>' . $fmt_pre;
            $fmt_post = $fmt_post . '</b>';
        }
        if ($row['Key']=='PRI') {
            $fmt_pre = '<i>' . $fmt_pre;
            $fmt_post = $fmt_post . '</i>';
        }
        $schema_insert .= '<td class="print">' . $fmt_pre . htmlspecialchars($row['Field']) . $fmt_post . '</td>';
        $schema_insert .= '<td class="print">' . htmlspecialchars($type) . '</td>';
        $schema_insert .= '<td class="print">' . htmlspecialchars($row['Null'] == '' ? $this->strNo : $this->strYes) . '</td>';
        $schema_insert .= '<td class="print">' . htmlspecialchars(isset($row['Default']) ? $row['Default'] : '') . '</td>';

        $field_name = $row['Field'];

        $schema_insert .= '</tr>';

        if (!$this->writer->write($schema_insert)) return FALSE;
    } 
    $connection->freeresult($result);

    return $this->writer->write('</table>'); 
}

function exportData($db, $table, $sql_query, $connection) {

    if (!$this->writer->write('<h2>' . $this->strDumpingData . ' ' .$table . '</h2>')) 
    	return FALSE;
    
    if (!$this->writer->write('<table class="width100" cellspacing="1">')) 
    	return FALSE;

    $result      = $connection->query($sql_query);
    $result_fields = $connection->tableInfo($result/*, DB_TABLEINFO_ORDERTABLE*/);
    $fields_cnt = count($result_fields);
    #$fields_cnt  = Db::num_fields($result);

    if (isset($this->shownames) && $this->shownames == 'yes') {
        $fields_meta   = array();
    	$num_fields   = count($result_fields);
    	for ($i = 0; $i < $num_fields; $i++) {
        	$fields_meta[] = $result_fields[$i];
    	}
        $schema_insert = '<tr class="print-category">';
        for ($i = 0; $i < $fields_cnt; $i++) {
            $schema_insert .= '<td class="print"><b>' . htmlspecialchars(stripslashes($fields_meta[$i]["name"])) . '</b></td>';
        }
        $schema_insert .= '</tr>';
        if (!$this->writer->write($schema_insert)) 
        	return FALSE;
    }

    while ($row = $result->fetchRow(DB_FETCHMODE_ORDERED)) {
        $schema_insert = '<tr class="print-category">';
        for ($j = 0; $j < $fields_cnt; $j++) {
            if (!isset($row[$j]) || is_null($row[$j])) {
                $value = $this->replace_null;
            } else if ($row[$j] == '0' || $row[$j] != '') {
                $value = $row[$j];
            } else {
                $value = '';
            }
            $schema_insert .= '<td class="print">' . htmlspecialchars($value) . '</td>';
        } 
        $schema_insert .= '</tr>';
        if (!$this->writer->write($schema_insert)) 
        	return FALSE;
    } 
    $connection->freeresult($result);
    if (!$this->writer->write('</table>')) 
    	return FALSE;

    return TRUE; 
}

}

?>