<?php

require_once('formatter_base.php'); 

class CHtmlExcelFormatter extends CFormatterBase { 

var $shownames;
var $replace_null;
var $connection;

function CHtmlExcelFormatter($shownames_, $replace_null_, $writer_, $connection) {
	$this->CFormatterBase();
	
	$this->shownames = $shownames_;
	$this->replace_null = $replace_null_;
	$this->writer = $writer_;
	$this->connection = $connection;
} 	

function exportFooter() { 
	$footer = '</table></div></body></html>';
    return $this->writer->write($footer); 
}

function exportHeader() { 
	$header = '<html xmlns:o="urn:schemas-microsoft-com:office:office"
	xmlns:x="urn:schemas-microsoft-com:office:excel"
	xmlns="http://www.w3.org/TR/REC-html40">
	
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html>
	<head>
		<meta http-equiv="Content-type" content="text/html;charset=utf-8" />
	<style id="Classeur1_16681_Styles">
	</style>
	
	</head>
	<body>
	
	<div id="Classeur1_16681" align=center x:publishsource="Excel">
	
	<table x:str border=0 cellpadding=0 cellspacing=0 width=100% style='. $this->backquote('border-collapse: collapse') . '>';
	
    return $this->writer->write($header); 
}

function exportDBCreate($db) { 
	return TRUE;
}

function exportDBHeader($db) { 
	return TRUE;
}

function exportDBFooter($db) { 
	return TRUE;
}

function exportStructure($db, $table) { 
	return TRUE;
}

function exportData($db, $table, $sql_query, $connection) {
    $result      = $connection->query($sql_query);
    #$fields_cnt  = Db::num_fields($result);
    $result_fields = $connection->tableInfo($result/*, DB_TABLEINFO_ORDERTABLE*/);
    $fields_cnt = count($result_fields);
    if (isset($this->shownames) && $this->shownames == 'yes') {
        $schema_insert = '<tr>';
        for ($i = 0; $i < $fields_cnt; $i++) {
            $schema_insert .= '<td class=xl2216681 nowrap><b>' . htmlspecialchars(stripslashes($result_fields[$i]["name"])) . '</b></td>';
        }
        $schema_insert .= '</tr>';
        if (!$this->writer->write($schema_insert)) return FALSE;
    }
    
    while ($row = $result->fetchrow(DB_FETCHMODE_ORDERED)) {
        $schema_insert = '<tr>';
        for ($j = 0; $j < $fields_cnt; $j++) {
            if (!isset($row[$j]) || is_null($row[$j])) {
                $value = $this->replace_null;
            } else if ($row[$j] == '0' || $row[$j] != ''){
                $value = $row[$j];
            } else {
                $value = '';
            }
            $schema_insert .= '<td class=xl2216681 nowrap>' . htmlspecialchars($value) . '</td>';
        }
        $schema_insert .= '</tr>';
        if (!$this->writer->write($schema_insert)) return FALSE;
    }
    
    $connection->freeresult($result);

    return TRUE; 
}

}

?>