<?php
require_once('./config.php');

class CFormatterBase extends Db{

var $HTTP_USER_AGENT;
var $BROWSER_VER;
var $BROWSER_AGENT;
var $writer;

function CFormatterBase(){
    if (!empty($_SERVER['HTTP_USER_AGENT'])) {
        $this->HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
    } else if (!isset($this->HTTP_USER_AGENT)) {
        $this->HTTP_USER_AGENT = '';
    }

    if (preg_match('@Opera(/| )([0-9].[0-9]{1,2})@', $this->HTTP_USER_AGENT, $log_version)) {
        $this->BROWSER_VER = $log_version[2];
        $this->BROWSER_AGENT = 'OPERA';
    } else if (preg_match('@MSIE ([0-9].[0-9]{1,2})@', $this->HTTP_USER_AGENT, $log_version)) {
        $this->BROWSER_VER = $log_version[1];
        $this->BROWSER_AGENT = 'IE';
    } else if (preg_match('@OmniWeb/([0-9].[0-9]{1,2})@', $this->HTTP_USER_AGENT, $log_version)) {
        $this->BROWSER_VER = $log_version[1];
        $this->BROWSER_AGENT = 'OMNIWEB';
    } else if (preg_match('@(Konqueror/)(.*)(;)@', $this->HTTP_USER_AGENT, $log_version)) {
        $this->BROWSER_VER = $log_version[2];
        $this->BROWSER_AGENT = 'KONQUEROR';
    } else if (preg_match('@Mozilla/([0-9].[0-9]{1,2})@', $this->HTTP_USER_AGENT, $log_version)
               && preg_match('@Safari/([0-9]*)@', $this->HTTP_USER_AGENT, $log_version2)) {
        $this->BROWSER_VER = $log_version[1] . '.' . $log_version2[1];
        $this->BROWSER_AGENT = 'SAFARI';
    } else if (preg_match('@Mozilla/([0-9].[0-9]{1,2})@', $this->HTTP_USER_AGENT, $log_version)) {
        $this->BROWSER_VER = $log_version[1];
        $this->BROWSER_AGENT = 'MOZILLA';
    } else {
        $this->BROWSER_VER = 0;
        $this->BROWSER_AGENT = 'OTHER';
    }

    $this->SetLanguage(DEFAULT_LANGUAGE);
}

function SetLanguage($lang_type, $lang_path = "language/") {
    if(file_exists($lang_path.$lang_type.'/smarty.lang.lng'))
        $lng_file = $lang_path.$lang_type.'/smarty.lang.lng';
    else if(file_exists($lang_path.'en/smarty.lang.lng'))
        $lng_file = $lang_path.'en/smarty.lang.lng';
    else {
        exit("Could not load language file");
    }

	if(file_exists($lng_file)) {
		/*$handle = fopen($lng_file, "r");
		while (!feof($handle)) {
			$line[] = fgets($handle, filesize($lng_file));
		}
		fclose($handle);*/
		$line = file($lng_file);
		foreach ($line as $value) {
			$var_array = explode("=", $value);
			if (isset($var_array[1])) {
				$lng[$var_array[0]] = $var_array[1];
			}
		}
	}

	$this->crlf =  "\r\n";
	$this->comment_marker = chop($lng["formatter_comment_marker"]);
	$this->strTableStructure = chop($lng["formatter_strTableStructure"]);
	$this->strConstraintsForDumped = chop($lng["formatter_strConstraintsForDumped"]);
	$this->strConstraintsForTable = chop($lng["formatter_strConstraintsForTable"]);
	$this->strDumpingData = chop($lng["formatter_strDumpingData"]);
	$this->strDatabase = chop($lng["formatter_strDatabase"]);
	$this->strStructure = chop($lng["formatter_strStructure"]);
	$this->strData = chop($lng["formatter_strData"]);
	$this->strField = chop($lng["formatter_strField"]);
	$this->strType = chop($lng["formatter_strType"]);
	$this->strNull = chop($lng["formatter_strNull"]);
	$this->strDefault = chop($lng["formatter_strDefault"]);
	$this->strNo = chop($lng["formatter_strNo"]);
	$this->strYes = chop($lng["formatter_strYes"]);
	$this->strCreation = chop($lng["formatter_strCreation"]);
	$this->strLastUpdate = chop($lng["formatter_strLastUpdate"]);

    return true;
}

function escapeString($string) {
   $escape = array('$', '%', '{', '}',  '&',  '#', '_', '^');
   $cnt_escape = count($escape);
   for ($k=0; $k < $cnt_escape; $k++) {
      $string = str_replace($escape[$k], '\\' . $escape[$k], $string);
   }
   return $string;
}

function backquote($a_name){
	return '`' . $a_name . '`';
}

function getUvaCondition($handle, $fields_cnt, $fields_meta, $row) {

	$primary_key              = '';
	$unique_key               = '';
	$uva_nonprimary_condition = '';

	for ($i = 0; $i < $fields_cnt; ++$i) {
		#$result_fields = $this->connection->tableInfo($result/*, DB_TABLEINFO_ORDERTABLE*/);
		#echo "<pre>";
		#var_dump($result_fields);
		#exit;
		#echo "<pre>";
		#var_dump($fields_meta);
		#exit;
	    $field_flags = $fields_meta[$i]["flags"];
	    $meta      = $fields_meta[$i];
	    $column_for_condition = $meta->name;

	    if ($meta->type == 'real') {
	        $condition = ' CONCAT(' . $this->backquote($column_for_condition) . ') ';
	    } else {
	        if ($meta->type == 'string' || $meta->type == 'blob') {
	            $condition = ' CONVERT(' . $this->backquote($column_for_condition) . ' USING utf8) ';
	        } else {
	            $condition = ' ' . $this->backquote($column_for_condition) . ' ';
	        }
	    }

	    if (!isset($row[$i]) || is_null($row[$i])) {
	        $condition .= 'IS NULL AND';
	    } else {
	        if ($meta->numeric && $meta->type != 'timestamp') {
	            $condition .= '= ' . $row[$i] . ' AND';
	        } elseif ($meta->type == 'blob'
	                && stristr($field_flags, 'BINARY')
	                && !empty($row[$i])) {
	                $condition .= '= CAST(0x' . bin2hex($row[$i]). ' AS BINARY) AND';
	        } else {
	            $a_string = str_replace('\\', '\\\\', $row[$i]);
	            $a_string = str_replace("\n", '\n', $a_string);
	            $a_string = str_replace("\r", '\r', $a_string);
	            $a_string = str_replace("\t", '\t', $a_string);
	            $condition .= '= \'' . $a_string . '\' AND';
	        }
	    }
	    if ($meta->primary_key > 0) {
	        $primary_key .= $condition;
	    } else if ($meta->unique_key > 0) {
	        $unique_key  .= $condition;
	    }
	    $uva_nonprimary_condition .= $condition;
	}

	if ($primary_key) {
	    $uva_condition = $primary_key;
	} else if ($unique_key) {
	    $uva_condition = $unique_key;
	} else {
	    $uva_condition = $uva_nonprimary_condition;
	}

	return preg_replace('|\s?AND$|', '', $uva_condition);
}

function finalize(){
	$this->writer->close();
}

}

?>