<?php

require_once('formatter_base.php'); 

class CExcelFormatter extends CFormatterBase { 

var $shownames;
var $replace_null;
var $connection;

	
function CExcelFormatter($shownames_, $replace_null_, $writer_, $connection) {

	$this->CFormatterBase();

	$this->writer = $writer_;
	$this->shownames = $shownames_;
	$this->replace_null = $replace_null_;
	$this->connection = $connection;
} 	

function exportFooter() { 
    return TRUE; 
}

function exportHeader() { 	
    return TRUE; 
}

function exportDBCreate($db) { 
	return TRUE; 
}

function exportDBHeader($db) { 
	return TRUE;
}

function exportDBFooter($db) { 
	return TRUE;
}

function exportStructure($db, $table) { 
    return TRUE; 
}

function exportData($db, $table, $sql_query, $connection) {

    $result      = $connection->query($sql_query);
    $result_fields = $connection->tableInfo($result/*, DB_TABLEINFO_ORDERTABLE*/);
    $fields_cnt = count($result_fields);
    #$fields_cnt  = Db::num_fields($result);

    if (isset($this->shownames) && $this->shownames == 'yes') {
        $schema_insert = '';
        for ($i = 0; $i < $fields_cnt; $i++) {
                $schema_insert .= '"' . str_replace('"', '"' . '"', stripslashes($result_fields[$i]["name"]))
                               . '",';
        }
        $schema_insert  = trim(substr($schema_insert, 0, -1));
        if (!$this->writer->write($schema_insert . "\015\012")) 
        	return FALSE;
    }

    while ($row = $result->fetchRow(DB_FETCHMODE_ORDERED)) {
        $schema_insert = '';
        for ($j = 0; $j < $fields_cnt; $j++) {
            if (!isset($row[$j]) || is_null($row[$j])) {
                $schema_insert .= $this->replace_null;
            }
            else if ($row[$j] == '0' || $row[$j] != '') {
                $row[$j]       = ereg_replace("\015(\012)?", "\012", $row[$j]);
                $schema_insert .= '"' . str_replace('"', '"' . '"', $row[$j])
                               . '"';
            }
            if ($j < $fields_cnt-1) {
                $schema_insert .= ',';
            }
        }

        if (!$this->writer->write($schema_insert . "\015\012")) 
        	return FALSE;
    }
    $connection->freeresult($result);

    return TRUE; 
}

}

?>