<?php

require_once('formatter_base.php'); 

class CSVFormatter extends CFormatterBase { 

var $shownames;
var $replace_null;
var $add_character;
var $export_separator;
var $enclosed;
var $escaped;
var $connection;
	
function CSVFormatter($shownames_, $replace_null_, $add_character_, $export_separator_, $enclosed_, $escaped_, $writer_, $connection) {
	$this->CFormatterBase();

	$this->writer = $writer_;
	$this->shownames = $shownames_;
	$this->replace_null = $replace_null_;
	$this->add_character = stripslashes($add_character_);
	$this->export_separator = $export_separator_;
	$this->enclosed = stripslashes($enclosed_);
	$this->escaped = stripslashes($escaped_);
	$this->connection = $connection;
		
    if (empty($this->add_character)) {
            $this->add_character  = $this->crlf;
    } else {
            $this->add_character  = str_replace('\\r', "\015", $this->add_character);
            $this->add_character  = str_replace('\\n', "\012", $this->add_character);
            $this->add_character  = str_replace('\\t', "\011", $this->add_character);
    }
    $this->export_separator = str_replace('\\t', "\011", $this->export_separator); 	
} 	

function exportFooter() { 
    return TRUE; 
}

function exportHeader() { 	
    return TRUE; 
}

function exportDBCreate($db) { 
	return TRUE; 
}

function exportDBHeader($db) { 
	return TRUE;
}

function exportDBFooter($db) { 
	return TRUE;
}

function exportStructure($db, $table) { 
    return TRUE; 
}

function exportData($db, $table, $sql_query, $connection) {

    $result      = $connection->query($sql_query);
    $result_fields = $connection->tableInfo($result/*, DB_TABLEINFO_ORDERTABLE*/);
    #$fields_cnt  = Db::num_fields($result);
    $fields_cnt = count($result_fields);

    if (isset($this->shownames) && $this->shownames == 'yes') {
        $schema_insert = '';
        $fields_meta   = array();
    	$num_fields   = count($result_fields);
    	for ($i = 0; $i < $num_fields; $i++) {
        	$fields_meta[] = $result_fields[$i];
    	}
        for ($i = 0; $i < $fields_cnt; $i++) {
            if ($this->enclosed == '') {
                $schema_insert .= stripslashes($fields_meta[$i]["name"]);
            } else {
                $schema_insert .= $this->enclosed
                               . str_replace($this->enclosed, $this->escaped . $this->enclosed, stripslashes(Db::field_name($result, $i)))
                               . $this->enclosed;
            }
            $schema_insert     .= $this->export_separator;
        }
        $schema_insert  =trim(substr($schema_insert, 0, -1));
        if (!$this->writer->write($schema_insert . $this->add_character)) 
        	return FALSE;
    }

    while ($row = $result->fetchRow(DB_FETCHMODE_ORDERED)) {
        $schema_insert = '';
        for ($j = 0; $j < $fields_cnt; $j++) {
            if (!isset($row[$j]) || is_null($row[$j])) {
                $schema_insert .= $this->replace_null;
            }
            else if ($row[$j] == '0' || $row[$j] != '') {
                if ($this->enclosed == '') {
                    $schema_insert .= $row[$j];
                } else {
                    $schema_insert .= $this->enclosed
                                   . str_replace($this->enclosed, $this->escaped . $this->enclosed, $row[$j])
                                   . $this->enclosed;
                }
            }
            else {
                $schema_insert .= '';
            }
            if ($j < $fields_cnt-1) {
                $schema_insert .= $this->export_separator;
            }
        }

        if (!$this->writer->write($schema_insert . $this->add_character)) 
        	return FALSE;
    } 
    $connection->freeresult($result);

    return TRUE; 
}

}

?>