<?php
ob_start();

require_once('./config.php');
require_once('utilities/utils.php');
require_once('smarty/Smarty_ml.class.php');
SetLanguage(DEFAULT_LANGUAGE);

$save_dir = $_REQUEST["save_dir"];
$file_names = $_REQUEST['serverfile'];
$backup_method = $_REQUEST["backup_method"];
$smartbackup = $_REQUEST["smartbackup"];
$smartbackup_type = $_REQUEST["smartbackup_type"];
$compression = $_REQUEST["compression"];

$mail_subject = $_REQUEST["mail_subject"];
$mail_to = $_REQUEST["mail_to"];
$mail_cc = $_REQUEST["mail_cc"];
$ftp_file_name = $_REQUEST["txt_edit_filename_template"];



if ($backup_method == 'local_backup'){
	require_once('writers/local_backup_writer.php');

	$writer = & new CLocalBackupWriter($smartbackup, $smartbackup_type, $compression, $save_dir);

}

if ($backup_method == 'email_backup'){
	require_once('writers/email_backup_writer.php');
	$i=$_REQUEST['emaili'];
	$writer = & new CEmailBackupWriter($compression, $send_type[$i], $mail_to, $mail_cc, $mail_subject, $mail_format[$i], $smtp_host[$i], $smtp_port[$i], $smtp_auth[$i], $smtp_user[$i], $smtp_passw[$i], $sendmail_path[$i],$file_names, ADMIN);
}


if ($backup_method == 'ftp_backup'){
	require_once('writers/ftp_backup_writer.php');
	$i=$_REQUEST['i'];
	$errorOccurs = false;
	if (!checkFTP($ftp_host[$i], $ftp_login[$i], $ftp_password[$i], $ftp_save_dir[$i]))
	{
			$errorOccurs = true;
			//$GLOBALS['ftpSettingsInCorrect'];
	}
	$writer = & new CFTPBackupWriter($smartbackup, $smartbackup_type, $compression, $ftp_save_dir[$i], $ftp_host[$i], $ftp_login[$i], $ftp_password[$i],$ftp_file_name);
}

if (isset($_REQUEST["extensions"])) {
	if ($_REQUEST['extensions'] == 'skip'){
		$skip_extensions = trim($_REQUEST['skip_extensions']);
		if ($skip_extensions != ''){
			//validate extensions list
			$ext_list = explode(" ", $skip_extensions);
			$writer->excludeExtensions($ext_list);
		}
	}

	if ($_REQUEST['extensions'] == 'include'){
		$include_extensions = trim($_REQUEST['include_extensions']);
		if ($include_extensions != ''){
			//validate extensions list
			$ext_list = explode(" ", $include_extensions);
			$writer->includeOnlyExtensions($ext_list);
		}
	}
}

if (isset($_REQUEST["large_size"])) {
	if ($_REQUEST['large_size'] == 'skip'){
		$skip_large_size = trim($_REQUEST['skip_large_size']);
		if ($skip_large_size != ''){
			//validate size
			$writer->excludeLarger($skip_large_size);
		}
	}

	if ($_REQUEST['large_size'] == 'include'){
		$include_large_size = trim($_REQUEST['include_large_size']);
		if ($include_large_size != ''){
			//validate size
			$writer->includeLarger($include_large_size);
		}
	}
}


foreach ($file_names as $file_name){
	if (is_dir($file_name)){
		$writer->addDir($file_name);
	} else {
		$writer->addFile($file_name);
	}
}

$writer->close();
$backupfilename = $_REQUEST['save_dir'].'/'.$writer->backupname;
//echo $backupfilename;

if ($backup_method == 'local_backup' && !isset($smartbackup))
{
	$download_link_web = "down.php?filename=".$backupfilename;
}
ob_end_clean();


if (isset($_SESSION["smarty"])){
		$smarty = $_SESSION["smarty"];
	} else {
		$smarty = new smartyML(DEFAULT_LANGUAGE);
		$smarty->template_dir = TEMPLATES_PATH;
		$smarty->compile_dir = TEMPLATES_C_PATH;
}

$smarty->assign("TabHref", array("index.php?main_tabid=0&amp;main_content=index_export.php",
								 "index.php?main_tabid=1&amp;main_content=index_files_backup.php",
								 "index.php?main_tabid=2&amp;main_content=index_settings.php",
								 "index.php?main_tabid=3&amp;main_content=index_test_backup.php",
								 "index.php?Logout=yes"));

$smarty->assign("TabCaption", array($GLOBALS['databaseBackup'], $GLOBALS['webFilesBackup'], $GLOBALS['systemSettings'], $GLOBALS['testBackup'],$GLOBALS['logOut']));

#if (isset($main_tabid)) {
	$smarty->assign("TabId", "1");
#}

if (isset($file_names)) {
	if (is_array($file_names)) {
		foreach ($file_names as $file_name) {

			if (is_dir($file_name)){
				$writer->addDir($file_name);
				$Success = 'true';
				$backup_files[] = $file_name;
				$smarty->assign("file_name", $file_name);
			} else {
				$writer->addFile($file_name);
				$Success = 'true';
				$backup_files[] = $file_name;
			}
		}
	}
}
if(isset($Success)) {
	$smarty->assign("done", "1");
	if($compression == 'none')
	{
		$str = $writer->backupname.$extension;
	 }
	 else
		 $str = $writer->backupname;

	$str = str_replace("..",".",$str);

	if ($backup_method == 'ftp_backup' && $errorOccurs == false) {
		$smarty->assign("str", $str);
		$smarty->assign("ftp_host", $ftp_host[$i]);
	}
	if($backup_method == 'email_backup') {
		$smarty->assign("str", $str);
		$sent_mail = $mail_to;
		if ($mail_cc != "") {
			$sent_mail .= ", ".$mail_cc;
		}
		$smarty->assign("mail_to", $sent_mail);
	}
	$smarty->assign("backup_method", $backup_method);
	$smarty->assign("smartbackup", $smartbackup);
	if (isset($errorOccurs)) {
		$smarty->assign("errorOccurs", $errorOccurs);
	}
	if (isset($download_link_web)) {
		$smarty->assign("download_link_web", $download_link_web);
	}
}
if (isset($backup_files)) {
	$smarty->assign("backup_files",$backup_files);
}
$smarty->display('db_sucess.tpl');
?>