function replaceAll( s1, s2 ) { return this.split( s1 ).join( s2 ) ; }
function html_entity_decode()
{ 
    str = this.replaceAll( "&lsquo;", "" );
    str = this.replaceAll( "&ldquo;", "" );
    str = this.replaceAll( "&quot;", "\"" );
    str = this.replaceAll( "&amp;", "&" );
    return str.replaceAll( "&#39;", "'" );
}

function html_entity_encode()
{ 
    str = this.replaceAll( "", "&lsquo;" );
    str = this.replaceAll( "", "&ldquo;" );
    str = this.replaceAll( "\"", "&quot;" );
    str = this.replaceAll( "&", "&amp;" );
    return str.replaceAll( "'", "&#39;" );
}

function isNumber()
{
    var regularEXPR = new RegExp( "^[0-9.,]{1,}$" ) ;
    
    return regularEXPR.test( this );
}

function onlyDigits()
{
    var regularEXPR = new RegExp( "^[0-9]{1,}$" ) ;
    
    return regularEXPR.test( this );
}

function utf8_encode()
{
        string = this.replace(/\r\n/g,"\n");

        var utftext = "";

        for (var n = 0; n < string.length; n++)
        {
            var c = string.charCodeAt(n);

            if (c < 128) { utftext += String.fromCharCode(c); }
            else if ( ( c > 127 ) && ( c < 2048 ) )
            {
                utftext += String.fromCharCode((c>>6)|192);
                utftext += String.fromCharCode((c&63)|128);
            }
            else
            {
                utftext += String.fromCharCode((c>>12)|224);
                utftext += String.fromCharCode(((c>>6)&63)|128);
                utftext += String.fromCharCode((c&63)|128);
            }
        }

        return utftext ;
}

function utf8_decode()
{
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;

        var utftext = this ;

        while ( i < utftext.length )
        {
            c = utftext.charCodeAt(i);

            if (c < 128)
            {
                string += String.fromCharCode(c);
                i++;
            }
            else if((c > 191) && (c < 224))
            {
                c2 = utftext.charCodeAt(i+1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else
            {
                c2 = utftext.charCodeAt(i+1);
                c3 = utftext.charCodeAt(i+2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }

        }

        return string;
}


String.prototype.replaceAll = replaceAll ;
String.prototype.html_entity_decode = html_entity_decode ;
String.prototype.html_entity_encode = html_entity_encode ;
String.prototype.isNumber = isNumber ;
String.prototype.onlyDigits = onlyDigits ;
String.prototype.utf8_encode = utf8_encode ;
String.prototype.utf8_decode = utf8_decode ;
