<?php

 /*

 Code written by Adam Crownoble adam@obleDesign.com

 You may take this code this code and change it
 however you like. My only request is that keep
 this comment in place and comment your own
 changes. Happy coding.

 This code dynamically renders a thermostat as an
 image. It is meant to be used to gauge donations to
 a project.

 */

 // Get variables 
 $goal = $_GET['goal'];
 $progress = $_GET['progress'];
 if($progress && $goal) { $temp = $progress / $goal; }

 // Image dimensions
 if(!$w = $_GET['w']) { $w = 45; }
 if(!$h = $_GET['h']) { $h = 150; }

 // Border
 $border_w = 1;

 // Tube Dimensions
 $tube_w_ratio = .6;
 $tube_w = $w * $tube_w_ratio;
 $tube_h = $h - ($w);
 $tube_l = ($w - $tube_w) / 2;
 $tube_r = $w - $tube_l;
 
 // Ball Dimensions
 $ball_w = $w;
 $ball_cnt_x = $ball_w / 2;
 $ball_cnt_y = $h - ($ball_cnt_x);
 
 // Marks
 $mark_num = 10;
 $mark_w_min_ratio = .15;
 $mark_w_max_ratio = .3;
 $mark_w_min = $tube_w * $mark_w_min_ratio;
 $mark_w_max = $tube_w * $mark_w_max_ratio;
 $mark_spacing = $tube_h / $mark_num;

 // Image
 $img = imagecreatetruecolor($w,$h);
 
 // Settings
 imageantialias($img,true);
 imagesetthickness($img,$border_w);
 
 // Colors
 $black = imagecolorallocate($img,100,100,100);
 $white = imagecolorallocate($img,255,255,255);
 $gray = imagecolorallocate($img,225,225,225);
 $red = imagecolorallocate($img,190,0,0);
 
 // Background
 imagefilledrectangle($img,0,0,$w,$h,$white);
 
 // Draw Tube
 imagefilledrectangle($img,
                      $tube_l,
                      0,
                      $tube_r,
                      $tube_h,
                      $gray);
 // Top
 imageline($img,
           $tube_l,
           0,
           $tube_r,
           0,
           $black);
 // Left
 imageline($img,
           $tube_l,
           0,
           $tube_l,
           $tube_h + ($ball_w / 2),
           $black);
 // Right
 imageline($img,
           $tube_r,
           0,
           $tube_r,
           $tube_h + ($ball_w / 2),
           $black);

 // Draw Ball
 imagefilledellipse($img,
                    $ball_cnt_x,
                    $ball_cnt_y,
                    $ball_w,
                    $ball_w,
                    $red);
 imageellipse($img,
              $ball_cnt_x,
              $ball_cnt_y,
              $ball_w,
              $ball_w,
              $black);
 
 // Draw Mercury
 imagefilledrectangle($img,
                      $tube_l + $border_w,
                      $tube_h - ($tube_h * $temp),
                      $tube_r - $border_w,
                      $tube_h + ($ball_w / 2)
                              + $border_w,
                      $red);

 // Draw Marks
 for($i = 1; $i <= $mark_num; $i++) {

  if(1&$i) {
   $mark_w = $mark_w_min;
  } else {
   $mark_w = $mark_w_max;
  }

  imageline($img,
            $tube_l,
            $mark_spacing * $i,$tube_l + $mark_w,
            $mark_spacing * $i,
            $black);
 }

 // Set the content type to PNG
 header("Content-type: image/png");

 // Output the image
 imagepng($img);

 // Clear up the resources
 imagedestroy($img);
 
?>