<?php
include ('../includes/class_seo_url.php');
$seo = new seo_url_tools(true);
$seo->set_sections ('public,admin', 'public');
$seo->set_path_names ('opt,item,subitem');
$seo->set_option ('page', 'numeric');
$seo->set_option ('lang', 'char', 'en', 'en,it,de,sr');
$seo->set_default_path_value ('news');

$m_url = $seo->get_current_url();
$m_url_array = $seo->get_current_url('array');

$m_host = $seo->get_url_param ($m_url_array, 'host');
$m_url_root = $seo->get_url_param ($m_url_array, 'root');
$m_section = $seo->get_url_param ($m_url_array, 'section');
$m_opt = $seo->get_url_param ($m_url_array, 'path', 'opt');
$m_item = $seo->get_url_param ($m_url_array, 'path', 'item');
$m_subitem = $seo->get_url_param ($m_url_array, 'path', 'subitem');
$m_page = $seo->get_url_param ($m_url_array, 'options', 'page');
$m_lang = $seo->get_url_param ($m_url_array, 'options', 'lang');
$m_disp = $seo->get_url_param ($m_url_array, 'query', 'disp');

$m_root = $seo->get_root_url();

$m_abs_root = $seo->url_root();

$seo->force_correct_current_url();

?>
<html>
<head>
<title>SEO URL TOOLS ONLINE TEST</title>
<style type="text/css">
<!--
body, td {
	font-size: 0.9em;
}
-->
</style>
</head>
<body>
<p>SEO URL TOOLS TEST (<a href="/" target="_blank">more info</a>)<br />
Freely enter url in your browser but keep it under <a href="<?php echo $m_root ?>"><?php echo $m_root ?></a> and see how url items are parsed. </p>
<table cellpadding="5" cellspacing="5" >
  <tr valign="top"><td width="262">

    <p><b>Try these test links:</b></p>
    <p>Option index
      <a href="<?php echo $m_abs_root ?>index"><?php echo $m_abs_root ?>index</a>      </p>
    <p>Option index, language sr
      <a href="<?php echo $m_abs_root ?>index.sr"><?php echo $m_abs_root ?>index.sr</a>      </p>
    <p>Option news, item 12, page 3, language de, disp 2<br>
      <a href="<?php echo $m_abs_root ?>news/12.3.de?disp=2"><?php echo $m_abs_root ?>news/12.3.de?disp=2</a>      </p>
    <p>Option news, item 12, disp 4, page 3, language it
      <br>
      <a href="<?php echo $m_abs_root ?>news/12/disp=4.3.it"><?php echo $m_abs_root ?>news/12/disp=4.3.it</a>      </p>
    <p>Option book, item chap4, subitem letter, page 4, 
      font arial, language fr (fr does not exist so 
      default (en) is used). Pay attention, script forces
      proper url in browser. It does not allow the one you 
      click ed as it is incorrect
      <a href="<?php echo $m_abs_root ?>book/letter/page=4/font=arial.fr"><br>
      <?php echo $m_abs_root ?>book/letter/page=4/font=arial.fr</a>      </p>
    <p>The same as above but with incorrect order of parameters.
      Script forces correct order. Click and then look at browser URL field.<br>
      <a href="<?php echo $m_abs_root ?>page=4/book/font=arial/letter.fr"><?php echo $m_abs_root ?>page=4/book/font=arial/letter.fr</a>      </p>
    <p>Section admin, option users, item list
      <br>
      <a href="<?php echo $m_abs_root ?>admin/users/list"><?php echo $m_abs_root ?>admin/users/list</a>      </p>
    <p>If there is number of path parameters it will handle them properly. Ones custom defined will be taken first, and rest will get autogenerated names prefixed with 'p'.<br>
      <a href="<?php echo $m_abs_root ?>admin/path1/path2/path3/path4/path5/path6"><?php echo $m_abs_root ?>admin/path1/path2/path3/path4/path5/path6</a></p></td>
<td width="656">
<pre>

Current url as string:
<?php echo "$m_url"; ?>


Current url as array:
<?php print_r ($m_url_array); ?>


Host: <?php echo $m_host ?>

Root: <?php echo $m_url_root ?>

Section: <?php echo $m_section ?>

Option: <?php echo $m_opt ?>

Item: <?php echo $m_item ?>

SubItem: <?php echo $m_subitem ?>

Page: <?php echo (int)$m_page ?>

Lang: <?php echo $m_lang ?>

Disp: <?php echo $m_disp ?>

</pre>
</td></tr></table>

<pre>
Contents of an object:
==========================================================
<?php
print_r ($seo);
?>
</pre>


</body>
</html>