
<?php
// load library 
include ('../includes/class_seo_url.php');

// initialize 
$seo = new seo_url_tools();

// set seo mode to query mode 
$seo->set_pretty_url_mode (true);

// define sections public and admin with bublic as default 
$seo->set_sections ('public,admin', 'public');

// define path names opt and item 
$seo->set_path_names ('opt,item');

// define option page, which is numeric as first option 
$seo->set_option ('page', 'numeric');

// define optin lang, which is char, with default value 'en' and possible values 'en', 'it' and 'de' 
$seo->set_option ('lang', 'char', 'en', 'en,it,de');

// set default option
$seo->set_default_path_value ('news');

?>
<pre>
<?php

// we will use url example
//$m_url = "http://mysite.com/?opt=news&item=12&page=3&lang=en&disp=full";
$m_url = "http://mysite.com/news/12/disp=full.3.en";

// but you may als use current url by uncommenting following line
//$m_url = $seo->get_current_url ('string');

//lets parse string url into array structure
$m_parsed_url = $seo->url2array ($m_url);

// and display what we got
print_r ($m_parsed_url);

?>

</pre>

<pre>
<?php

// read host
$m_host = $seo->get_url_param ($m_parsed_url, 'host');
echo "m_host = $m_host\n";

// read section
$m_section = $seo->get_url_param ($m_parsed_url, 'section');
echo "m_section = $m_section\n";

// read opt
$m_opt = $seo->get_url_param ($m_parsed_url, 'path', 'opt');
echo "m_opt = $m_opt\n";

// read item
$m_item = $seo->get_url_param ($m_parsed_url, 'path', 'item');
echo "m_item = $m_item\n";

// read page
$m_page = $seo->get_url_param ($m_parsed_url, 'options', 'page');
echo "m_page = " . (int)$m_page . "\n";

// read lang
$m_lang = $seo->get_url_param ($m_parsed_url, 'options', 'lang');
echo "m_lang = $m_lang\n";

// read disp
$m_disp = $seo->get_url_param ($m_parsed_url, 'query', 'disp');
echo "m_disp = $m_disp\n";


?>
</pre>

<pre>
<?php

// change lang option to de
$m_change['options']['lang'] = 'de';

// replace lang parameter in url
$m_new_url = $seo->url_add_param ($m_parsed_url, $m_change);

// we have value as array so we have to convert to string to display
$m_new_url_string = $seo->array2url ($m_new_url);

echo "m_new_url_string = $m_new_url_string\n";

?>
</pre>

<pre>
<?php

// change opt item value to products (we want to show products)
unset ($m_change);
$m_change['path']['opt'] = 'products';
$m_change['path']['item'] = 'cat3';

// replace parameters in url and erase path and query
$m_new_url = $seo->url_add_param ($m_new_url, $m_change, 'params');

// we have value as array so we have to convert to string to display
$m_new_url_string = $seo->array2url ($m_new_url);

echo "m_new_url_string = $m_new_url_string\n";

?>
</pre>

<pre>
<?php

echo "site_root = " . $seo->get_root_url($m_new_url) . "\n";

?>
</pre>
