<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<HTML>

<HEAD>

<LINK REL=stylesheet HREF="../style/weavprint2.css" TYPE="text/css">


<TITLE>Regular Expressions Reference Sheet</TITLE>
<style type="text/css">
<!--
.style6 {font-size: large}
.style9 {font-size: medium; font-weight: bold; }
-->
</style>
</HEAD>

<BODY>
<div align="center" class="style6">Regular Expressions Reference Sheet</div><br>


<CENTER>
<TABLE CELLSPACING=0 CELLPADDING=2 ALIGN=CENTER WIDTH=700 BORDER=1>
<tr valign=top><td><span class="style9">Character</span></td>
<td><span class="style9">Definition</span></td>
<td><span class="style9">Example</span></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>^</SPAN></strong></P></td><td>The pattern has to appear at the beginning <br>
  of a string.</td>
<td><SPAN CLASS=mono><strong>^cat</strong></SPAN> &nbsp;matches any string that begins with <SPAN CLASS=mono>cat</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>$</SPAN></strong></P></td><td>The pattern has to appear at the end of a string.</td>
<td><SPAN CLASS=mono><strong>cat$</strong></SPAN> &nbsp;matches any string that ends with <SPAN CLASS=mono>cat</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>.</SPAN></strong></P></td>
<td>matches any character.</td>
<td><SPAN CLASS=mono><strong>cat.</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>catT</SPAN> and <SPAN CLASS=mono>cat2</SPAN> but not <SPAN CLASS=mono>catty</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>[]</SPAN></strong></P></td><td>Bracket expression. &nbsp;matches one of any <br>
  characters enclosed.</td><td><SPAN CLASS=mono><strong>gr[ae]y</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>gray</SPAN> or <SPAN CLASS=mono>grey</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>[^]</SPAN></strong></P></td><td>Negates a bracket expression. &nbsp;matches <br>
  one of any characters EXCEPT those enclosed.</td><td><SPAN CLASS=mono><strong>1[^02]</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>13</SPAN> but not <SPAN CLASS=mono>10</SPAN> or <SPAN CLASS=mono>12</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>[-]</SPAN></strong></P></td><td>Range. &nbsp;matches any characters within the range.</td><td><SPAN CLASS=mono><strong>[1-9]</strong></SPAN> &nbsp;matches any single digit EXCEPT <SPAN CLASS=mono>0</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>?</SPAN></strong></P></td><td>Preceeding item must match one or zero times.</td><td><SPAN CLASS=mono><strong>colou?r</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>color</SPAN> or <SPAN CLASS=mono>colour</SPAN> but not <SPAN CLASS=mono>colouur</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>+</SPAN></strong></P></td><td>Preceeding item must match one or more times.</td><td><SPAN CLASS=mono><strong>be+</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>be</SPAN> or <SPAN CLASS=mono>bee</SPAN> but not <SPAN CLASS=mono>b</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>*</SPAN></strong></P></td><td>Preceeding item must match zero or more times.</td><td><SPAN CLASS=mono><strong>be*</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>b</SPAN> or <SPAN CLASS=mono>be</SPAN> or <SPAN CLASS=mono>beeeeeeeeee</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>()</SPAN></strong></P></td><td>Parentheses. Creates a substring or item that <br>
  metacharacters can be applied to</td><td><SPAN CLASS=mono><strong>a(bee)?t</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>at</SPAN> or <SPAN CLASS=mono>abeet</SPAN> but not <SPAN CLASS=mono>abet</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>{n}</SPAN></strong></P></td><td>Bound. Specifies exact number of times for the <br>
  preceeding item to match.</td><td><SPAN CLASS=mono><strong>[0-9]{3}</strong></SPAN> &nbsp;matches any three digits</td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>{n,}</SPAN></strong></P></td><td>Bound. Specifies minimum number of times for <br>
  the preceeding item to match.</td><td><SPAN CLASS=mono><strong>[0-9]{3,}</strong></SPAN> &nbsp;matches any three or more digits</td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>{n,m}</SPAN></strong></P></td><td>Bound. Specifies minimum and maximum number <br>
  of times for the preceeding item to match.</td><td><SPAN CLASS=mono><strong>[0-9]{3,5}</strong></SPAN> &nbsp;matches any three, four, or five digits</td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>|</SPAN></strong></P></td><td>Alternation. One of the alternatives has to match.</td><td><SPAN CLASS=mono><strong>July (first|1st|1)</strong></SPAN> &nbsp;will match <SPAN CLASS=mono>July 1st</SPAN> but not <SPAN CLASS=mono>July 2</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>//</SPAN></strong></P></td><td>Default delimiters for pattern</td><td><SPAN CLASS=mono><strong>/colou?r/</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>color</SPAN> or <SPAN CLASS=mono>colour</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>i</SPAN></strong></P></td><td>Append to pattern to specify a case insensitive match</td><td><SPAN CLASS=mono><strong>/colou?r/i</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>COLOR</SPAN> or <SPAN CLASS=mono>Colour</SPAN></td>
</tr>

<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\b</SPAN></strong></P></td>
<td>A word boundary, the spot between word <SPAN CLASS=mono>(\w)</SPAN> and non-word <SPAN CLASS=mono>(\W)</SPAN> characters</td>
<td><SPAN CLASS=mono><strong>/\bfred\b/i</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>Fred</SPAN> but not <SPAN CLASS=mono>Alfred</SPAN> or <SPAN CLASS=mono>Frederick</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\B</SPAN></strong></P></td><td>A non-word boundary</td><td><SPAN CLASS=mono><strong>/fred\B/i</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>Frederick</SPAN> but not <SPAN CLASS=mono>Fred</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\d</SPAN></strong></P></td><td>A single digit character</td><td><SPAN CLASS=mono><strong>/a\db/i</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>a2b</SPAN> but not <SPAN CLASS=mono>acb</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\D</SPAN></strong></P></td><td>A single non-digit character</td><td><SPAN CLASS=mono><strong>/a\Db/i</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>aCb</SPAN> but not <SPAN CLASS=mono>a2b</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\n</SPAN></strong></P></td><td>The newline character. (ASCII 10)</td><td><SPAN CLASS=mono><strong>/\n/</strong></SPAN> &nbsp;matches a newline</td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\r</SPAN></strong></P></td><td>The carriage return character. (ASCII 13)</td><td><SPAN CLASS=mono><strong>/\r/</strong></SPAN> &nbsp;matches a carriage return</td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\s</SPAN></strong></P></td><td>A single whitespace character</td><td><SPAN CLASS=mono><strong>/a\sb/</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>a b</SPAN> but not  <SPAN CLASS=mono>ab</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\S</SPAN></strong></P></td><td>A single non-whitespace character</td><td><SPAN CLASS=mono><strong>/a\Sb/</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>a2b</SPAN> but not  <SPAN CLASS=mono>a b</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\t</SPAN></strong></P></td><td>The tab character. (ASCII 9)</td><td><SPAN CLASS=mono><strong>/\t/</strong></SPAN> &nbsp;matches a tab.</td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\w</SPAN></strong></P></td><td>A single word character - alphanumeric and <br>
  underscore</td><td><SPAN CLASS=mono><strong>/\w/</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>1</SPAN> or <SPAN CLASS=mono>_</SPAN> but not <SPAN CLASS=mono>?</SPAN></td>
</tr>


<tr valign=top><td><P ALIGN=center><strong><SPAN CLASS=mono>\W</SPAN></strong></P></td><td>A single non-word character</td><td><SPAN CLASS=mono><strong>/a\Wb/i</strong></SPAN> &nbsp;matches <SPAN CLASS=mono>a!b</SPAN> but not <SPAN CLASS=mono>a2b</SPAN></td>
</tr>




</TABLE>
   <p>&nbsp;</p>
</CENTER>

</BODY>

</HTML>