<?php
	/**************************************************************************\
	* eGroupWare - Trouble Ticket System                                       *
	* http://www.egroupware.org                                                *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: states.php,v 1.3 2004/01/27 19:09:34 reinerj Exp $ */

	/* Note to self:
	** Self ... heres the query to use when limiting access to entrys within a group
	** The acl class *might* handle this instead .... not sure
	** select distinct group_ticket_id, phpgw_tts_groups.group_ticket_id, phpgw_tts_tickets.*
	** from phpgw_tts_tickets, phpgw_tts_groups where ticket_id = group_ticket_id and group_id in (14,15);
	*/

	/* ACL levels
	** 1 - Read ticket within your group only
	** 2 - Close ticket
	** 4 - Allow to make changes to priority, billing hours, billing rate, category, and assigned to
	*/

	$GLOBALS['phpgw_info']['flags']['currentapp'] = 'tts';
	$GLOBALS['phpgw_info']['flags']['enable_contacts_class'] = True;
	$GLOBALS['phpgw_info']['flags']['enable_categories_class'] = True;
	$GLOBALS['phpgw_info']['flags']['enable_nextmatchs_class'] = True;
	$GLOBALS['phpgw_info']['flags']['noheader'] = True;
	include('../header.inc.php');

	$GLOBALS['phpgw_info']['flags']['app_header'] = $GLOBALS['phpgw_info']['apps']['tts']['title'].' - '.lang("List of available tickets' states.");
	$GLOBALS['phpgw']->common->phpgw_header();

	$GLOBALS['phpgw']->historylog = createobject('phpgwapi.historylog','tts');

	$GLOBALS['phpgw']->template->set_file('states','states.tpl');
	$GLOBALS['phpgw']->template->set_block('states', 'state_list', 'state_list');
	$GLOBALS['phpgw']->template->set_block('states', 'state_row', 'state_row');

	// select what tickets to view
	$filter = reg_var('filter','GET');
	$start  = reg_var('start','GET','numeric',0);
	$sort   = reg_var('sort','GET');
	$order  = reg_var('order','GET');

	if (!$sort)
	{
		$sortmethod = 'order by state_name';
	}
	else
	{
		$sortmethod = "order by $order $sort";
	}

	if (!$filter)
	{
		$filtermethod = '';
	}
	else
	{
		$filtermethod = "where $filter";
	}

	$GLOBALS['phpgw']->db->query("select * from phpgw_tts_states $filtermethod $sortmethod",__LINE__,__FILE__);
	$numfound = $GLOBALS['phpgw']->db->num_rows();

	// fill header
	$GLOBALS['phpgw']->template->set_var('tts_head_stateid', $GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,'state_id',$order,'/tts/states.php','#'));
	$GLOBALS['phpgw']->template->set_var('tts_head_state', $GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,'state_name',$order,'/tts/states.php',lang('State')));
	$GLOBALS['phpgw']->template->set_var('tts_head_description', $GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,'state_description',$order,'/tts/states.php',lang('Description')));
	$GLOBALS['phpgw']->template->set_var('lang_add',lang('Add'));
	$GLOBALS['phpgw']->template->set_var('lang_edit',lang('Edit'));
	$GLOBALS['phpgw']->template->set_var('lang_delete',lang('Delete'));

	if ($GLOBALS['phpgw']->db->num_rows() == 0)
	{
		$GLOBALS['phpgw']->template->set_var('rows', '<p><center>'.lang('No states found').'</center>');
	}
	else
	{
		$i = 0;
		while ($GLOBALS['phpgw']->db->next_record())
		{
			$GLOBALS['phpgw']->template->set_var('tts_col_status','');

			$GLOBALS['phpgw']->template->set_var('row_class', ++$i & 1 ? 'row_on' : 'row_off' );
			$GLOBALS['phpgw']->template->set_var('tts_stateedit_link', $GLOBALS['phpgw']->link('/tts/edit_state.php','state_id=' . $GLOBALS['phpgw']->db->f('state_id')));
			$GLOBALS['phpgw']->template->set_var('tts_statedelete_link', $GLOBALS['phpgw']->link('/tts/delete_state.php','state_id=' . $GLOBALS['phpgw']->db->f('state_id')));

			$GLOBALS['phpgw']->template->set_var('state_id',$GLOBALS['phpgw']->db->f('state_id'));
			$GLOBALS['phpgw']->template->set_var('state_name',
				try_lang($GLOBALS['phpgw']->db->f('state_name'),False,True));
			$GLOBALS['phpgw']->template->set_var('state_description',
				try_lang($GLOBALS['phpgw']->db->f('state_description'),False));

			$GLOBALS['phpgw']->template->parse('rows','state_row',True);
		}
	}
	$GLOBALS['phpgw']->template->set_var('row_class', ++$i & 1 ? 'row_on' : 'row_off' );
	$GLOBALS['phpgw']->template->set_var('tts_stateadd_link', $GLOBALS['phpgw']->link('/tts/edit_state.php','state_id=0'));

	// this is a workaround to clear the subblocks autogenerated vars
	$GLOBALS['phpgw']->template->set_var('state_row','');

	$GLOBALS['phpgw']->template->pfp('out','states');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
