<?php
  /* -------------------------------------------------------------
   *  Blowfish_no-pear.php v1.0
   * -------------------------------------------------------------
   *  By: Gian Luca Ruggero (rgl_it@yahoo.it)
   *  Ultima Modifica: marted 06 Dicembre 2005
   * -------------------------------------------------------------
   *  Freeware 
   * -------------------------------------------------------------
   * 
   * blowfish_no-pear.php  una truffa.
   * ho preso il corrispettivo pacchetto da pear.php.net e gli ho
   * tolto tutto quello che serve per usare pear.php. questo perch il mio
   * amministratore non vuole sporcarsi le mani e installarmi pear su php.
   * 
   * Dato che mi serviva un script di codifica,  ho preso un algoritmo blowfish (non 
   * male come sicurezza...) e l'ho modificato per i miei usi.
   *
   * Abbiamo una chiave a 52 caratteri (52*8 = 416 bit!) 
   *
   * Funziona con PHP versions 4 and 5
   *
   * Utilizzo:
 
   include_once './percorso/del/file/blowfish_no-pear.php';
   $bf = new Crypt_Blowfish('una chiave segreta, come stringa normale!');
   $testo_criptato = $bf->encrypt('il testo che vuoi criptare');
   $testo_decriptato = $bf->decrypt($testo_criptato);
   echo "Testo criptato: $testo_decriptato";

  * se volete cambiare la chiave basta fare 
 
   $bf->setkey('nuova chiave per le vostr stinghe...');
 
 * nota: il costruttore deve essere invocato solo una volta!
 *
 *
 * Header originario:
 * @category   Encryption
 * @package    Crypt_Blowfish
 * @author     Matthew Fonda <mfonda@php.net>
 * @copyright  2005 Matthew Fonda
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id: Blowfish.php,v 1.81 2005/05/30 18:40:36 mfonda Exp $
 * @link       http://pear.php.net/package/Crypt_Blowfish
 */

class Crypt_Blowfish {
    // P-Array contains 18 32-bit subkeys
    var $_P = array();
    // Array of four S-Blocks each containing 256 32-bit entries
    var $_S = array();

    // costruttore della classe Crypt_Blowfish Constructor
    function Crypt_Blowfish($key) {
        $this->setKey($key);
    }
    
    function isReady() {
        return true;
    }
    
    function init()  {
        $this->_init();
    }
    
    // Inizializza l'oggetto Crypt_Blowfish
    function _init() {
        $defaults = new Crypt_Blowfish_DefaultKey();
        $this->_P = $defaults->P;
        $this->_S = $defaults->S;
    }
            
    // cripta un singolo blocco di 64 bit
    function _encipher(&$Xl, &$Xr) {
        for ($i = 0; $i < 16; $i++) {
            $temp = $Xl ^ $this->_P[$i];
            $Xl = ((($this->_S[0][($temp>>24) & 255] +
                            $this->_S[1][($temp>>16) & 255]) ^
                            $this->_S[2][($temp>>8) & 255]) +
                            $this->_S[3][$temp & 255]) ^ $Xr;
            $Xr = $temp;
        }
        $Xr = $Xl ^ $this->_P[16];
        $Xl = $temp ^ $this->_P[17];
    }
    
    
    // decripta un singolo blocco di 64 bit
    function _decipher(&$Xl, &$Xr)
    {
        for ($i = 17; $i > 1; $i--) {
            $temp = $Xl ^ $this->_P[$i];
            $Xl = ((($this->_S[0][($temp>>24) & 255] +
                            $this->_S[1][($temp>>16) & 255]) ^
                            $this->_S[2][($temp>>8) & 255]) +
                            $this->_S[3][$temp & 255]) ^ $Xr;
            $Xr = $temp;
        }
        $Xr = $Xl ^ $this->_P[1];
        $Xl = $temp ^ $this->_P[0];
    }
    
    
    // Cripta una stringa.
    // restituisce false se stringa = '';
    function encrypt($plainText) {
        if (!is_string($plainText)) return false;

        $cipherText = '';
        $len = strlen($plainText);
        $plainText .= str_repeat(chr(0),(8 - ($len%8))%8);
        for ($i = 0; $i < $len; $i += 8) {
            list(,$Xl,$Xr) = unpack("N2",substr($plainText,$i,8));
            $this->_encipher($Xl, $Xr);
            $cipherText .= pack("N2", $Xl, $Xr);
        }
        return $cipherText;
    }
    
    
    // Decrypta una stringa encryptata
    // restituisce il testo in chiaro o false se stringa = ''
    // alla stringa vengono tolti gli spazi finali.
    function decrypt($cipherText) {
        if (!is_string($cipherText)) return false;

        $plainText = '';
        $len = strlen($cipherText);
        $cipherText .= str_repeat(chr(0),(8 - ($len%8))%8);
        for ($i = 0; $i < $len; $i += 8) {
            list(,$Xl,$Xr) = unpack("N2",substr($cipherText,$i,8));
            $this->_decipher($Xl, $Xr);
            $plainText .= pack("N2", $Xl, $Xr);
        }
        return rtrim($plainText);
    }
    
    
    // setta la chiave segreta.
    // restituisce false se lunghezza(chiave) > 56 cartteri o nulla
    // restituisce true se la chiave  valida.    
    function setKey($key) {
        if (!is_string($key)) return false;

        $len = strlen($key);

        if ($len > 56 || $len == 0) return false;

        require_once ('./blowfish_default_key.php');
        $this->_init();
        
        $k = 0;
        $data = 0;
        $datal = 0;
        $datar = 0;
        
        for ($i = 0; $i < 18; $i++) {
            $data = 0;
            for ($j = 4; $j > 0; $j--) {
                    $data = $data << 8 | ord($key{$k});
                    $k = ($k+1) % $len;
            }
            $this->_P[$i] ^= $data;
        }
        
        for ($i = 0; $i <= 16; $i += 2) {
            $this->_encipher($datal, $datar);
            $this->_P[$i] = $datal;
            $this->_P[$i+1] = $datar;
        }
        for ($i = 0; $i < 256; $i += 2) {
            $this->_encipher($datal, $datar);
            $this->_S[0][$i] = $datal;
            $this->_S[0][$i+1] = $datar;
        }
        for ($i = 0; $i < 256; $i += 2) {
            $this->_encipher($datal, $datar);
            $this->_S[1][$i] = $datal;
            $this->_S[1][$i+1] = $datar;
        }
        for ($i = 0; $i < 256; $i += 2) {
            $this->_encipher($datal, $datar);
            $this->_S[2][$i] = $datal;
            $this->_S[2][$i+1] = $datar;
        }
        for ($i = 0; $i < 256; $i += 2) {
            $this->_encipher($datal, $datar);
            $this->_S[3][$i] = $datal;
            $this->_S[3][$i+1] = $datar;
        }
        
        return true;
    }
    
}

?>
