<?php
/*****************************************************************
 Page : index.php
 Description : a simple use of MovTable  
 Date : 20/04/05
 Authors:Alessandro Vigan (avigano@Movinfo.it) / Filippo Zanardo (fzanardo@MOViNFO.it)
 Copyright (C) 2005-2006 MOViNFO

MovTable is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

MovTable is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************/

require_once 'PHP/Compat.php';
PHP_Compat::loadFunction('http_build_query');
require_once('DB.php');

session_start();

//$pageurl='fax.php';

/**
 *movTable abstract class
 *
 *@abstract
 */
class movTable {
	/**
	 *Contains table data
	 *
	 * [row]['fieldname'] : mixed - Table cell
	 *@var array
	 */
	var $tdata;
	var $sort,$direction,$offset;
	/**
	 *The total number of records
	 *@var int
	*/
	var $count;
	/**
	 *The number of records per page
	 *@var int
	 */
	var $limit;
	var $filterField;
	var $filterValue;
	var $filterOption;
	
	/**
	* Contains the total number of pages
	* @var int
	*/
	var $npages;
	
	/**
	* Contains the current number of page
	* @var int
	*/
	var $currentpage;
	/**
	* Contains the javascript code to be placed in the <head> of the document
	* @var string
	*/
	var $JS;
	/**
	*Contains all the data to pass to smarty rendering engine
	*
	* 	['table']['columns'] : columns
	*
	*	['table']['tdata'] : tdata
	*
	*	['navigation']['pages'] : pages
	*
	*	['pageurl'] : pageurl
	*
	*	['filter']['hiddenFormValues']: hiddenFormValues
    *
	* 	['JS'] : JS
	*
    *   ['HTMLoptions']: HTMLoptions
	*  @var array
	*/ 
	var $movtable;
	
	/**
	* Contains urls for navigation
	*
	* ['first']: string - Url to first page
	*
	* ['next']: string - Url to next page
	*
	* ['previous']: string - Url to previous page
	*
	* ['last']: string - Url to last page
	*
	* @var array
	*/	
	var $pages;
	
	/**
	* Page URL
	*
	* @var string
	*/
	var $pageurl;
	
	/**
	 *Contains data used to create table headers
	 *
	 *['fieldname']['nome']: string - the field name to show
	 *
	 *['fieldname']['url']: string - the url to go on click
	 *
	 *['fieldname']['sorted']: boolean - TRUE if the field is currently sorted
	 *
	 *['fieldname']['direction']: string - Can be 'ASC' for ascending, 'DESC' for descending
	 *
	 *['fieldname']['filterable']: boolean - set if field is filterable
	 * @var array 
	 */
	var $columns;
	
	/**
	 * Contains the order of the columns (only visible columns are included)
	 * @var array;
	*/
	var $colOrder;
	
	/**
	* It contains the property of the fields
	* 
	* ['fieldname']['nome']: string - the field name to show
	*
	* ['fieldname']['sortable']: boolean - set if field is sortable
	*
	* ['fieldname']['filterable']: boolean - set if field is filterable
	* @var array
	*/
	var $fieldProp;
	
	/**
	* Contains the name of the callback function
	*
	* The callback function is used to generate calculated fields not present in the database.
	* The function receive the current row and it has to return the new row with the new fields
	* The generated fields are not CURRENTLY filterable or sortable
	*
	* @var string
	*/
	var $customfunction;
	
	/**
	* It contains all the parameters to be put as hidden in the form filter
	*
	* @var array
	*/
	var $hiddenFormValues;
	
	/**
	* Contains the parameters used in generating the html page
	*
	* ['tableID']='sortable' : table id attribute
	*
	* ['tableClass']='sortable': table class attribute
	*
	* ['baseDir']='': the path to 'jscript' and 'themes' folder
	*
	* ['JSenable']=true: enable/disable javascript
	*
	* ['JScolresize']=true: enable/disable resize of the column
	*
	* ['JScolmove']=true: enable/disable column's movement
	*
	* ['JScolhide']=true: enable/disable hide of the column
	* 
	* ['JSlanguage']='locale_EN.js': strings translation file
	* @var array
	*/
	var $HTMLoptions;
	/**
	*movTable constructor
	*
	*@abstract	
	*@param string $pageurl Url of the page
	*@param array $fieldProp Field properties
	*@param string $callbackFunc callback function
	*@param array $HTMLoptions HTML options
	*
	*/
	function movTable ($pageurl,$fieldProp,$callbackFunc,$HTMLoptions=null){
		$this->pageurl=$pageurl;
		
		$this->limit=20;
		$this->fieldProp=$fieldProp;
		$this->convertJScalls();	
		$this->HTMLoptions=$HTMLoptions;
		$this->HTMLoptions['tableID']=isset($this->HTMLoptions['tableID']) ? $this->HTMLoptions['tableID'] : 'movtable';
		$this->HTMLoptions['tableClass']=isset($this->HTMLoptions['tableClass']) ? $this->HTMLoptions['tableClass'] : 'movtable';
		$this->HTMLoptions['JSenable']=isset($this->HTMLoptions['JSenable']) ? $this->HTMLoptions['JSenable'] : true;
		$this->HTMLoptions['JScolresize']=isset($this->HTMLoptions['JScolresize']) ? $this->HTMLoptions['JScolresize'] : true;
		$this->HTMLoptions['JScolmove']=isset($this->HTMLoptions['JScolmove']) ? $this->HTMLoptions['JScolmove'] : true;
		$this->HTMLoptions['JScolhide']=isset($this->HTMLoptions['JScolhide']) ? $this->HTMLoptions['JScolhide'] : true;
		$this->HTMLoptions['JSlanguage']=isset($this->HTMLoptions['JSlanguage']) ? $this->HTMLoptions['JSlanguage'] : 'locale_EN.js';
		$this->customfunction=$callbackFunc;
	}
		
	/**
	*This method does the query and assign the values to the smarty variable
	* @param Smarty &$smarty A smarty object
	* @access public
	*/
	function prinTable (&$smarty) {
		global $pageurl,$limit;
		
		$this->doquery();
			

			//Chiama la funzione di callback per generare i campi custom
				if (isset($this->customfunction)){
				for ($i=0;$i<count($this->tdata);$i++){
				
					$cff=call_user_func($this->customfunction,$this->tdata[$i]);
					
					foreach($cff as $key=>$value2){
						$this->fieldProp[$key]["sortable"]=false;
						$this->fieldProp[$key]["visible"]=true;
						$this->fieldProp[$key]["filterable"]=false;
					}
					
					$this->tdata[$i]=array_merge($this->tdata[$i],$cff);
				}
			}
			
			foreach ($this->tdata[0] as $key => $value)
			{
						
			if (@array_key_exists("nome",$this->fieldProp[$key]))
				$this->columns[$key]["nome"]=$this->fieldProp[$key]["nome"];
			else 
				$this->columns[$key]["nome"]=$key;
			
			//controllo se il campo  ordinabile
			
			if ($this->fieldProp[$key]["sortable"]==true || !@array_key_exists("sortable",$this->fieldProp[$key]))	
			{
			
				$this->columns[$key]["url"]=$this->pageurl."?";
				
				if ($this->columns[$key]["sorted"] AND $this->columns[$key]["direction"] == "ASC") 
					$this->columns[$key]["url"] .= $this->modifyQuery(ARRAY('direction'=>'DESC','sort'=>$key,'offset'=>0));
				else
					$this->columns[$key]["url"] .= $this->modifyQuery(ARRAY('direction'=>'ASC','sort'=>$key,'offset'=>0));
			}
			
			if ($this->fieldProp[$key]["visible"]==true || !@array_key_exists("visible",$this->fieldProp[$key]))
			{
				$this->columns[$key]["visible"]=true;
			}
			else {
				$this->columns[$key]["visible"]=false;
			}
			
			if ($this->fieldProp[$key]["filterable"]==true || !@array_key_exists("filterable",$this->fieldProp[$key]))
			{
				$this->columns[$key]["filterable"]=true;
			}else{
				$this->columns[$key]["filterable"]=false;
			}
			
			if ($this->fieldProp[$key]["sortable"]==true || !@array_key_exists("sortable",$this->fieldProp[$key]))
			{
				$this->columns[$key]["sortable"]=true;
			}else{
				$this->columns[$key]["sortable"]=false;
			}
			
		}
			
		$this->generateIndex();	
		//Genera la lista di parametri da passare con il get ed il post
		$this->paraURL();
		$this->setColOrder();
		//Genera il codice Javascript
		$this->generateJS();	
		
		//smarty Nuove Variabili- Razionalizzazione delle vecchie
		$this->movtable['table']['columns']=$this->columns;
		$this->movtable['table']['tdata']=$this->tdata;
		$this->movtable['table']['colOrder']=$this->colOrder;
		$this->movtable['navigation']['limit']=$this->limit;
		$this->movtable['navigation']['pages']=$this->pages;
		$this->movtable['navigation']['npages']=$this->npages;
		$this->movtable['navigation']['currentpage']=$this->currentpage;
		$this->movtable['navigation']['records']=$this->count;
		$this->movtable['pageurl']=$this->pageurl;
		$this->movtable['filter']['hiddenFormValues']=$this->hiddenFormValues;
		$this->movtable['filter']['filterValue']=$this->filterValue;
		$this->movtable['JS']=$this->JS;
		$this->movtable['HTMLoptions']=$this->HTMLoptions;
		$smarty->assign('movtable',$this->movtable);

		
		//Registriamo il tdata nella sessione
		$_SESSION['tdata']=$this->tdata;
		$_SESSION['columns']=$this->columns;
		$_SESSION['colOrder']=$this->colOrder;
		$_SESSION['filterfield']=$this->filterField;
		$_SESSION['filtervalue']=$this->filterValue;
		$_SESSION['filteroption']=$this->filterOption;
		$_SESSION['limitoption']=$this->limit;
		
	}
	
	/**
	*
	*Set the callback function for the generation of calculated fields
	*
	*The function must be like:
	*<code>
	*function callback($tdata)
	*	if ($tdata['field1'] =='value') 
	*		return array ("newfield"=>'newvalue',"newfield2"=>'newvalue2');
	*</code>
	*
	*@param function $callbackFunc Callback function
	*@access public
	*/
	function SetCallBack($callbackFunc){
		$this->customfunction=$callbackFunc;
	}
				
	function doquery() {
	}
	
	function setsort() {
	}
	
	/**
	*Set the values for the sort
	*@access private
	*/
	function presort() {
		if (isset($_GET['sort']))
		{	
			$this->sort=$_GET['sort'];
			$this->columns[$this->sort]['sorted']=TRUE;
			
			
			$this->direction=isset($_GET['direction']) ? $_GET['direction'] : "ASC";
			$this->columns[$this->sort]['direction']=$this->direction;	
					
		}
	}
	
	/**
	*Set the range of records to be shown
	*@access private
	*/
	function prerange() {
		$this->offset=isset($_GET['offset']) ? $_GET['offset'] : "0";
		//$this->limit=isset($_SESSION['limitoption']) ? $_SESSION['limitoption'] : 20;
		$this->limit=isset($_GET['limitoption']) ? $_GET['limitoption'] : (isset($_SESSION['limitoption']) ? $_SESSION['limitoption'] : 20);
	}
	
	/**
	*Set values for the filters
	*@access private
	*/
	function prefilter() {
		$this->filterField=isset($_GET['filterfield']) ? $_GET['filterfield'] : NULL;
			
		$this->filterValue=isset($_GET['filtervalue']) ? $_GET['filtervalue'] : NULL;
		if ($this->filterValue=='') $this->filterValue=NULL;
		

		
		if (!is_null ($this->filterField) and !is_null($this->filterValue)) {
			$this->columns[$this->filterField]['filtered']=true;
		}
		
		$this->filterOption=isset($_GET['filteroption']) ? $_GET['filteroption'] : 'Begin';
		
		if ($this->filterField) {
			$this->columns[$this->filterField]['filterValue']=$this->filterValue;
			$this->columns[$this->filterField]['filterOption']=$this->filterOption;
		}
	}
	
	/**
	*Set the value for the columns
	*@access private
	*/
	function setColOrder() {
	
		foreach ($this->tdata[0] as $key=>$value)
			if ($this->columns[$key]['visible']) 
				$this->colOrder[]=$key;
					
		$cookie=$this->HTMLoptions['tableClass'].'_colOrder';
		if (isset($_GET['colorder'])) 
		{	
			$splitted=split(':',$_GET['colorder']);
			//Controllare che il numero di argomenti sia giusto
			if (count($splitted) == count($this->colOrder))
			{
				$this->colOrder=$splitted;
				return;
			}
		}
		elseif (isset($_COOKIE[$cookie]))
		{	
			$splitted=split(':',$_COOKIE[$cookie]);
			//Controllare che il numero di argomenti sia giusto
			if (count($splitted) == count($this->colOrder)) {
				$this->colOrder=$splitted;
				return;
			}
		}
		

	}
	
	/**
	*Generates the urls for pages navigation
	*@access private
	*/
	function generateIndex(){
		
		if ($this->offset > 0)
		{	
			$previous=($this->offset - $this->limit) > 0 ? ($this->offset - $this->limit) : 0;
			$this->pages['first']=$this->modifyQuery('offset',0);
			$this->pages['previous']=$this->modifyQuery('offset',$previous);
		}
		
		$next=$this->offset+$this->limit;
		$this->npages=ceil($this->count / $this->limit);
		$this->currentpage=($this->offset/$this->limit)+1;
		
		if ($next < $this->count) {
			$this->pages['next']=$this->modifyQuery('offset',$next);
			$this->pages['last']=$this->modifyQuery('offset',($this->npages-1)*$this->limit);
		}
		
		
		
	}
	
	/**
	 * Generates a query string starting from the last ($_GET)
	 *
	 * This can be called in two ways:
	 * <code>
	 * //Assign the original query with the parameter 'offset' now set to 10
	 *$return=$this->modifyQuery('offset',10); 
	 * //Now we modify several parameters passing an array
	 *$return= $this->modifyQuery(ARRAY('direction'=>'DESC','sort'=>'FIELD'));
	 * </code>
	 * @return string
	 * @access private
	 */
	function modifyQuery($toModify,$value = NULL)
	{
		$Query=$_GET;
		if (is_array($toModify))
			foreach ($toModify as $key => $value)
				$Query[$key]=$value;
		else
			$Query[$toModify]=$value;
		
		return http_build_query($Query);
	}
	
	/**
	* Creates a list of hidden values to placed in the filter form
	* @access private
	*/	
	function paraURL(){
		$donotcopy=array('filterfield','filtervalue','offset','filteroption','filterByIndexCol','filterByIndexRow','limitoption');
		foreach ($_GET as $key=>$value){
			if (!in_array($key,$donotcopy))
				$this->hiddenFormValues[$key]=$value;
		}
	}
	
	/**
	* Generate javascript code
	* @access private
	*/
	function generateJS(){
		@ $baseUrl=$this->pageurl."?".http_build_query($this->hiddenFormValues);
		$this->JS =<<<EOD
<link rel="stylesheet" type="text/css" href="{$this->HTMLoptions['baseDir']}themes/office_xp/office_xp.css" />
<script type="text/javascript" src="{$this->HTMLoptions['baseDir']}jscript/jsdomenu.js"></script>
<script type="text/javascript" src="{$this->HTMLoptions['baseDir']}jscript/movtableInc.js"></script>
<script type="text/javascript" src="{$this->HTMLoptions['baseDir']}jscript/{$this->HTMLoptions['JSlanguage']}"></script>
<script type="text/javascript">
	var baseurl= "$baseUrl";
	var tableClass = "{$this->HTMLoptions['tableClass']}";
	var JScolresize="{$this->HTMLoptions['JScolresize']}";
	var JScolmove="{$this->HTMLoptions['JScolmove']}";
	var JScolhide="{$this->HTMLoptions['JScolhide']}";

EOD;
		$this->JS.= "\tvar filtered =" . (int) ($this->filterValue != '') . ";\n";
		//We pass columns information to JS
		$this->JS.="\tvar sortable = new Array (";
		for ($x=0;$x<count($this->colOrder);$x++) 
		{
			$this->JS.=(int) $this->columns[$this->colOrder[$x]]['sortable'];
			if ($x<(count($this->colOrder)-1))
				$this->JS.=",";
		}
		$this->JS.=");\n";
		
		$this->JS.="\tvar filterable = new Array (";
		for ($x=0;$x<count($this->colOrder);$x++) 
		{
			$this->JS.=(int) $this->columns[$this->colOrder[$x]]['filterable'];
			if ($x<(count($this->colOrder)-1))
				$this->JS.=",";
		}
		$this->JS.=");\n";		
		
		$this->JS .="</script>\n";
	}
			
	/**
	* Converts the parameters passed by javascript context menus in values of _$GET
	* @access private 
	*/
	function convertJScalls () {
		
		
		$keyIndx=$_SESSION['colOrder'];
		if (isset($_GET['filterByIndexCol'])) {   
		     $_GET['filterfield']=$keyIndx[$_GET['filterByIndexCol']];
			unset($_GET['filterByIndexCol']);
		}
			
		if (isset($_GET['filterByIndexRow'])) {
			$_GET['filtervalue']=$_SESSION['tdata'][$_GET['filterByIndexRow']][$_GET['filterfield']];
			unset($_GET['filterByIndexRow']);
		}
		
		if (isset($_GET['removefilter'])) {
			unset($_GET['filtervalue']);
			unset($_GET['filterfield']);
			unset($_GET['filteroption']);
			unset($_GET['removefilter']);
		}
		if (isset($_GET['sortByIndexCol'])) {
			$_GET['sort']=$keyIndx[$_GET['sortByIndexCol']];
			unset($_GET['sortByIndexCol']);
			//Settiamo il filtro come era prima
			$_GET['filtervalue']=$_SESSION['filtervalue'];
			$_GET['filteroption']=$_SESSION['filteroption'];
			$_GET['filterfield']=$_SESSION['filterfield'];
		}
	}
}

/**
 *movTableDB class to generate easily interactive html table from databases supported by pear:db
 *
 *@abstract
 */
class movTableDB extends movTable {
	var $dsn;
	var $db;
	var $query;
	
	/**
	* Creates a movTable object
	* @param string $dsn connection string to DB
	* @param string $sql query string. Attention: if there is a WHERE clause specify the fields as 'table.field' 
	* @param string $url page URL
	* @param array $fieldProp Fields Properties
	* @param string $callbackFunc Callback function
	* @param array $HTMLoptions HTML parameters
	* @access public
	*/
	function movTableDB($dsn,$sql,$url="",$fieldProp=null,$callbackFunc=null,$HTMLoptions=null) {
		parent::movTable($url,$fieldProp,$callbackFunc,$HTMLoptions);
		$this->dsn=$dsn;
		$this->query=$sql;
	}
	
	/**
	* Connect to database
	* @access private
	*/
	function Connect() {
		$this->db=& DB::connect($this->dsn);
		if (PEAR::isError($this->db)) {
    		die($this->db->getMessage());
			}
	}
	
	/**
	* Execute query
	* @access private
	*/
	function doquery (){
		
		$this->Connect();
			
		//Get fieldsname even in the case there will be no records after the filter
		$result = & $this->db->query($this->query. " LIMIT 1");
		if (PEAR::isError($result)) {
   			 die($result->getDebugInfo());
		}
		$fieldsNames=$result->fetchRow(DB_FETCHMODE_ASSOC);
		
		$this->setfilter();
		$this->setsort();		
		
		$result = & $this->db->query($this->query);
		if (PEAR::isError($result)) {
   			 die($result->getDebugInfo());
		}
		
		$this->count=$result->numRows();
		$this->setrange();
		
		$result =& $this->db->query($this->query) or die('Query failed:');
		
		if (PEAR::isError($result)) {
   			 die($result->getMessage());
		}
		
		while ($row=$result->fetchRow(DB_FETCHMODE_ASSOC))
			$this->tdata[]=$row;
			
		if (count($this->tdata)==0) 
			foreach ($fieldsNames as $key=>$value)
				$this->tdata[0][$key]='&nbsp;'; 
		
	}
	
	/**
	* Set the range of the results in the query
	* @access private
	*/
	function setrange() {
		$this->prerange();
		$this->query .= " LIMIT $this->limit OFFSET ".$this->offset;
	}
		
	/**
	* Set the order in the query
	* @access private
	*/
	function setsort() {
		
		$this->presort();

		if (isset($this->sort))
			$this->query.=' ORDER BY '.$this->sort.' '.$this->direction;
	}
	
	/**
	* Set the filter in the query
	* @access private
	*/
	function setfilter() {
		$this->prefilter();

		if (! is_null ($this->filterField)) {

			switch ($this->filterOption){
				case "Begin":
					$filterQuery=$this->filterField." LIKE '".$this->filterValue."%'";
					break;
				case "Contain":
					$filterQuery=$this->filterField." LIKE '%".$this->filterValue."%'";
					break;
				case "notEqual":
					$filterQuery="{$this->filterField} != '{$this->filterValue}'";
					break;
			}
			 //Quote madness
			 $filterQuery=str_replace("'","\'",$filterQuery);
			 $pattern="/(FROM.*?) *(WHERE.*?)?($|GROUP BY|HAVING|ORDER BY|LIMIT|PROCEDURE|FOR UPDATE)/ie";
			 $replace="('\$2' !='') ? '\$1 \$2 AND $filterQuery \$3' : '\$1 WHERE $filterQuery \$3'";
			 $this->query=preg_replace($pattern, $replace, $this->query);	
		}
	}
		
}



?>