<?php
/***************************************************************************************************
*
*   Class:          OpenShortUrl
*   Author:         jasx@inwind.it
*   Plataform:      Php 4.3 or > & MySql 3.22.xx or > & Apache 1.3.2 or > & Mod_rewrite
*   License:        Gpl 2.0 - http://www.gnu.org/licenses/gpl.txt
*   Date:           First release 16-11-2004
*   Version:        0.5.XX --> README
*
****************************************************************************************************/

error_reporting(E_WARNING);

define("HOSTDB","localhost");                             	//db host
define("USERDB","root");                                  	//db user
define("PASSDB","");                                      	//db pass
define("DB","openshorturl");                                //db name
define("DEFAULTPAGE","1go.it/index.php");                	//default redirect url page senza http:// ex. 1go.it/index.php
define("HOST","1go.it");                                 	//default index project senza http://  e senza / finale		ex. 1go.it
define("NOMEHOST","1go");                                 	//nome del progetto
define("LANG","IT");									  	//definisce il language handler.
define("VERSION","0.5.5 BETA");								//Versione corrente								


// _ sono metodi privati

class OpenShortUrl{

var  $link = 0;             								//link collegamento al database
var  $url;                  								//url da modificare
var  $shorturl = 0;         								//short url creato
var  $password;             								//password generale
var	 $msg;													//msg handler
var  $error = 0;											//indicatore di errori 1 True 0 False			

/*
*	Function:	openshorturl()				costruttore della classe
*/
function openshorturl(){
	include("language/".LANG.".php");						//inclusione lang handler		
	$this->msg = $msg;	
	$this->_db_connect();									//collegamento al database
}

/*
*   Function:   create_shorturl()       generazione shorturl (gh67h)
*   Argomenti:  $url                	string url da trasformare
*               $mask               	Y/N se si vuole il mascheramento dell'url
*               $pass               	string  password per statistiche
*               $auto               	shorturl prescelto
*   Return:     short url finale
*/
function create_shorturl($url="",$mask,$preshorturl="0"){

    //controllo sul formato url
    if (!ereg ("^(http://|https://|ftp://)(.*)\.(.*)", $url, $regs)){
        $this->error = 1;	
		return $this->msg['ERRFormatourl'];
    }

  
    $this->password = $this->_create_password();      //crea la password random

    if ((!$this->_verify_shorturl($preshorturl)) AND (!empty($preshorturl))){     //controlla se shorturl gia esiste e che non sia vuota

            	$this->shorturl = $preshorturl;
			
    }else{

        do{
            $this->shorturl = $this->_seq_shorturl();
        }while(
            $this->_verify_shorturl($this->shorturl)
        );

    }

    //salva i dati
    $this->_insert_shorturl($this->shorturl,$url,$mask,$this->password);


    $this->url = $url;

    if(!isset($this->shorturl))
        return $this->msg['ERRShorturl'];
    else
        return "http://".HOST."/".$this->shorturl;
}

/*  
*	Function:   html_code()     codice link html
*   Argomenti:  $shorurl        string shorturl
*/
function html_code($shorturl){

	if($this->error == 0)	
     return "&lt;a href=\"".$shorturl."\"&gt;".$shorturl."&lt;/a&gt;";
}

/*
*   Function:   bbforum_code()  codice per bbforum
*   Argomento:  $shorturl       string shorturl
*/
function bbforum_code($shorturl){
	if($this->error == 0)
    	return "[url]".$shorturl."[/url]";
}

/*
*   Function:   _db_connect()       connessione al database
*   Return:     $this->link
*/
function _db_connect(){

  if($this->link == 0){   //se gia 1 non effettua un ulteriore collegamento
    $link = mysql_connect(HOSTDB,USERDB,PASSDB) or die ("Error: ".mysql_error());
    mysql_select_db(DB,$link) or die ("Error: ".mysql_error());
    return $this->link = $link;
  }
}

/*
*   Function:   _verify_tiny()      verifica che il valore tiny(gbh67) non sia gi assegnato.
*   Argomento:  $shorturl           string valore shorturl(gbh67)
*   Return:     True/False
*/
function _verify_shorturl($shorturl){

  $query = mysql_query("select shorturl from openshorturl where shorturl=\"$shorturl\"",$this->link);

  if (mysql_num_rows($query) == "1")
    return True;
  else
    return False;
}

/*
*   Function:   _rand_tiny()      crea il tiny(gbh67) in maniera random
*   Return:     $shorturl
*/
function _rand_shorturl(){
    //v 1.0

    $value = array("1","2","3","4","5","6","7","8","9","q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","z","x","c","v","b","n","m");

    srand ((double) microtime() * 1000000);

    for ($i=0;$i<rand(1,5);$i++){
        $tiny .= $value[rand(0,count($value))];
    }


    return $tiny;
}

/*
*   Function:   _seq_tiny()       crea il tiny(gbh67) in maniera sequenziale partendo dall'ultimo creato nel db
*   Return:     $shorturl
*/
function _seq_shorturl($tiny=""){
    //v 2.0

    $rtiny = mysql_query("select shorturl from openshorturl order by id desc limit 1",$this->link);

    $rsl = mysql_fetch_array($rtiny);

    $tiny = $rsl['shorturl'];    //tiny corrente da prendere dal database

    $value = array("1","2","3","4","5","6","7","8","9","q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","z","x","c","v","b","n","m");

    $max_value = count($value)-1; //totale dei valori


    $ln = strlen($tiny);   //numere valori nel tiny


    for($i=1;$i<=$ln;$i++){

           $pos = array_search($tiny[$ln-$i],$value);

            if ($pos < $max_value){ //se il valore attuale e minore di 35 aumenta + 1
                $tiny[$ln-$i] = $value[$pos+1];
                $mtiny = 1;
                break;
            }else{

              $tiny[$ln-$i] = $value[0];

            }

    }

    if ($mtiny==0){
        for($i=1;$i<=$ln;$i++)
            $tiny[$ln-$i]=1;     //resetta ogni indice a 1

        $tiny ="1".$tiny;           //aggiunge un nuovo valore al tiny 1mm
    }

    return $tiny;
}

/*
*   Function:   _insert_tiny()      inserisce il tiny (gbh67) nel database
*   Argomenti:  $shorturl           string shorturl(grt67h)
*               $url                string indirizzi da shorturly
*               $mask               string  mascheramento url
*               $pass               string password per visualizzare le statistiche
*/
function _insert_shorturl($shorturl,$url,$mask,$pass){

    if($mask=="")//se mask non settato setta N
        $mask="N";


    return mysql_query("insert into openshorturl values (
                            \"\",
                            \"".$url."\",
                            \"".$shorturl."\",
                            \"".date('Y-m-d h:m:s')."\",
                            \"".$_SERVER['REMOTE_ADDR']."\",
                            \"".date('Y-m-d h:m:s')."\",
                            \"0\",
                            \"".$mask."\",
                            md5(\"".$pass."\")
                            )");
}

/*
*   Function:   find_url()         cerca l'url in base al tiny passato
*   Argomenti:  $shorturl          string valore del tiny
*               $page              sottopagina del sito
*/
function find_url($shorturl,$page){

    if ($shorturl=="")
        header("Location: http://".DEFAULTPAGE);

    //update data ultima connessione e click link
    mysql_query("update openshorturl set data_visita = \"".date('Y-m-d h:m:s')."\" , click = click+1 where shorturl = \"".$shorturl."\" limit 1",$this->link);
	
    if(mysql_affected_rows($this->link)=="0")
        return DEFAULTPAGE;

    //selezione url , mask dal database
    $rtiny = mysql_query("select url , mask from openshorturl where shorturl = \"".$shorturl."\" limit 1",$this->link);

    $rsl = mysql_fetch_array($rtiny);
	
	
    if($rsl['mask']=="Y")
          $this->_mask_shorturl($rsl['url']);
    else
          $this->_redirect_shorturl($rsl['url'],$page);

}

/*
*   Function:   redirect_shorturl()     funzione che fa il redirect verso il dominio
*/
function _redirect_shorturl($url="",$page=""){

    if ($page!="") //se esiste la sottopagina
        $addstring = "/".$page;

        header("location:".$url.$addstring );
        exit;
}

/*
*   Function:   mask_tiny()         funzione che apre il sito web in un frame
*/
function _mask_shorturl($url=""){

    echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">";
    echo "<html><head><title>Welcome to ".NOMEHOST." </title>";
    echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"></head>";
    echo "<frameset rows=\"0,*\" frameborder=\"NO\" border=\"0\" framespacing=\"0\">";
    echo "<frame src=\"/top_frame.php\" name=\"topFrame\" scrolling=\"NO\" noresize >";
    echo "<frame src=\"".$url."\" name=\"mainFrame\">";
    echo "</frameset><noframes><body></body></noframes></html>";
}

/*
*   Function:       count_char()    conta i caratteri totali con il tiny rispetto a quelli di partenza
*/
function count_char(){

	if($this->error == 0){
        $ln_url =(strlen($this->url)-7);
        $ln_shorturl =(strlen(HOST.$this->shorturl));

        $good = ceil(($ln_shorturl*100)/$ln_url)."%";

        $save  = $this->url." <b>&raquo; ".$ln_url." &laquo;</b>";
        $save .="<br><br>http://".HOST."/".$this->shorturl." <b>&raquo; ".$ln_shorturl." &laquo;</b>";
        $save .="<br><br><br>".$this->msg['MSGRisparmio']."<br><b> &raquo;&raquo; ".$good." &laquo;&laquo;</b>";

        return $save;
	}
}
/*
*   Function:       show_stats()     mostra le stats di un shorturl
*/
function show_stats($shorturl,$pass){

      if($pass=="")
        return $this->msg['ERRMustPass'];	

      $query = mysql_query("select data_visita , click , data_creazione from openshorturl where shorturl =\"".$shorturl."\" and pass = md5(\"".$pass."\")",$this->link);

      $rsl = mysql_fetch_array($query);

      if ($rsl['click']=="")
        return $this->$msg['ERRMustPass'];
      else
        return "<b>".$this->msg['MSGShortcreato']."</b>".$rsl['data_creazione']."<br> <b>Click: </b>".$rsl['click']."<br> <b>".$this->msg['MSGUltimoAccesso']."</b> ".$rsl['data_visita'];
}
/*
*  Function:    create_password()   crea password random per la visualizzazione delle stats
*/
Function _create_password(){

    $char = array("q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","z","x","c","v","b","n","m");

    srand ((double) microtime() * 1000000);

    for ($i=0;$i<rand(4,8);$i++){
        $password .= $char[rand(0,count($char))];
    }

    return $password;
}
}//fine openshorturl class
?>