<?
//------------------------------------------------------------------------------//
// Classe per la gestione di grafici a torta                                    //
//------------------------------------------------------------------------------//

class pieGraph {
	var $color; 	// Array dei colori usati per disegnare il grafico
	var $htmlColor;	//Array dei colori della leggenda
	var $size;  	// Dimensione dell'immagine del grafico in pixel
	var $nomi; 		// Array delle etichette 
	var $valori;	// Array dei valori
	var $titolo;	// Il titolo del grafico
	var $spessore;	// Spessore della torta in pixel
	var $percorso;	// Percorso in cui creare l'immagine
	var $nome;		// Nome dell'immagine
	var $leggenda;	// Indica se stampare o meno la leggenda
	var $img;		// L'immagine del grafico
	
	function pieGraph($size, $spessore, $val, $etichette, $titolo) {
		if (!isset($size) || !is_int($size) || $size=="") $size = 200;
		$this->size = $size;
		if (!is_array($val)) {
			echo "Errore, il terzo parametro deve essere un array";
			exit;
		}
		elseif (!is_array($etichette)) {
			echo "Errore, il quarto parametro deve essere un array";
			exit;		
		}
		elseif (sizeof($val) > 37 || sizeof($etichette) > 37 || sizeof($val)!=sizeof($etichette)) {
			echo "Errore, l'array dei valori e delle etichette devono avere la stessa cardinalit minore di 37";
			exit;			
		}
		else {
			$this->valori = $val;
			$this->nomi = $etichette;
			$this->img = imagecreate($size, $size);		
			$this->bianco = imagecolorallocate($this->img, 255, 255, 255);	
				
			$this->color[0][0] = imagecolorallocate($this->img, 255, 0, 0); 			// tonalit rosse
			$this->color[1][0] = imagecolorallocate($this->img, 204, 0, 0);		
			$this->htmlColor[0] = "#FF0000";	
			$this->color[0][7] = imagecolorallocate($this->img, 255, 51, 51);
			$this->color[1][7] = imagecolorallocate($this->img, 204, 51, 51);			
			$this->htmlColor[7] = "#FF3333";	
			$this->color[0][14] = imagecolorallocate($this->img, 255, 102, 102);
			$this->color[1][14] = imagecolorallocate($this->img, 204, 102, 102);
			$this->htmlColor[14] = "#FF6666";
			$this->color[0][20] = imagecolorallocate($this->img, 255, 153, 153);
			$this->color[1][20] = imagecolorallocate($this->img, 204, 153, 153);
			$this->htmlColor[20] = "#FF9999";
			$this->color[0][26] = imagecolorallocate($this->img, 153, 0, 0);
			$this->color[1][26] = imagecolorallocate($this->img, 102, 0, 0);
			$this->htmlColor[26] = "#990000";
			$this->color[0][32] = imagecolorallocate($this->img, 153, 51, 51);
			$this->color[1][32] = imagecolorallocate($this->img, 102, 51, 51);
			$this->htmlColor[32] = "#";
						
			$this->color[0][1] = imagecolorallocate($this->img, 255, 153, 51);			// tonalit arancioni
			$this->color[1][1] = imagecolorallocate($this->img, 204, 102, 0);
			$this->htmlColor[1] = "#FF9933";
			$this->color[0][8] = imagecolorallocate($this->img, 255, 204, 153);
			$this->color[1][8] = imagecolorallocate($this->img, 204, 153, 102);
			$this->htmlColor[8] = "#FFCC99";
			
			$this->color[0][2] = imagecolorallocate($this->img, 255, 255, 0);			//tonalit gialle
			$this->color[1][2] = imagecolorallocate($this->img, 204, 204, 0);			
			$this->htmlColor[2] = "#FFFF00";
			$this->color[0][9] = imagecolorallocate($this->img, 153, 153, 0);
			$this->color[1][9] = imagecolorallocate($this->img, 102, 102, 0);
			$this->htmlColor[9] = "#999900";
			$this->color[0][15] = imagecolorallocate($this->img, 255, 255, 153);
			$this->color[1][15] = imagecolorallocate($this->img, 204, 204, 102);
			$this->htmlColor[15] = "#FFFF99";
			$this->color[0][21] = imagecolorallocate($this->img, 255, 255, 204);
			$this->color[1][21] = imagecolorallocate($this->img, 204, 204, 153);
			$this->htmlColor[21] = "#FFFFCC";
			$this->color[0][27] = imagecolorallocate($this->img, 153, 153, 102);
			$this->color[1][27] = imagecolorallocate($this->img, 102, 102, 51);
			$this->htmlColor[27] = "#999966";
			
			$this->color[0][3] = imagecolorallocate($this->img, 0, 255, 0);			// tonalit verdi
			$this->color[1][3] = imagecolorallocate($this->img, 0, 204, 0);
			$this->htmlColor[3] = "#00FF00";
			$this->color[0][10] = imagecolorallocate($this->img, 0, 153, 0);
			$this->color[1][10] = imagecolorallocate($this->img, 0, 102, 0);
			$this->htmlColor[10] = "#009900";
			$this->color[0][16] = imagecolorallocate($this->img, 51, 255, 51);
			$this->color[1][16] = imagecolorallocate($this->img, 51, 204, 51);
			$this->htmlColor[16] = "#33FF33";
			$this->color[0][22] = imagecolorallocate($this->img, 51, 153, 51);
			$this->color[1][22] = imagecolorallocate($this->img, 51, 102, 51);
			$this->htmlColor[22] = "#339933";
			$this->color[0][28] = imagecolorallocate($this->img, 102, 255, 102);
			$this->color[1][28] = imagecolorallocate($this->img, 102, 204, 102);
			$this->htmlColor[28] = "#66FF66";
			$this->color[0][33] = imagecolorallocate($this->img, 153, 255, 153);
			$this->color[1][33] = imagecolorallocate($this->img, 153, 204, 153);
			$this->htmlColor[33] = "#99FF99";
			
			$this->color[0][4] = imagecolorallocate($this->img, 0, 255, 255);			// tonalit celesti
			$this->color[1][4] = imagecolorallocate($this->img, 0, 204, 204);
			$this->htmlColor[4] = "#00FFFF";
			$this->color[0][11] = imagecolorallocate($this->img, 0, 153, 153);
			$this->color[1][11] = imagecolorallocate($this->img, 0, 102, 102);
			$this->htmlColor[11] = "#009999";
			$this->color[0][17] = imagecolorallocate($this->img, 51, 255, 255);
			$this->color[1][17] = imagecolorallocate($this->img, 51, 204, 204);
			$this->htmlColor[17] = "#33FFFF";
			$this->color[0][23] = imagecolorallocate($this->img, 51, 153, 153);
			$this->color[1][23] = imagecolorallocate($this->img, 51, 102, 102);
			$this->htmlColor[23] = "#339999";
			$this->color[0][29] = imagecolorallocate($this->img, 102, 255, 255);
			$this->color[1][29] = imagecolorallocate($this->img, 102, 204, 204);
			$this->htmlColor[29] = "#66FFFF";
			$this->color[0][34] = imagecolorallocate($this->img, 153, 255, 255);
			$this->color[1][34] = imagecolorallocate($this->img, 153, 204, 204);
			$this->htmlColor[34] = "#99FFFF";
			
			$this->color[0][5] = imagecolorallocate($this->img, 0, 0, 255);			// tonalit blu
			$this->color[1][5] = imagecolorallocate($this->img, 0, 0, 204);
			$this->htmlColor[5] = "#0000FF";
			$this->color[0][12] = imagecolorallocate($this->img, 0, 0, 153);
			$this->color[1][12] = imagecolorallocate($this->img, 0, 0, 102);
			$this->htmlColor[12] = "#000099";
			$this->color[0][18] = imagecolorallocate($this->img, 51, 51, 255);
			$this->color[1][18] = imagecolorallocate($this->img, 51, 51, 204);
			$this->htmlColor[18] = "#3333FF";
			$this->color[0][24] = imagecolorallocate($this->img, 51, 51, 153);
			$this->color[1][24] = imagecolorallocate($this->img, 51, 51, 102);
			$this->htmlColor[24] = "#333399";
			$this->color[0][30] = imagecolorallocate($this->img, 102, 102, 255);
			$this->color[1][30] = imagecolorallocate($this->img, 102, 102, 204);
			$this->htmlColor[30] = "#6666FF";
			$this->color[0][35] = imagecolorallocate($this->img, 153, 153, 255);
			$this->color[1][35] = imagecolorallocate($this->img, 153, 153, 204);
			$this->htmlColor[35] = "#9999FF";
			
			$this->color[0][6] = imagecolorallocate($this->img, 255, 0, 255);			// tonalit viola
			$this->color[1][6] = imagecolorallocate($this->img, 204, 0, 204);
			$this->htmlColor[6] = "#FF00FF";
			$this->color[0][13] = imagecolorallocate($this->img, 153, 0, 153);
			$this->color[1][13] = imagecolorallocate($this->img, 102, 0, 102);
			$this->htmlColor[13] = "#990099";
			$this->color[0][19] = imagecolorallocate($this->img, 255, 51, 255);
			$this->color[1][19] = imagecolorallocate($this->img, 204, 51, 204);
			$this->htmlColor[19] = "#FF33FF";
			$this->color[0][25] = imagecolorallocate($this->img, 153, 51, 153);
			$this->color[1][25] = imagecolorallocate($this->img, 102, 51, 102);
			$this->htmlColor[25] = "#993399";
			$this->color[0][31] = imagecolorallocate($this->img, 255, 102, 255);
			$this->color[1][31] = imagecolorallocate($this->img, 204, 102, 204);
			$this->htmlColor[31] = "#FF66FF";
			$this->color[0][36] = imagecolorallocate($this->img, 255, 153, 255);
			$this->color[1][36] = imagecolorallocate($this->img, 204, 153, 255);
			$this->htmlColor[36] = "#FF99FF";		
						
			imagefill($this->img, 0, 0, $this->bianco);
			if (!isset($spessore) || !is_int($spessore) || $spessore=="") $spessore = 20;
			$this->spessore = $spessore;
			$this->leggenda = true;
			$this->percorso = "./";
			$this->nome = "pieGraph.jpg";
			$this->titolo = $titolo;
		}
	}
	
	function disableLeggend() {
		$this->leggenda = false;
	}
	
	function enableLeggend() {
		$this->leggenda = true;
	}	
	
	function setPercorso($path) {
		$this->percorso = $path;
	}
	
	function getPercorso() {
		return $this->percorso;
	}
	
	function setNome($name) {
		$this->nome = $name . "jpg";
	} 
	
	function getNome() {
		return $this->nome;
	}
	
	function getGlobalName() {
		return $this->path . $this->nome;
	}
	
	function setTitolo($title) {
		$this->titolo = $title;
	}
	
	function getTitolo() {
		return $this->titolo;
	}
	
	function stampa() {
		$totale = 0;
		for ($i=0; $i<sizeof($this->valori); $i++) {
			$totale += $this->valori[$i];
		}

		// disegno laparte scura della pila
		for (($j = ($this->size/2) + $this->spessore); $j > ($this->size/2); $j--) {
			$i = 0;
			$start = 0;
			$end[0] = 0;
			for ($y=0; $y<sizeof($this->valori); $y++) {
				$gradi[$i] = ($this->valori[$y]/$totale)*360; //gradi di ogni intervento
				if ($i > 0) $end[$i] = $end[$i-1] + $gradi[$i]; 
				else $end[$i] = $gradi[$i];
				imagefilledarc($this->img, ($this->size/2), $j, $this->size, ($this->size/2), $start, $end[$i], $this->color[1][$i], IMG_ARC_PIE);
				$start = $end[$i];
				$i++;
			}	
		}
		
		// disegno la parte chiara della pila
		for ($i=0; $i<sizeof($this->valori); $i++) {
			imagefilledarc($this->img, ($this->size/2), ($this->size/2), $this->size, ($this->size/2), $start, $end[$i], $this->color[0][$i], IMG_ARC_PIE); 
			$start = $end[$i];
		}			
		imagejpeg($this->img, $this->getGlobalName());
		
		$messaggio = "<table style=\"border: 1px solid #000000\" cellspacing=\"0\" cellpadding=\"4\"><tr><td colspan=\"2\" bgcolor=\"#CCCCCC\" style=\"border-bottom: 1px solid #000000\"><h3 style=\"font-family: Arial, Verdana, Helvetica; padding: 4;\">$this->titolo</td></h3></tr>\n"
					."<tr><td valign=\"top\" style=\"padding: 4;\"><img src=\"". $this->getGlobalName() . "\"></td>";
	
		if($this->leggenda==false) {
			$messaggio .= "<td></td></tr></table>"; 
		}	
		else {
			$messaggio .= "<td valign=\"top\" style=\"padding :4;\"><table cellspacing=\"0\" cellpadding=\"2\">\n";
			$messaggio .= "<tr><td colspan=\"4\"style=\"border: 1px solid #000000; font-family: Arial, Verdana, Helvetica; padding: 2;\" bgcolor=\"#CCCCCC\">Leggenda</td></tr>\n";
			for ($y=0; $y<sizeof($this->valori); $y++) {
				$percentuali[$y] = number_format((($this->valori[$y]/$totale) * 100), 2);		
			}
			for ($y=0; $y<sizeof($this->valori); $y++) {
				$messaggio .= "<tr><td bgcolor=\"" . $this->htmlColor[$y] . "\" style=\"border-bottom: 1px solid #000000; border-left: 1px solid #000000; border-right: 1px solid #000000;\">&nbsp;</td><td style=\"border-bottom: 1px solid #000000; border-right: 1px solid #000000; font-family: Arial, Verdana, Helvetica; padding: 2;\">" . $this->nomi[$y] . "</td><td align=\"right\" style=\"border-bottom: 1px solid #000000; border-right: 1px solid #000000; font-family: Arial, Verdana, Helvetica; padding: 2;\">" . $this->valori[$y] . "</td><td align=\"right\" style=\"border-bottom: 1px solid #000000; border-right: 1px solid #000000; font-family: Arial, Verdana, Helvetica; padding: 2;\">$percentuali[$y] %</td></tr>\n";
			}
			$messaggio .= "</table></td></tr></table>";				
		}		
		return $messaggio;		
	}
}
?>