<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd ">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="it" lang="it">
	<head>
		<title>CssSelector : utilit di selezione CSS</title>
		<link rel="Chapter" title="Accessibilit" type="text/html" href="/accessibilit.php"/>
		<link href="/main.css" rel="stylesheet" type="text/css" />
		<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	</head>
	<body>
	<? include("../../header.html"); ?>
	<div id="content">

		<h1>CssSelector</h1>
		
		<p>CssSelector  un modulo <acronym>php</acronym> che,
		innestato opportunamente in una pagina web, permette all'utente
		di selezionare uno stile di visualizzazione della pagina stessa.
		Gli stili di visualizzazione sono dei <strong>fogli di stile</strong>
		messi a disposizione dal <span lang="en">web master</span>.
		</p>
		
		<h2>Esempio di utilizzo</h2>
		<p>Un esempio del funzionamento di CssSelector  disponibile
		in <a href="prova1.html">questa</a> pagina di esempio.
		In questo caso sono state messi a disposizione tre stili differenti
		: rosso, verde e blu. Tali stili differiscono solo per il colore di
		sfondo della pagina. Per poter utilizzare cssSelector 
		<strong> necessario abilitare i <code>cookies</code></strong>.
		Al primo accesso al sito, l'utente si trova di fronte la form
		di selezione dello stile. Lo stile applicato alla pagina in questo
		momento  quello indicato come predefinito dal 
		<span lang="en">web master</span>. Una volta effettuata
		la selezione, l'utente ad ogni accesso successivo vedr il sito
		con lo stile che ha scelto. Cliccando sul collegamento
		<code>cambia visualizzazione</code> gli sar possibile
		in ogni momento selezionare un diverso stile di visualizzazione.
		</p>
		
		<h2>Come installare cssSelector nelle proprie pagine web</h2>
		
		<p>CssSelector  uno strumento scritto in php, per cui 
		necessario avere a disposizione php nel proprio sito. Inoltre
		tutte le pagine che utilizzano cssSelector devono avere 
		estensione <code>.php</code>.</p>
		
		<h3>Fase 1: scaricare il modulo</h3>

		<p>E' necessario innanzitutto scaricare il modulo ed installarlo
		sul proprio sito. Per scaricare il sorgente cliccate
		<a href="cssSelector.zip">qui</a>. Il modulo viene
		fornito in un <span lang="en">file</span> compresso,
		 necessario quindi decomprimerlo e caricarlo poi
		nel proprio spazio web.</p>
		
		<h3>Fase 2: includere cssSelector nelle vostre pagine</h3>
		
		<p>Per rendere le funzionalit di cssSelector disponibili in
		una pagina  necessario includere il modulo appena caricato
		in tale pagina. Tale operazione viene effettuata mediante
		il comando <code>include</code> del linguaggio php.
		Per chiarezza  opportuno che questo genere di comandi
		si trovi all'inizio della pagina.
		</p>
		
		<code>
		<pre>
			&lt;? include("cssSelector.php"); ?&gt;
		</pre>
		</code>
		
		<p>Il parametro dell'include contiene il percorso del 
		modulo cssSelector. Se ad esempio il <span lang="en">file</span>
		si trova nella <span lang="en">directory</span> radice del
		vostro sito, il comando <code>include</code> andr specificato
		nel seguente modo:
		<code>
		<pre>
			&lt;? include("cssSelector.php"); ?&gt;
		</pre>
		</code>
		</p>
		
		<h3>Fase 3: istanziare cssSelector e dichiarare lo stile predefinito</h3>
		
		<p>CssSelector in realt  una <em>classe</em>. Per poterlo
		utilizzare  necessario creare una variabile che istanzi di questa classe.
		Nel costruttore va specificato lo stile predefinito.
		La sintassi del costruttore  la seguente :
		
		<code>
		<pre>
			CssSelector(<var>descrizione</var>, 
				<var>media</var>, 
				<var>file</var>)
		</pre>
		</code>
		<p><var>descrizione</var>  la descrizione testuale che
		compare nella maschera di selezione, <var>media</var>
		 il tipo di media per al quale il <code>css</code> si
		riferisce(vedi i vari 
		<a href="http://www.w3.org/TR/CSS2/media.html" 
		title="tipi di media nei css, sito del w3c">tipi di media</a>),
		ed infine <var>file</var>  il percorso per il foglio di stile.</p>
		
		<p>Supponiamo ad esempio di voler creare una istanza di
		cssSelector <var>$c</var> che abbia come stile
		predefinito lo stile <code>rosso</code>, come
		foglio di stile <code>ross.css</code>, e che tale
		foglio di stile riguardi le periferiche tipo schermo(<code>screen</code>).
		Allora dovremmo inserire il seguente codice nella pagina :
		
		<code>
		<pre>
			<var>$c</var> = new CssSelector(<var>"rosso"</var>, 
				<var>"screen"</var>, 
				<var>"rosso.css"</var>);
		</pre>
		</code>
		</p>
		
		<p>Attenzione, con questa istruzione viene letto il
		<code>cookie</code> di gestione dello stile. Per una
		limitazione dei <code>cookies</code>  necessario che
		questa istruzione sia eseguita <strong>prima di
		ogni altro output</strong>. Di solito viene posta subito
		dopo gli include.</p>
		
		<h3>Fase 4 : specificare gli altri stili</h3>
		<p>Per aggiungere altri stili  necessario utilizzare il
		metodo <code>add</code>. La sintassi di tale
		metodo  identica a quella del costruttore. Supponiamo di
		aggiungere lo stile <var>verde</var>.</p>

		<code>
		<pre>
			<var>$c</var>->add (<var>"verde"</var>, 
				<var>"screen"</var>, 
				<var>"verde.css"</var>);
		</pre>
		</code>

		<h3>Fase 5: generare i marcatori per i fogli di stile</h3>
		
		<p>A questo punto dobbiamo aggiungere il codice
		nella pagina per generare il collegamento al foglio di
		stile. Nelle pagine <span lang="en">web</span> il
		foglio di stile viene specificato con il marcatore
		<code>link</code>. Il metodo 
		<code>insertCss</code> genera il codice per collegare
		il foglio di stile selezionato, e specificare gli altri come
		fogli di stile alternativi. Dato che le dichiarazioni per gli stili
		vanno inserite nell'<code>head</code>, l'istruzione
		
		<code>
		<pre>
			&lt;? $c->insertCss(); ?&gt; 
		</pre>
		</code>
		
		deve essere inserita all'interno del marcatore <code>head</code>
		al posto delle dichiarazioni di stile.</p>
		
		<h3>Fase 6: maschera di selezione stile.</h3>
		<p>A questo punto non resta che inserire il collegamento
		<code>cambia visualizzazione</code> e la form di 
		selezione. Entrambe queste cose vengono gestite dal
		metodo <code>showList()</code>. Questo metodo,
		inserito nel corpo del testo, visualizza il collegamento
		<code>cambia visualizzazione</code> o la
		maschera di selezione, se l'utente intende selezionare
		lo stile o meno.</p>
		
		<p>Sia al collegamento che alla maschera viene
		assegnato l'<code>id</code> <var>cssSelector</var>.
		Questo per facilitare la personalizzazione dell'<em>aspetto</em>
		di questi due elementi.</p>
		
		<h2>Codice dell'esempio</h2>
		<div class="sample">
		<code>
		<pre>
&lt;? include("cssSelector.php");
$c=new CssSelector("rosso","screen","rosso.css");
$c-&gt;add("verde","screen","verde.css");
$c-&gt;add("blue","screen","blu.css");
?&gt;
&lt;html&gt;
    &lt;head&gt;
        &lt;title&gt;CssSelector: Paginadi esempio 1&lt;/title&gt;
        &lt;? echo $c-&gt;insertCss(); ?&gt;
    &lt;/head&gt;
    &lt;body&gt;
        &lt;h1&gt;Esempio CssSelector : pagina 1&lt;/h1&gt;
        &lt;? echo $c-&gt;showList(); ?&gt;
        &lt;a href="prova2.php"&gt;vai alla pagina 2&lt;/a&gt;
    &lt;/body&gt;
&lt;/html&gt;
		</pre>
		</code>
		</div>
		
		<h2>Ottimizzazioni</h2>
		<p>Dato che gli stili a disposizione sono di solito gli stessi per
		tutto il sito,  possibile creare un <span lang="en">file</span>
		di configurazione unico che
		si occupi di effettuare le impostazioni iniziali, e poi includere
		questo <span lang="en">file</span> in  tutte le pagine.
		Questa ottimizzazione permette di gestire in maniera pi
		semplice gli stili messi a disposizione.</p>
		
		<h3><span lang="en">File</span> di configurazione : cssConf.php</h3>

		<div class="sample">
		<code>
		<pre>
&lt;? include("cssSelector.php");
$c=new CssSelector("rosso","screen","rosso.css");
$c-&gt;add("verde","screen","verde.css");
$c-&gt;add("blue","screen","blu.css");
?&gt;
		</pre>
		</code>
		</div>

		<h3>Esempio modificato : prova1.php</h3>
		<div class="sample">
		<code>
		<pre>
&lt;html&gt;
    &lt;head&gt;
        &lt;title&gt;CssSelector: Paginadi esempio 1&lt;/title&gt;
        &lt;? echo $c-&gt;insertCss(); ?&gt;
    &lt;/head&gt;
    &lt;body&gt;
        &lt;h1&gt;Esempio CssSelector : pagina 1&lt;/h1&gt;
        &lt;? echo $c-&gt;showList(); ?&gt;
        &lt;a href="prova2.php"&gt;vai alla pagina 2&lt;/a&gt;
    &lt;/body&gt;
&lt;/html&gt;
		</pre>
		</code>
		</div>
	<?include("../../footer.html"); ?>
	</div>
	</body>
</html>

