<?

// a simple script to create Google Sitemaps
// contact RJ Softwares at info@rjsoftwares.com

// this script is free for modifications and changes. just two requests:
// 1. E-Mail us at info@rjsoftwares.com if you are using this. We will add a link to your site on ours.
// 2. Link to our site from yours.
// hope this is helpful!


// list the directories you do not want to include
// in the sitemap. Relative to the browser path
// for example, if you are on the domain www.yourdomain.com
// and you do not want to list any files in www.yourdomain.com/images/
// then enter /images in the array below

$ignoreArray = array ('/css', '/images');
$ignoreExtensions = array ('.gif', '.jpg', '.js');





// no need to change anything below
$sitemap = new RJGoogleSiteMap(".", $ignoreArray, $ignoreExtensions);

class RJGoogleSiteMap {

	// this is the initializing function
	// defaults to current directory

	// some variables for general use
	var $browserPath;
	var $primaryFolder;
	var $ignoreArray;
	var $ignoreExtensions;

	function RJGoogleSiteMap($folder = ".", $ignoreArray = "", $ignoreExtensions = "") {

		$this->primaryFolder = $folder;
		$this->ignoreArray = $ignoreArray;
		$this->ignoreExtensions = $ignoreExtensions;

		// set the browser path
		$this->getBrowserPath();

		// generate the header
		echo $this->createXMLHeader();

		// start processing the specified folder
		$folders[] = $folder;

		while ($current_folder = array_pop($folders)) {

			$folder = opendir($current_folder);

			// open directory and start reading all files
			while ($file = readdir($folder)) {

				// skip if this is the current directory or, the parent
				if ($file == "." || $file == "..") {
					continue;
				}

				$filename = $current_folder.DIRECTORY_SEPARATOR.$file;

				// check for ignore lists
				$flag = 0;
				$toremove = "";

				$tmpfile = $this->getURL($filename);

				if(is_array($this->ignoreArray))
				{
					$this->tmpArray = array();

					foreach ($this->ignoreArray as $item) {
						if ($tmpfile == $this->browserPath.$item)
						{
							$flag = 1;
						}
						else
							array_push($this->tmpArray, $item);
					}

					$this->ignoreArray = $this->tmpArray;
				}

				if(is_array($this->ignoreExtensions))
				{
					foreach($this->ignoreExtensions as $item)
					{
						$length = strlen($item) * -1;

						if(strtolower(substr($filename, $length)) == strtolower($item))
						{
							$flag = 1;
							break;
						}
					}
				}

				// check if the current file is a directory or not
				if ($flag == 0) {
					if (is_dir($filename)) {
						// add to array for further processing
						array_push($folders, $filename);
						continue;
					} else
						$this->makeXML($filename);
				}
			}

			closedir($folder);
		}

		// generate the footer
		echo $this->createXMLFooter();
	}

	function makeXML($file) {

		// now we do the actual processing here
		// and generate the xml for this file

		// generate last modification date/time
		$file_info = stat($file);
		$lastmod = $file_info[9];
		$lastmod = date('Y-m-d\TH:i:s', $lastmod);

		// get the time difference
		$timediff = date('O', $lastmod);
		$timediff = substr($timediff, 0, 3) . ":" . substr($timediff, 3, 2);
		$lastmod .= $timediff;

		$file = $this->getURL($file);

		$str = "<url>";
		$str .= "<loc>".$file."</loc>";
		$str .= "<lastmod>$lastmod</lastmod>";
		$str .= "<priority>1</priority>";
		$str .= "<changefreq>weekly</changefreq>";
		$str .= "</url>";
		echo $str;
	}

	function getBrowserPath() {
		$scriptlocation = split('/', $_SERVER["REQUEST_URI"]);
		array_pop($scriptlocation);
		$this->browserPath = join('/', $scriptlocation);
		$this->browserPath = "http://".$_SERVER["HTTP_HOST"].$this->browserPath;
	}

	function createXMLHeader() {

		header("Content-type: text/xml");
		$str = '<?xml version="1.0" encoding="UTF-8"?>';
		$str .= '<urlset xmlns="http://www.google.com/schemas/sitemap/0.84">';
		return $str;
	}

	function getURL($filename) {

		// now make sure the primary folder is removed from the path
		// and ensure this is done just once

		$pos = strpos($filename, $this->primaryFolder);
		if (!($pos === false))
			$filename = substr_replace($filename, "", $pos, strlen($this->primaryFolder));

		return $this->browserPath.$filename;
	}
	function createXMLFooter() {
		return "</urlset>";
	}
}
?>