<?php 

class BubbleChart
{
var $im;
var $bubbles;
var $temp ;


/***  Draw Matrix   ***/
function DrawMatrix($facx,$facy){
$this->im = @imagecreate (600, 600)
    or die ("Cannot Initialize new GD image stream");
$background_color = imagecolorallocate ($this->im, 255, 255, 255);
$text_color = imagecolorallocate ($this->im, 233, 14, 91);
$color1 = imagecolorallocate ($this->im, 0, 0, 0);
$color2 = imagecolorallocate ($this->im, 0, 0, 255);
$color3 = imagecolorallocate ($this->im, 0, 255, 255);
$color4 = imagecolorallocate ($this->im, 255, 0, 255);
$color5 = imagecolorallocate ($this->im, 165, 42, 42);
$color6 = imagecolorallocate ($this->im, 0, 128, 0);
$color7 = imagecolorallocate ($this->im, 255, 165, 0);
$color8 = imagecolorallocate ($this->im, 255, 192, 20);
$color9 = imagecolorallocate ($this->im, 255, 0, 0);
$color10 = imagecolorallocate ($this->im, 255, 255, 0);

imagerectangle ($this->im, 30, 30, 480, 480,  $text_color);
imagedashedline ($this->im, 180, 30, 180, 480,  $text_color);
imagedashedline ($this->im, 330, 30, 330, 480,  $text_color);

imagedashedline ($this->im, 30, 180, 480, 180,  $text_color);
imagedashedline ($this->im, 30, 330, 480, 330,  $text_color);

imagestringup ( $this->im, 5, 0, 300, $facy,$text_color );
imagestringup ( $this->im, 5, 15, 105, "H",$text_color );
imagestringup ( $this->im, 5, 15, 180, "MH",$text_color );
imagestringup ( $this->im, 5, 15, 255, "M",$text_color );
imagestringup ( $this->im, 5, 15, 330, "ML",$text_color );
imagestringup ( $this->im, 5, 15, 405, "L",$text_color );

imagestring ( $this->im, 5, 105, 485, "L",$text_color );
imagestring ( $this->im, 5, 180, 485, "ML",$text_color );
imagestring ( $this->im, 5, 255, 485, "M",$text_color );
imagestring ( $this->im, 5, 330, 485, "MH",$text_color );
imagestring ( $this->im, 5, 405, 485, "H",$text_color );



imagestring ( $this->im, 5, 180, 500, $facx,$text_color );



}

/* Add a bubble */
function AddBubble($name, $x,$y,$qr,$color){

switch ($x) {
    case 1:
        $ics=105;
        break;
    case 2:
        $ics=180;
        break;
    case 3:
        $ics=255;
        break;
    case 4:
        $ics=330;
        break;
   case 5:
        $ics=405;
        break;
  default:
    echo $name . " Error. X value must be between 1 and 5 ";
return;
}

switch ($y) {
    case 1:
        $ipsilon=405;
        break;
    case 2:
        $ipsilon=330;
        break;
    case 3:
        $ipsilon=255;
        break;
    case 4:
        $ipsilon=180;
        break;
   case 5:
        $ipsilon=105;
        break;
  default:
    echo $name . " Error. Y value must be between 1 and 5 ";
return;
}

if (is_int($qr)==FALSE)  {

echo $name . " Error. The third quality (relative) must be an Integer";
return;
}

if (is_int($color)==FALSE or $color < 1 or $color > 11){

echo $name . " Error. Color value must be an Integer between 1 and 11";
return;
}



$temp["x"]=$ics;
$temp["y"]=$ipsilon;
$temp["s"]=$qr;
$temp["e"]=$qr;
$temp["color"]=$color;          
$this->bubbles[$name]=$temp;
$d=reset($temp);
}

function CheckQR(){

$d=reset($this->bubbles);
$totQR=0;
while (list($key0,$array0 )=each($this->bubbles)){

$totQR=$totQR + $array0["e"];

$d=reset($array0);

}

return $totQR;

}

function MakeBubble($nameIMG){


if (substr($nameIMG,-5)!= ".jpeg") {
echo "Filename must be a .jpeg extension. ";
return;
}

if (file_exists($nameIMG)) {
unlink($nameIMG);
}

$totQR=$this->CheckQR();
if ($totQR <1 or $totQR > 100){

echo "Error: sum of the values for third quality of all subjects cannot be negative or greater of 100. ";
return;
}

$d=reset($this->bubbles);
while (list($key1,$array1 )=each($this->bubbles)){

imagearc( $this->im, $array1["x"], $array1["y"], $array1["s"], $array1["e"], 0, 360, $array1["color"]);
imagestring ( $this->im, 3, $array1["x"], $array1["y"], $key1,$array1["color"] );


$d=reset($array1);

}
imagejpeg($this->im, $nameIMG); 
}

}
?>