<?php
// DEVELOPED BY RENOWNEDMEDIA.COM
$image_file = "bar.png";
$value = $_GET['value'] + 0; # we use values 0 to 100
if ($value < 0) {
	$value = 0;
} else if ($value > 100) {
	$value = 100;
}
if ((isset($_GET['value'])) && (isset($_GET['max'])) && ($_GET['max'] > 0)) {
	$value = ($_GET['value'] / $_GET['max'] + 0) * 100;
}
if (isset($_GET['info'])) {
	$imx = imagecreatefrompng ($image_file);
	$image_height = imagesy($imx) + 14;
	$image_width = imagesx($imx);
	
	$im = imagecreatetruecolor($image_width, $image_height);
	imagesavealpha($im, true);
	$trans_colour = imagecolorallocatealpha($im, 0, 0, 0, 127);
    imagefill($im, 0, 0, $trans_colour);
	
	imagecopy($im, $imx, 0, 0, 0, 0, $image_width, imagesy($imx));
	imagedestroy($imx);
	
	$font_family = "calibri.ttf";
	$font_size = 10;
	$black = imagecolorallocate($im, 0, 0, 0);
	if (isset($_GET['max']))
		$string = $_GET['value'] . "/" . ($_GET['max'] + 0) . " (" . round($value) . "%)";
	else
		$string = $value . "%";
	$box = @imageTTFBbox($font_size,0,$font_family,$string);
	$b_width = abs($box[4] - $box[0]);
	$b_height = abs($box[5] - $box[1]);
	imagettftext($im, $font_size, 0, $image_width/2-$b_width/2, 18, $black, $font_family, $string);
} else {
	$im = imagecreatefrompng ($image_file); # we load the background file (faster than drawing it)
}
putenv('GDFONTPATH=' . realpath('./'));
header ("Content-type: image/png"); # we are making a PNG but you can change to a GIF or JPEG


$bar_distance = 14;	# the distance from the start of the first bar to the start of the second bar
$bar_width = 8;		# the width of a bar rectangle
$bar_height = 3;	# the height of a bar
$bar_y = 2;			# how far a bar is from the top of the image
$bar_x = 2;			# how far the offset is on our first bar
$colors = array(	# our 10 colors from left to right in RGB decimal pairs
			array(77, 180, 1),
			array(115, 180, 1),
			array(125, 196, 1),
			array(147, 210, 0),
			array(178, 226, 12),
			array(228, 193, 0),
			array(255, 180, 0),
			array(255, 138, 0),
			array(238, 96, 2),
			array(213, 40, 0)
		);
$value /= 10;		# divide the value by 10 and round the result
$value = round($value);
for ($i = 0; $i < $value; $i++) {
	$color = imagecolorallocate($im, $colors[$i][0], $colors[$i][1], $colors[$i][2]); # only allocate color if we're using it
	imagefilledrectangle($im, $bar_distance * $i + $bar_x, $bar_y, $bar_distance * $i + $bar_x + $bar_width - 1, $bar_y + $bar_height - 1, $color);	# draw the bars
}
imagepng($im);		# output the image