<?php
session_start();
/*
|---------------------------------------------------|
|				  LICENSE BLOCK START			    |
|---------------------------------------------------|
|			  The Uploader 2.0 - Stable			    |
|---------------------------------------------------|
|													|
| Creators:          Andy94 & Ste_95				|
|  Company:				MegaLab.it					|
|     Site:           www.MegaLab.it                |
|  License:			 Creative Commons				|
| Released:          Semptember, 2009				|
|													|
|---------------------------------------------------|
|				  LICENSE BLOCK END				    |
|---------------------------------------------------|
*/

//Include configuration file, set a variable used for error managing and initialize e-mail text
include("../config.inc.php");
include("../DBHandler.php");
include("../api/notifications.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<title>The Uploader 2.0 - Upload</title>
	<!--FAVICON SECTION-->
	<link rel="SHORTCUT ICON" href="<?php echo $main['server_name'] ?>favicon.ico" />
	<!--Metagags section-->
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta name="language" content="Italian" />
	<meta name="author" content="Andy94 &amp; Ste_95" />
	<meta name="copyright" content="Andy94 &amp; Ste_95 ..::.. MegaLab.it Staff" />
	<meta http-equiv="X-UA-Compatible" content="IE=7" />
	<!--Styles importing-->
	<style type="text/css">
		@import url("<?php echo $main['server_name'] ?>styles/main.css");
		@import url("<?php echo $main['server_name'] ?>styles/index.css");
		@import url("<?php echo $main['server_name'] ?>styles/admin.css");
	</style>
	<!--[if lte IE 6]>
	<link href="iefixes.css" rel="stylesheet" type="text/css" />
	<![endif]-->
	<!--AJAX importing-->
	<script type="text/javascript" src="<?php echo $main['server_name'] ?>ajax/mootools-core.js"></script>
	<script type="text/javascript" src="<?php echo $main['server_name'] ?>ajax/mootools-more.js"></script>
</head>
<body id="js">
	<div>
<?php
$nofile=0;
$max_file_slots=$main['max_file_slots'];
$max=$main['max_file_slots'];
$noselected=0;
$files = "";
$messaggio='Qualcuno ha caricato un file nello spazio web, di seguito ne trovi i dettagli:<br><br>
IP Uploader: ' . $_SERVER['REMOTE_ADDR'] . '<br>
Sistema operativo e browser: ' . $_SERVER['HTTP_USER_AGENT'] . '<br><br>';

//Check if upload folder exists (create if not)
if(!is_dir($main['upload_directory'])) {
	mkdir($main['upload_directory']);
}

//Check inserted CAPTCHA
if($main['captcha_upload'] == 1) {
	if($_SESSION['segno'] == "+") {
		$Result = ($_SESSION['primonumero'] + $_SESSION['secondonumero']);
	} else if ($_SESSION['segno'] == "-") {
		$Result = ($_SESSION['primonumero'] - $_SESSION['secondonumero']);
	}
	if($_POST['result'] == '') {
		echo '<h3 class="uploadtext">Non &agrave; stato inserito nessun risultato.</h3>';
		echo '<p class="buttoncontainer"><input type="button" value="Chiudi finestra" class="deletebutton" onclick="window.close();" /></p>';
	} else if(!is_numeric($_POST['result'])){
		echo '<h3 class="uploadtext">Il risultato deve essere necessariamente numerico.</h3>';
		echo '<p class="buttoncontainer"><input type="button" value="Chiudi finestra" class="deletebutton" onclick="window.close();" /></p>';
	} else if($Result == $_POST['result']){
		$captcha="ok";
	} else {
		echo '<h3 class="uploadtext">Il captcha immesso &agrave; errato.</h3>';
		echo '<p class="buttoncontainer"><input type="button" value="Chiudi finestra" class="deletebutton" onclick="window.close();" /></p>';
		if($main['uploads_log'] == true) {
			mainlog("UPFAIL", "Captcha errato", "Il Captcha immesso &agrave; errato. File " . $_GET['filename'] . ".", $_SERVER['REMOTE_ADDR']);
		}
	}
}

//If captcha is ok, start upload process
if($captcha=="ok" OR $main['captcha_upload'] == 0) {
	while ($main['max_file_slots'] > 0) {
	//Check if there is at least one or more file to be uploaded
	if($_FILES['upfile_'.$main['max_file_slots']]['name'] == '') {
		if($noselected == ($max-1)) {
			echo '<h3 class="uploadtext">Non sono stati selezionati file.</h3>';
			break;
		} else {
			--$max_file_slots;
			--$main['max_file_slots'];
			++$noselected;
			++$nofile;
			continue;
		}
	}
	//Check if file name is index.php
		if($_FILES['upfile_'.$main['max_file_slots']]['name'] == 'index.php') {
			echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Per ragioni di sicurezza, &agrave; vietato il caricamento di file index.php.</h3></p>
			</fieldset>';
			if($main['uploads_log'] == 1) {
				mainlog("UPFAIL", "Caricamento index.php", "Vi &agrave; stato un tentativo di upload di file index.php. L\'upload &agrave; stato automaticamente negato per ragioni di sicurezza.", $_SERVER['REMOTE_ADDR']);
			}
			--$main['max_file_slots'];
			++$nofile;
			continue;
		}
	//Check if file is bigger than the max_file_size directive in the php.ini
		if($_FILES['upfile_'.$main['max_file_slots']]['error'] == '2') {
			echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Il file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'].' eccede la dimensione massima consentita dal server.</h3></p>
			</fieldset>';
			if($main['uploads_log'] == 1) {
				mainlog("UPFAIL", "File troppo grande", "Le limitazioni del server hanno impedito l\'upload del file \"".$_FILES['upfile_'.$main['max_file_slots']]['name']."\".", $_SERVER['REMOTE_ADDR']);
			}
			--$main['max_file_slots'];
			++$nofile;
			continue;
		}
	//Check if file is an empty file
		if($_FILES['upfile_'.$main['max_file_slots']]['size'] == '0') {
			echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Il file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'].' &egrave; vuoto e non pu&ograve; essere caricato.</h3></p>
			</fieldset>';
			if($main['uploads_log'] == 1) {
				mainlog("UPFAIL", "Caricamento file vuoto", "Vi &agrave; stato un tentativo di upload di file vuoto. L\'upload &agrave; stato bloccato automaticamente.", $_SERVER['REMOTE_ADDR']);
			}
			--$main['max_file_slots'];
			++$nofile;
			continue;
		}
	//Check if there isn't a file with the same name yet (it may slow) and if so, don't overwrite it
		if($main['check_duplicates'] == 1 AND $main['files_overwrite'] == 0) {
			$open=opendir($main['upload_directory']);	
			while($file = readdir($open)) {
				if(str_replace(" ", "_", $_FILES['upfile_'.$main['max_file_slots']]['name']) == $file) {
					echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Il file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'] . ' non pu essere caricato in quanto esiste gi un file con lo stesso nome.</h3></p>
			</fieldset>';
					--$main['max_file_slots'];
					++$nofile;
					unset($AlreadyExists);
					continue(2);
				}
			}
		}
	//Check if file extension is allowed
		$ext=strtolower(substr(strrchr($_FILES['upfile_'.$main['max_file_slots']]['name'], "."), 1));
		if($main['check_ext'] == true) {
			if(!in_array($ext, $main['allowed_ext'])) {
				echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Il file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'] . ' ha un\'estensione non consentita.</h3></p>
			</fieldset>';
				if($main['uploads_log'] == 1) {
					mainlog("UPFAIL", "Estensione non valida", "Il file " . $_FILES['upfile_'.$main['max_file_slots']]['name'] . " non ha un\'estestensione valida.", $_SERVER['REMOTE_ADDR']);
				}
				if($main['show_in_upload'] == 1) {
					if(!isset($n)) {
						echo '<p class="pupload">Le estensioni valide sono le seguenti:</p>';	
						foreach($main['allowed_ext'] as $temp) {
							if($n!=0) {
								echo ' | ';
							}
							echo $temp;
							++$n;
						}
					}
				}
				--$main['max_file_slots'];
				++$nofile;
				continue;
				}
			}
	//Check if file name exceed min number of chars
		if($main['check_file_lenght'] == true) {
			$long=strlen($_FILES['upfile_'.$main['max_file_slots']]['name']);
			if($long < $main['min_file_lenght']) {
				echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Il nome del file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'] . ' &agrave; inferiore al limite di caratteri settato.</h3></p>
			</fieldset>';
				if($main['uploads_log'] == 1) {
					mainlog("UPFAIL", "Nome file troppo corto", "Il file " . $_FILES['upfile_'.$main['max_file_slots']]['name'] . " ha un nome troppo corto, di " . $long . " caratteri.", $_SERVER['REMOTE_ADDR']);
				}
				--$main['max_file_slots'];
				++$nofile;
				continue;
			}
		//Check if file name exceed max number of chars
			if($long > $main['max_file_lenght']) {
				if($main['cut_file_name'] == true) {
					$_FILES['upfile_'.$main['max_file_slots']]["name"]=substr($_FILES['upfile_'.$main['max_file_slots']]['name'], 0, $main['max_file_lenght']-3).'.'.$ext;
				} else {
					echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Il nome del file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'] . ' eccede il numero massimo di caratteri.</h3></p>
			</fieldset>';
					if($main['uploads_log'] == 1) {
						mainlog("UPFAIL", "Nome file troppo lungo", "Il file " . $_FILES['upfile_'.$main['max_file_slots']]['name'] . " ha un nome troppo lungo, di " . $long . " caratteri.", $_SERVER['REMOTE_ADDR']);
					}
					--$main['max_file_slots'];
					++$nofile;
					continue;
				}
			}
		}
	//Check if file size is not exceeding the min size
		if($main['check_file_size'] == true) {
			if($_FILES['upfile_'.$main['max_file_slots']]['size'] < $main['min_file_size']) {
				echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Il file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'] . ' ha una dimensione inferiore a quella minima consentita.</h3></p>
			</fieldset>';
				if($main['uploads_log'] == 1) {
					mainlog("UPFAIL", "File troppo piccolo", "Il file " . $_FILES['upfile_'.$main['max_file_slots']]['name'] . " ha una dimensione inferiore a quella minima, di " . $_FILES['upfile_'.$main['max_file_slots']]['size'] . " byte.", $_SERVER['REMOTE_ADDR']);
				}
				--$main['max_file_slots'];
				++$nofile;
				continue;
			}
		//Check if file size is not exceeding the max one
			if($_FILES['upfile_'.$main['max_file_slots']]['size'] > $main['max_file_size']) {
				echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Il file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'] . ' eccede la dimensione massima.</h3></p>
			</fieldset>';
				if($main['uploads_log'] == 1) {
					mainlog("UPFAIL", "File troppo grande", "Il file " . $_FILES['upfile_'.$main['max_file_slots']]['name'] . " ha una dimensione superiore a quella massima, di " . $_FILES['upfile_'.$main['max_file_slots']]['size'] . " byte.", $_SERVER['REMOTE_ADDR']);
				}
				--$main['max_file_slots'];
				++$nofile;
				continue;
			}
		}
	//Rename the file if necessary
		if($main['file_name_keep'] == true) {
			$name=$_FILES['upfile_'.$main['max_file_slots']]["name"];
		} else {
			$name=time()+rand(1, 1000) . '.' . $ext;
		}
	//Replace spaces with underscores
		$name=str_replace(" ", "_", $name);
	//Upload file
		if(is_uploaded_file($_FILES['upfile_'.$main['max_file_slots']]['tmp_name'])) {
			$muovi=move_uploaded_file($_FILES['upfile_'.$main['max_file_slots']]['tmp_name'], $main['upload_directory'].$name);
			if($muovi == false) {
				echo '<fieldset><legend>'.$_FILES['upfile_'.$main['max_file_slots']]['name'].'</legend>
				<p style=\"margin: 0px;\"><h3 class="uploadtext">Si &agrave; verificato un problema nel caricamento del file ' . $_FILES['upfile_'.$main['max_file_slots']]['name'].'</h3></p>
			</fieldset>';
				if($main['uploads_log'] == 1) {
					mainlog("UPFAIL", "Errore caricamento file", "Il file " . $_FILES['upfile_'.$main['max_file_slots']]['name'] . " non pu essere spostato nella cartella di upload.", $_SERVER['REMOTE_ADDR']);
				}
				--$main['max_file_slots'];
				++$nofile;
				continue;
			}
			$success=1;
			$files .= "
			<fieldset><legend>".$_FILES['upfile_'.$main['max_file_slots']]['name']."</legend>
				<p style=\"margin: 0px;\"><b>Link al download:</b> ".$main['server_name']."download.php?filename=".$name."</p>
				<p style=\"margin: 0px;\"><b>Download diretto (si apre in una nuova scheda):</b> <a href=\"javascript:void(0)\" class=\"filelink\" onclick=\"window.opener.location.replace('../download.php?filename=".$name."')\">Download diretto</a></p>
			</fieldset>
			";
		}
	
	//Get unit of size for the file
	if($_FILES['upfile_'.$main['max_file_slots']]['size'] < 1024) {
		$unit=$_FILES['upfile_'.$main['max_file_slots']]['size'].' B';
	} else if ($_FILES['upfile_'.$main['max_file_slots']]['size'] > 1024 AND $_FILES['upfile_'.$main['max_file_slots']]['size'] < 1048576) {
		$unit=round($_FILES['upfile_'.$main['max_file_slots']]['size']/1024, 2).' KB</td>';
	} else {
		$unit=round($_FILES['upfile_'.$main['max_file_slots']]['size']/1024/1024, 2).' MB</td>';
	}
	
	//Insert record in the database
	if($main['uploads_log'] == 1) {
		uploadlog(addslashes($name), $_FILES['upfile_'.$main['max_file_slots']]['size'], $ext, $_SERVER['REMOTE_ADDR']);
		}
	if($main['uploads_log'] == 1) {
		mainlog("UPOK", "File caricato correttamente", "Il file " . addslashes($_FILES['upfile_'.$main['max_file_slots']]['name']) . " &egrave; stato caricato correttamente.", $_SERVER['REMOTE_ADDR']);
	}
	
	//Send admin email if requested
	$SelectId['query'] = "SELECT id FROM ".$main['table_prefix']."_uploads ORDER BY id DESC LIMIT 0,1";
	$SelectId['execute'] = mysql_query($SelectId['query']) or error("Impossibile eseguire la query", mysql_error());
	$SelectId['fetch'] = mysql_fetch_array($SelectId['execute']);
	$messaggio .= 'Download: <a href="' . $main['server_name'] . 'download.php?filename=' .$name . '" target="_blank" title="Scarica il file">' . $name . '</a><br>
	Nome file: ' . $name . '<br>
	Dimensione file: ' . $unit . '<br>
	Estensione File: ' . $ext . '<br>
	Data e Ora Upload: ' . date("d/m/Y H:i:s") . '<br>
	Elimina file: <a href="' . $main['server_name'] . 'admin/ajax/ajaxlinks.php?fileid=' . $SelectId['fetch']['id'] . '" target="_blank" title="Rimuovi il file">Rimuovi file</a><br><br>';
		--$main['max_file_slots'];
		if($main['upload_limit'] != 0) {
			++$_SESSION['upload_limit'];
			$_SESSION['time_upload_limit']=time();
		}
	}
	echo $files;

	if($nofile !== ($max+1) AND $success == 1) {
		if($main['upload_email'] == true) {
			$email_to = "";
			$SendMail['query'] = "SELECT id, mail FROM " . $main['table_prefix'] . "_admins WHERE activated=1";
			$SendMail['execute'] = mysql_query($SendMail['query']) or error("Impossibile eseguire la query", mysql_error());
			$n_recipients=0;
			while ($SendMail['fetch'] = mysql_fetch_array($SendMail['execute'])) {
				if($n_recipients == mysql_num_rows($SendMail['execute'])-1) {
					$email_to .= $SendMail['fetch']['mail'];
				} else {
					$email_to .= $SendMail['fetch']['mail'] . ', ';
					++$n_recipients;
				}
			}
			$messaggio .= 'Grazie per aver scelto The Uploader 2.0.';
			$header = "From: " . $main['email_from'] . "\n";
			$header .= "MIME-Version: 1.0\n";
			$header .= "Content-Type: text/html; charset=\"iso-8859-1\"\n";
			$header .= "Content-Transfer-Encoding: 7bit\n\n";
			mail($email_to, $main['email_subject'], $messaggio, $header);
		}
	}
	if($success == 1){
		echo '<p class="buttoncontainer"><input type="button" value="Chiudi finestra" class="deletebutton" onclick="window.close(); window.opener.reload();" /></p>';
	} else {
		echo '<p class="buttoncontainer"><input type="button" value="Chiudi finestra" class="deletebutton" onclick="window.close();" /></p>';
	}
}
?>
	</div>
</body>
</html>