<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
<head>
  <title>ES Simple Uploader</title>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
  <meta name="generator" content="handmade" />
	<style type="text/css">
	<!--
		body {
			font-family: Arial, Helvetica, sans-serif;
			font-size: 14px;
			background-color: #DDDDDD;
		}
		.cnt {
			text-align: center;
		}
		.cnt_welcome {
			font-size: 16px;
			font-weight: bold;
			text-align: center;
		}
		.cnt_powered {
			font-size: 14px;
			font-weight: bold;
			text-align: center;
		}
		.cnt_small {
			font-size: 12px;
			text-align: center;
			padding-top: 50px;
		}
		.head_line {
			background-color: #BBBBBB;
		}
		.main_table {
			border: solid 1px #9D9992;
			font-size: 13px;
		}
		h4 {
			font-size: 12px;
			color: #DD0000;
			text-align: center;
		}
		.button {
			border: 1px solid #55555;
			font-weight: bold;
		}
-->
</style>
</head>

<body>
<?
include("config.php");

function path_options()
{
 global $upload_dirs;
  $option = "";
  foreach ($upload_dirs as $path => $pinfo)
  {
    $option .= '<option value="'.$path.'">'.$pinfo["name"].'</option>';
  }
 return $option;
}

function check_vals()
{
 global $upload_dirs, $err;
	if (!ini_get("file_uploads")) { $err .= "HTTP file uploading is blocked in php configuration file (php.ini). Please, contact to server administrator."; return 0; }
	$pos = strpos(ini_get("disable_functions"), "move_uploaded_file");
	if ($pos !== false) { $err .= "PHP function move_uploaded_file is blocked in php configuration file (php.ini). Please, contact to server administrator."; return 0; }
  if (!isset($_POST["path"]) || (strlen($_POST["path"]) == 0)) { $err .= "Please fill out path"; return 0; }
  if (!isset($upload_dirs[$_POST["path"]])) { $err .= "Incorrect path"; return 0; }
  if (!isset($_POST["pwd"]) || (strlen($_POST["pwd"]) == 0)) { $err .= "Please fill out password"; return 0; }
  elseif ($_POST["pwd"] != $upload_dirs[$_POST["path"]]["password"]) { $err .= "The upload password is incorrect"; return 0; }
  if (!isset($_FILES["userfile"])) { $err .= "Empty file"; return 0; }
  elseif (!is_uploaded_file($_FILES['userfile']['tmp_name'])) { $err .= "Empty file"; return 0; }
 return 1;
}

$err = ""; $status = 0;
if (isset($_POST["upload"])) {
  if (check_vals()) {
    if (filesize($_FILES["userfile"]["tmp_name"]) > $max_file_size) $err .= "Maximum file size limit: $max_file_size bytes";
    else {
      if (move_uploaded_file($_FILES["userfile"]["tmp_name"], $upload_dirs[$_POST["path"]]["dir"].$_FILES["userfile"]["name"])) {
				$status = 1;
			}
      else $err .= "There are some errors!";
    }
  }
}

if (!$status) {
  if (strlen($err) > 0) echo "<h4>$err</h4>";
}
else {
  echo "<h4>&quot;".$_FILES["userfile"]["name"]."&quot; was successfully uploaded.</h4>";
}
?>
<p class="cnt_welcome">Welcome to ES Simple Uploader v 1.1.</p>
<p class="cnt">&laquo; <a href="http://www.energyscripts.com/Products/product2.html">Back to Product page</a> &laquo;</p>
<p class="cnt">(Select folder, set it's password, then select a file to upload and click "Upload" button).
	<br />Note: 
		Folder: &quot;Images folder&quot;, Password: &quot;images&quot;;
		Folder: &quot;Docs&quot;, Password: &quot;docs&quot;;
		Folder: &quot;Common files&quot;, Password: &quot;common&quot;;
		Maximum file size: <?=$max_file_size/1024?> Kb.</p><br />
<form enctype="multipart/form-data" action="index.php" method="POST">
<input type="hidden" name="MAX_FILE_SIZE" value="<?=$max_file_size?>" />
<table class="main_table" align="center">
  <tr>
    <td colspan="2" class="head_line">&nbsp;</td>
  </tr>
  <tr>
    <td>Folder:</td>
    <td><select name="path"><?=path_options()?></select></td>
  </tr>
  <tr>
    <td>Password:</td>
    <td><input type="password" name="pwd" style="width: 217px;" /></td>
  </tr>
  <tr>
    <td>Choose file:</td>
    <td><input type="file" name="userfile" style="width: 222px;" /></td>
  </tr>
  <tr>
    <td colspan="2" align="right"><input type="submit" name="upload" value="Upload" class="button" /></td>
  </tr>
</table>
</form>
<p class="cnt_powered">Powered by <a href="http://www.energyscripts.com" target="_blank">EnergyScripts</a>
<p class="cnt_small">Find more power solution: <a href="http://www.energyscripts.com/Products/product1.html" target="_blank">ES File Upload &amp; Download Manager</a>
</body>
</html>