<?php

/******************************************************************
Projectname:   Image Regenerator
Version:       0.1
Author:        Dipesh Rabadiya <dipeshjr_AT_gmail.com>
Last modified: 3 October 2008
Copyright (C): 2008 Dipesh Rabadiya, All Rights Reserved

* GNU General Public License (Version 2, June 1991)
*
* This program is free software; you can redistribute
* it and/or modify it under the terms of the GNU
* General Public License as published by the Free
*
* This program is distributed in the hope that it will
* be useful, but WITHOUT ANY WARRANTY; without even the
* implied warranty of MERCHANTABILITY or FITNESS FOR A
* PARTICULAR PURPOSE. See the GNU General Public License
* for more details.

Description:
This class can regenerate images. It can convert images type(gif to jpg,jpg to gif etc...)
and images can be resized using this class.

******************************************************************/
class genNewImages
{

	//file content holder
  	private $uploadedContent;
  	//default new width
  	private $newWidth = 60;
  	//default new width
  	private $newHeight = 60;
  	//new type to convert
  	private $newType='';
  	private $imageFile= '';
  	private $imageName="";
  	private $imageNewName="";
  	private $imageType  = "";
  	private $img="";
  	private $newPath='';
  	private $img_size="";
	function __Construct($newHeight,$newWidth,$orginalName,$newName,$toType='jpg'){
 		$this->newHeight = $newHeight;
 		$this->newWidth = $newWidth;
 		$this->imageName = $orginalName;
 		$this->imageNewName = $newName;
 		$this->newType = $toType;
 		if($this->newType=='jpg')
 			$this->newType = 'jpeg';
	}

  	public function getType(){
  		$exts = explode('.',$this->imageName);
  		$this->imageType = $exts[1];
  		if($this->imageType=='jpg')
  			$this->imageType = 'jpeg';
  	}

  	public function setDestination($dirPath=''){
		$this->newPath=$dirPath;
		genNewImages::checkWritable($this->newPath);
  	}
	public function checkWritable($imgName)
  	{
  	  if(!is_writable($imgName) && !is_dir($imgName)){
  	    $error = "The image path $imgName does not appear to be writable or the folder does not exist. Please verify your settings";
  	    throw new Exception($error);
  	  }
  	}

	 public function generateImage($filename)
	 {
		$imageExt='';
	 	$this->uploadedContent=$filename;
	  	genNewImages::getType();
	 	$this->img=call_user_func('imagecreatefrom'.$this->imageType,$this->uploadedContent);
		list($width,$height) = getimagesize($this->uploadedContent);
		$tmp = imagecreatetruecolor($this->newWidth,$this->newHeight);
		imagecopyresampled($tmp,$this->img,0,0,0,0,$this->newWidth,$this->newHeight,$width,$height);
		$imageExt = ($this->newType)?$this->newType:$this->imageType;
		$imageExt = ($imageExt=='jpeg')?'jpg':$imageExt;

		if($this->newPath!=''){
			call_user_func('image'.$this->newType,$tmp,$this->newPath.'/'.$this->imageNewName.'.'.$imageExt);
		}
		else{
			header("Content-Type: image/".$imageExt);
			call_user_func('image'.$this->newType,$tmp);
		}
		imagedestroy($this->img);
		}
}
?>