<?php
/*
+-------------------------------------------------+
+                                                 +
+   Objects.class.php ver. 1.0 by Lszl Zsidi    +
+     examples and support on http://gifs.hu      +
+                                                 +
+    This class can be used and distributed       +
+    free of charge, but cannot be modified       +
+        without permission of author.            +
+                                                 +
+-------------------------------------------------+
*/
/*
:::::::::::::::::::::::::::::::::::::::::::::::::::
::                                               ::
::                Objects class                  ::
::                                               ::
:::::::::::::::::::::::::::::::::::::::::::::::::::
*/
class Objects extends Convex3d {
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::
	::                                           ::
	::             Class variables               ::
	::                                           ::
	:::::::::::::::::::::::::::::::::::::::::::::::
	*/
	var $pointV = array();
	var $pointF = array();
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::
	::                                           ::
	::            Class constructor              ::
	::                                           ::
	:::::::::::::::::::::::::::::::::::::::::::::::
	*/
	function Objects($o, $t)
	{
		if($t == 'INT')
		{
			$_001 = $this->builtin($o);
			$_002 = strstr($_001, '#');
			$_003 = explode('#', $_002);
			$_004 = explode(',', $_003[1]);
			$_005 = explode('-1', $_003[2]);
			for($i = 0; $i < count($_004); $i++)
			{
				$_006 = array();
				$_006 = explode(' ', $_004[$i]);
				for($j = 0; $j < count($_006) - 1; $j++)
				{
					$this->pointV[$i][$j] = $_006[$j + 1];
				}
			}
			for($i = 0; $i < count($_005); $i++)
			{
				$_006 = array();
				$_006 = explode(' ', $_005[$i]);
				for($j = 0; $j < count($_006) - 2; $j++)
				{
					$this->pointF[$i][$j] = $_006[$j + 1];
				}
			}
		}
		if($t == 'EXT')
		{
			$_001 = fread(fopen($o, 'r'), filesize($o));
			$_002 = strstr($_001, '#');
			$_003 = explode('#', $_002);
			$_004 = explode(',', $_003[1]);
			$_005 = explode('-1', $_003[2]);
			for($i = 0; $i < count($_004); $i++)
			{
				$_006 = array();
				$_006 = explode(' ', $_004[$i]);
				for($j = 0; $j < count($_006) - 1; $j++)
				{
					$this->pointV[$i][$j] = $_006[$j + 1];
				}
			}
			for($i = 0; $i < count($_005); $i++)
			{
				$_006 = array();
				$_006 = explode(' ', $_005[$i]);
				for($j = 0; $j < count($_006) - 2; $j++)
				{
					$this->pointF[$i][$j] = $_006[$j + 1];
				}
			}
		}
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::
	::                                           ::
	::             Built-in objects              ::
	::                                           ::
	:::::::::::::::::::::::::::::::::::::::::::::::
	*/
	function builtin($o)
	{
		$cube = '@ cube # 1 1 1, 1 1 -1, -1 1 -1, -1 1 1, 1 -1 1, 1 -1 -1, -1 -1 -1, -1 -1 1
		# 0 1 2 3 -1 7 6 5 4 -1 0 4 5 1 -1 5 6 2 1 -1 6 7 3 2 -1 0 3 7 4 -1';
		$cuboctahedron = '@ cuboctahedron # 0 0 1.154701, 1. 0 0.5773503, 0.3333333 0.942809 0.5773503, -1. 0 0.5773503, -0.3333333 -0.942809 0.5773503, 1. 0 -0.5773503, 0.6666667 -0.942809 0, -0.6666667 0.942809 0, 0.3333333 0.942809 -0.5773503, -1. 0 -0.5773503, -0.3333333 -0.942809 -0.5773503, 0 0 -1.154701
		# 0 1 2 -1 0 3 4 -1 1 6 5 -1 2 8 7 -1 3 7 9 -1 4 10 6 -1 5 11 8 -1 9 11 10 -1 0 2 7 3 -1 0 4 6 1 -1 1 5 8 2 -1 3 9 10 4 -1 5 6 10 11 -1 7 8 11 9 -1';
		$dodecahedron = '@ dodecahedron # 0 0 1.07, .714 0 .798, -.357 .618 .798, -.357 -.618 .798, .798 .618 .357, .798 -.618 .357, -.934 .382 .357, .136 1 .357, .136 -1 .357, -.934 -.382 .357, .934 .382 -.357, .934 -.382 -.357, -.798 .618 -.357, -.136 1 -.357, -.136 -1 -.357, -.798 -.618 -.357, .357 .618 -.798, .357 -.618 -.798, -.714 0 -.798, 0 0 -1.07
		# 0 1 4 7 2 -1 0 2 6 9 3 -1 0 3 8 5 1 -1 1 5 11 10 4 -1 2 7 13 12 6 -1 3 9 15 14 8 -1 4 10 16 13 7 -1 5 8 14 17 11 -1 6 12 18 15 9 -1 10 11 17 19 16 -1 12 13 16 19 18 -1 14 15 18 19 17 -1';
		$icosahedron = '@ icosahedron # 0 0 1.18, 1.05 0 .526, .325 1 .526, -.851 .618 .526, -.851 -.618 .526, .325 -1 .526, .851 .618 -.526, .851 -.618 -.526, -.325 1 -.526, -1.05 0 -.526, -.325 -1 -.526, 0 0 -1.18
		# 0 1 2 -1 0 2 3 -1 0 3 4 -1 0 4 5 -1 0 5 1 -1 1 5 7 -1 1 7 6 -1 1 6 2 -1 2 6 8 -1 2 8 3 -1 3 8 9 -1 3 9 4 -1 4 9 10 -1 4 10 5 -1 5 10 7 -1 6 7 11 -1 6 11 8 -1 7 10 11 -1 8 11 9 -1 9 11 10 -1';
		$icosidodecahedron = '@ icosidodecahedron # 0 0 1.05, .618 0 .851, .276 .553 .851, -.618 0 .851, -.276 -.553 .851, 1 0 .325, .724 -.553 .526, -.171 .894 .526, .447 .894 .325, -1 0 .325, -.724 .553 .526, .171 -.894 .526, -.447 -.894 .325, 1 0 -.325, .894 .553 0, .553 -.894 0, -.553 .894 0, .447 .894 -.325, -1 0 -.325, -.894 -.553 0, -.447 -.894 -.325, .618 0 -.851, .724 -.553 -.526, .171 -.894 -.526, -.724 .553 -.526, -.171 .894 -.526, .276 .553 -.851, -.618 0 -.851, -.276 -.553 -.851, 0 0 -1.05
		# 0 1 2 -1 0 3 4 -1 1 6 5 -1 2 8 7 -1 3 10 9 -1 4 12 11 -1 5 13 14 -1 6 11 15 -1 7 16 10 -1 8 14 17 -1 9 18 19 -1 12 19 20 -1 13 22 21 -1 15 23 22 -1 16 25 24 -1 17 26 25 -1 18 24 27 -1 20 28 23 -1 21 29 26 -1 27 29 28 -1 0 2 7 10 3 -1 0 4 11 6 1 -1 1 5 14 8 2 -1 3 9 19 12 4 -1 5 6 15 22 13 -1 7 8 17 25 16 -1 9 10 16 24 18 -1 11 12 20 23 15 -1 13 21 26 17 14 -1 18 27 28 20 19 -1 21 22 23 28 29 -1 24 25 26 29 27 -1';
		$icosidodecahedron_2 = '@ icosidodecahedron_2 # 0 0 1.028031, 0.4638569 0 0.9174342, 0.2187436 0.4090409 0.9174342, -0.2575486 0.3857874 0.9174342, -0.4616509 -0.04518499 0.9174342, -0.177858 -0.4284037 0.9174342, 0.5726782 -0.4284037 0.7384841, 0.8259401 -0.04518499 0.6104342, 0.6437955 0.3857874 0.702527, 0.349648 0.7496433 0.6104342, -0.421009 0.7120184 0.6104342, -0.6783139 0.3212396 0.702527, -0.6031536 -0.4466658 0.702527, -0.2749612 -0.7801379 0.6104342, 0.1760766 -0.6931717 0.7384841, 0.5208138 -0.7801379 0.4206978, 0.8552518 -0.4466658 0.3547998, 1.01294 -0.03548596 0.1718776, 0.7182239 0.661842 0.3208868, 0.3633691 0.9454568 0.1758496, -0.04574087 0.9368937 0.4206978, -0.4537394 0.905564 0.1758496, -0.7792791 0.5887312 0.3208868, -0.9537217 0.1462217 0.3547998, -0.9072701 -0.3283699 0.3547998, -0.6503371 -0.7286577 0.3208868, 0.08459482 -0.9611501 0.3547998, 0.3949153 -0.9491262 -0.007072558, 0.9360473 -0.409557 -0.1136978, 0.9829382 0.02692292 -0.2999274, 0.9463677 0.4014808 -0.007072558, 0.6704578 0.7662826 -0.1419366, -0.05007646 1.025698 -0.04779978, -0.4294337 0.8845784 -0.2999274, -0.9561681 0.3719321 -0.06525234, -1.022036 -0.1000338 -0.04779978, -0.8659056 -0.5502712 -0.06525234, -0.5227761 -0.8778535 -0.1136978, -0.06856319 -1.021542 -0.09273844, 0.2232046 -0.8974878 -0.4489366, 0.6515438 -0.7200947 -0.3373472, 0.7969535 -0.3253959 -0.5619888, 0.8066872 0.4395354 -0.461425, 0.4468035 0.735788 -0.5619888, 0.001488801 0.8961155 -0.503809, -0.3535403 0.6537658 -0.7102452, -0.7399517 0.5547758 -0.4489366, -0.9120238 0.1102196 -0.461425, -0.6593998 -0.6182798 -0.4896639, -0.2490651 -0.8608088 -0.503809, 0.4301047 -0.5764987 -0.734512, 0.5057577 -0.1305283 -0.8854492, 0.5117735 0.3422252 -0.8232973, 0.09739587 0.5771941 -0.8451093, -0.6018946 0.2552591 -0.7933564, -0.6879024 -0.2100741 -0.734512, -0.3340437 -0.5171509 -0.8232973, 0.08570633 -0.3414376 -0.9658797, 0.1277354 0.1313635 -1.011571, -0.3044499 -0.06760332 -0.979586
		# 0 1 2 -1 0 2 3 -1 0 3 4 -1 0 4 5 -1 1 6 7 -1 1 7 8 -1 1 8 2 -1 2 8 9 -1 3 10 11 -1 3 11 4 -1 4 12 5 -1 5 12 13 -1 5 13 14 -1 6 14 15 -1 6 15 16 -1 6 16 7 -1 7 16 17 -1 8 18 9 -1 9 18 19 -1 9 19 20 -1 10 20 21 -1 10 21 22 -1 10 22 11 -1 11 22 23 -1 12 24 25 -1 12 25 13 -1 13 26 14 -1 14 26 15 -1 15 26 27 -1 16 28 17 -1 17 28 29 -1 17 29 30 -1 18 30 31 -1 18 31 19 -1 19 32 20 -1 20 32 21 -1 21 32 33 -1 22 34 23 -1 23 34 35 -1 23 35 24 -1 24 35 36 -1 24 36 25 -1 25 36 37 -1 26 38 27 -1 27 38 39 -1 27 39 40 -1 28 40 41 -1 28 41 29 -1 29 42 30 -1 30 42 31 -1 31 42 43 -1 32 44 33 -1 33 44 45 -1 33 45 46 -1 34 46 47 -1 34 47 35 -1 36 48 37 -1 37 48 49 -1 37 49 38 -1 38 49 39 -1 39 50 40 -1 40 50 41 -1 41 50 51 -1 42 52 43 -1 43 52 53 -1 43 53 44 -1 44 53 45 -1 45 54 46 -1 46 54 47 -1 47 54 55 -1 48 55 56 -1 48 56 49 -1 50 57 51 -1 51 57 58 -1 51 58 52 -1 52 58 53 -1 54 59 55 -1 55 59 56 -1 56 59 57 -1 57 59 58 -1 0 5 14 6 1 -1 2 9 20 10 3 -1 4 11 23 24 12 -1 7 17 30 18 8 -1 13 25 37 38 26 -1 15 27 40 28 16 -1 19 31 43 44 32 -1 21 33 46 34 22 -1 29 41 51 52 42 -1 35 47 55 48 36 -1 39 49 56 57 50 -1 45 53 58 59 54 -1';
		$octahedron = '@ octahedron # 1 0 0, 0 0 -1, -1 0 0, 0 0 1, 0 1 0, 0 -1 0
		# 0 1 4 -1 1 2 4 -1 2 3 4 -1 4 3 0 -1 5 1 0 -1 5 2 1 -1 5 3 2 -1 0 3 5 -1';
		$rhombicosidodecahedron = '@ rhombicosidodecahedron # 0 0 1.026054, 0.447838 0 0.9231617, -0.02363976 0.4472136 0.9231617, -0.4050732 0.190983 0.9231617, -0.1693344 -0.4145898 0.9231617, 0.4241982 0.4472136 0.8202696, 0.7673818 0.190983 0.6537868, 0.5552827 -0.4145898 0.7566788, -0.2312241 0.7562306 0.6537868, -0.5744076 -0.2236068 0.8202696, -0.6126576 0.5 0.6537868, 0.1738492 -0.6708204 0.7566788, -0.4669629 -0.6381966 0.6537868, 0.493393 0.7562306 0.4873039, 0.8748265 -0.2236068 0.4873039, 0.8365765 0.5 0.320821, 0.7054921 -0.6381966 0.3844118, 0.08831973 0.9472136 0.3844118, -0.5434628 0.809017 0.320821, -0.8866463 -0.1708204 0.4873039, -0.9102861 0.2763932 0.3844118, -0.1237794 -0.8944272 0.4873039, 0.3240586 -0.8944272 0.3844118, -0.7792016 -0.5854102 0.320821, 0.6289922 0.809017 0.05144604, 1.010426 -0.1708204 0.05144604, 0.9867859 0.2763932 -0.05144604, 0.8410913 -0.5854102 -0.05144604, -0.223919 1. 0.05144604, 0.223919 1. -0.05144604, -0.8410913 0.5854102 0.05144604, -0.9867859 -0.2763932 0.05144604, -1.010426 0.1708204 -0.05144604, -0.223919 -1. 0.05144604, 0.223919 -1. -0.05144604, -0.6289922 -0.809017 -0.05144604, 0.7792016 0.5854102 -0.320821, 0.9102861 -0.2763932 -0.3844118, 0.8866463 0.1708204 -0.4873039, 0.5434628 -0.809017 -0.320821, -0.3240586 0.8944272 -0.3844118, 0.1237794 0.8944272 -0.4873039, -0.7054921 0.6381966 -0.3844118, -0.8365765 -0.5 -0.320821, -0.8748265 0.2236068 -0.4873039, -0.08831973 -0.9472136 -0.3844118, -0.493393 -0.7562306 -0.4873039, 0.4669629 0.6381966 -0.6537868, 0.6126576 -0.5 -0.6537868, 0.5744076 0.2236068 -0.8202696, 0.2312241 -0.7562306 -0.6537868, -0.1738492 0.6708204 -0.7566788, -0.5552827 0.4145898 -0.7566788, -0.7673818 -0.190983 -0.6537868, -0.4241982 -0.4472136 -0.8202696, 0.1693344 0.4145898 -0.9231617, 0.4050732 -0.190983 -0.9231617, 0.02363976 -0.4472136 -0.9231617, -0.447838 0 -0.9231617, 0 0 -1.026054
		# 0 2 3 -1 1 6 5 -1 4 9 12 -1 7 16 14 -1 8 18 10 -1 11 21 22 -1 13 15 24 -1 17 29 28 -1 19 31 23 -1 20 30 32 -1 25 27 37 -1 26 38 36 -1 33 45 34 -1 35 43 46 -1 39 50 48 -1 40 41 51 -1 42 52 44 -1 47 49 55 -1 53 58 54 -1 56 57 59 -1 0 1 5 2 -1 0 3 9 4 -1 1 7 14 6 -1 2 8 10 3 -1 4 12 21 11 -1 5 6 15 13 -1 7 11 22 16 -1 8 17 28 18 -1 9 19 23 12 -1 10 18 30 20 -1 13 24 29 17 -1 14 16 27 25 -1 15 26 36 24 -1 19 20 32 31 -1 21 33 34 22 -1 23 31 43 35 -1 25 37 38 26 -1 27 39 48 37 -1 28 29 41 40 -1 30 42 44 32 -1 33 35 46 45 -1 34 45 50 39 -1 36 38 49 47 -1 40 51 52 42 -1 41 47 55 51 -1 43 53 54 46 -1 44 52 58 53 -1 48 50 57 56 -1 49 56 59 55 -1 54 58 59 57 -1 0 4 11 7 1 -1 2 5 13 17 8 -1 3 10 20 19 9 -1 6 14 25 26 15 -1 12 23 35 33 21 -1 16 22 34 39 27 -1 18 28 40 42 30 -1 24 36 47 41 29 -1 31 32 44 53 43 -1 37 48 56 49 38 -1 45 46 54 57 50 -1 51 55 59 58 52 -1';
		$rhombicuboctahedron = '@ rhombicuboctahedron # 0 0 1.070722, 0.7148135 0 0.7971752, -0.104682 0.7071068 0.7971752, -0.6841528 0.2071068 0.7971752, -0.104682 -0.7071068 0.7971752, 0.6101315 0.7071068 0.5236279, 1.04156 0.2071068 0.1367736, 0.6101315 -0.7071068 0.5236279, -0.3574067 1. 0.1367736, -0.7888348 -0.5 0.5236279, -0.9368776 0.5 0.1367736, -0.3574067 -1. 0.1367736, 0.3574067 1. -0.1367736, 0.9368776 -0.5 -0.1367736, 0.7888348 0.5 -0.5236279, 0.3574067 -1. -0.1367736, -0.6101315 0.7071068 -0.5236279, -1.04156 -0.2071068 -0.1367736, -0.6101315 -0.7071068 -0.5236279, 0.104682 0.7071068 -0.7971752, 0.6841528 -0.2071068 -0.7971752, 0.104682 -0.7071068 -0.7971752, -0.7148135 0 -0.7971752, 0 0 -1.070722
		# 0 2 3 -1 1 6 5 -1 4 9 11 -1 7 15 13 -1 8 16 10 -1 12 14 19 -1 17 22 18 -1 20 21 23 -1 0 1 5 2 -1 0 3 9 4 -1 0 4 7 1 -1 1 7 13 6 -1 2 5 12 8 -1 2 8 10 3 -1 3 10 17 9 -1 4 11 15 7 -1 5 6 14 12 -1 6 13 20 14 -1 8 12 19 16 -1 9 17 18 11 -1 10 16 22 17 -1 11 18 21 15 -1 13 15 21 20 -1 14 20 23 19 -1 16 19 23 22 -1 18 22 23 21 -1';
		$snub_cuboctahedron = '@ snub_cuboctahedron # 0 0 1.08, .744 0 .779, .312 .676 .779, -.482 .567 .779, -.717 -.2 .779, -.12 -.735 .779, .625 -.735 .481, 1.06 -.2 .0681, .887 .567 .23, .262 1.04 .0681, -.532 .934 .0681, -1.01 .308 .23, -.702 -.784 .23, .0273 -1.07 .0681, .667 -.784 -.318, .822 -.0911 -.691, .652 .676 -.529, -.12 .875 -.617, -.809 .476 -.529, -.991 -.276 -.318, -.447 -.826 -.529, .193 -.535 -.915, .185 .259 -1.03, -.505 -.141 -.941
		# 0 1 2 -1 0 2 3 -1 0 3 4 -1 0 4 5 -1 1 6 7 -1 1 7 8 -1 1 8 2 -1 2 8 9 -1 3 10 11 -1 3 11 4 -1 4 12 5 -1 5 12 13 -1 5 13 6 -1 6 13 14 -1 6 14 7 -1 7 14 15 -1 8 16 9 -1 9 16 17 -1 9 17 10 -1 10 17 18 -1 10 18 11 -1 11 18 19 -1 12 19 20 -1 12 20 13 -1 14 21 15 -1 15 21 22 -1 15 22 16 -1 16 22 17 -1 18 23 19 -1 19 23 20 -1 20 23 21 -1 21 23 22 -1 0 5 6 1 -1 2 9 10 3 -1 4 11 19 12 -1 7 15 16 8 -1 13 20 21 14 -1 17 22 23 18 -1';
		$tetrahedron = '@ tetrahedron # .577 -.2 0, -.29 -.2 -.5, -.29 -.2 .5, 0 .61 0
		# 2 1 0 -1 0 1 3 -1 1 2 3 -1 3 2 0 -1';
		$truncated_cube = '@ truncated_cube # 0 0 1.042011, 0.5621693 0 0.8773552, -0.4798415 0.2928932 0.8773552, 0.2569714 -0.5 0.8773552, 0.8773552 0.2928932 0.4798415, -0.9014684 0.2071068 0.4798415, -0.5962706 0.7071068 0.4798415, 0.1405423 -0.9142136 0.4798415, 1.017898 0.2071068 -0.08232778, 0.7609261 0.7071068 0.08232778, -1.017898 -0.2071068 0.08232778, -0.2810846 1. 0.08232778, -0.2810846 -1. 0.08232778, 0.2810846 -1. -0.08232778, 0.9014684 -0.2071068 -0.4798415, 0.2810846 1. -0.08232778, -0.7609261 -0.7071068 -0.08232778, -0.8773552 -0.2928932 -0.4798415, -0.1405423 0.9142136 -0.4798415, 0.5962706 -0.7071068 -0.4798415, 0.4798415 -0.2928932 -0.8773552, -0.5621693 0 -0.8773552, -0.2569714 0.5 -0.8773552, 0 0 -1.042011
		# 0 3 1 -1 2 6 5 -1 4 8 9 -1 7 12 13 -1 10 17 16 -1 11 15 18 -1 14 19 20 -1 21 22 23 -1 0 1 4 9 15 11 6 2 -1 0 2 5 10 16 12 7 3 -1 1 3 7 13 19 14 8 4 -1 5 6 11 18 22 21 17 10 -1 8 14 20 23 22 18 15 9 -1 12 16 17 21 23 20 19 13 -1';
		$truncated_cuboctahedron = '@ truncated_cuboctahedron # 0 0 1.024117, 0.4314788 0 0.928785, -0.02106287 0.4309644 0.928785, -0.3410582 -0.2642977 0.928785, 0.4104159 0.4309644 0.833453, 0.7006238 -0.2642977 0.6986333, -0.3831839 0.5976311 0.7381211, -0.3919084 -0.6380712 0.6986333, -0.7031792 -0.09763107 0.7381211, 0.6584981 0.5976311 0.5079694, 0.6497736 -0.6380712 0.4684816, 0.948706 -0.09763107 0.3731496, -0.4638216 0.8333333 0.3731496, -0.7242421 0.3333333 0.6427891, -0.7540295 -0.4714045 0.5079694, -0.1227634 -0.9023689 0.4684816, 0.5778604 0.8333333 0.1429979, 0.9276431 0.3333333 0.2778177, 0.8978557 -0.4714045 0.1429979, 0.3087154 -0.9023689 0.3731496, -0.8048797 0.5690356 0.2778177, -0.2157394 1. 0.04766598, -0.8470055 -0.5690356 0.08715377, -0.2157394 -1. 0.04766598, 0.8470055 0.5690356 -0.08715377, 0.2157394 1. -0.04766598, 0.8048797 -0.5690356 -0.2778177, 0.2157394 -1. -0.04766598, -0.8978557 0.4714045 -0.1429979, -0.3087154 0.9023689 -0.3731496, -0.9276431 -0.3333333 -0.2778177, -0.5778604 -0.8333333 -0.1429979, 0.7540295 0.4714045 -0.5079694, 0.1227634 0.9023689 -0.4684816, 0.7242421 -0.3333333 -0.6427891, 0.4638216 -0.8333333 -0.3731496, -0.948706 0.09763107 -0.3731496, -0.6497736 0.6380712 -0.4684816, -0.6584981 -0.5976311 -0.5079694, 0.7031792 0.09763107 -0.7381211, 0.3919084 0.6380712 -0.6986333, 0.3831839 -0.5976311 -0.7381211, -0.7006238 0.2642977 -0.6986333, -0.4104159 -0.4309644 -0.833453, 0.3410582 0.2642977 -0.928785, 0.02106287 -0.4309644 -0.928785, -0.4314788 0 -0.928785, 0 0 -1.024117
		# 0 1 4 2 -1 3 8 14 7 -1 5 10 18 11 -1 6 12 20 13 -1 9 17 24 16 -1 15 23 27 19 -1 21 25 33 29 -1 22 30 38 31 -1 26 35 41 34 -1 28 37 42 36 -1 32 39 44 40 -1 43 46 47 45 -1 0 2 6 13 8 3 -1 1 5 11 17 9 4 -1 7 14 22 31 23 15 -1 10 19 27 35 26 18 -1 12 21 29 37 28 20 -1 16 24 32 40 33 25 -1 30 36 42 46 43 38 -1 34 41 45 47 44 39 -1 0 3 7 15 19 10 5 1 -1 2 4 9 16 25 21 12 6 -1 8 13 20 28 36 30 22 14 -1 11 18 26 34 39 32 24 17 -1 23 31 38 43 45 41 35 27 -1 29 33 40 44 47 46 42 37 -1';
		$truncated_dodecahedron = '@ truncated_dodecahedron # 0 0 1.014485, 0.3367628 0 0.9569589, -0.2902233 0.1708204 0.9569589, 0.1634681 -0.2944272 0.9569589, 0.5914332 0.1708204 0.806354, -0.5963465 0.1527864 0.806354, -0.4230517 0.4472136 0.806354, 0.1377417 -0.6 0.806354, 0.8302037 0.1527864 0.5626702, 0.6667356 0.4472136 0.6201961, -0.8014407 -0.0472136 0.6201961, -0.3477493 0.7236068 0.6201961, -0.06735256 -0.8 0.6201961, 0.2694102 -0.8 0.5626702, 0.9618722 -0.0472136 0.3189863, 0.5339072 0.7236068 0.4695912, -0.8271671 -0.3527864 0.4695912, -0.9599955 -0.0763932 0.3189863, -0.3992021 0.8763932 0.3189863, -0.09307895 0.8944272 0.4695912, -0.3734757 -0.818034 0.4695912, 0.5081808 -0.818034 0.3189863, 0.9361459 -0.3527864 0.1683814, 1.011448 -0.0763932 -0.0177765, 0.4824544 0.8763932 0.1683814, 0.2436839 0.8944272 0.4120653, -0.663699 -0.6472136 0.4120653, -1.011448 0.0763932 0.0177765, -0.5577569 0.8472136 0.0177765, -0.5320305 -0.8472136 0.1683814, 0.5577569 -0.8472136 -0.0177765, 0.7628511 -0.6472136 0.1683814, 0.9599955 0.0763932 -0.3189863, 0.5320305 0.8472136 -0.1683814, -0.9618722 0.0472136 -0.3189863, -0.9361459 0.3527864 -0.1683814, -0.7628511 0.6472136 -0.1683814, -0.5081808 0.818034 -0.3189863, -0.4824544 -0.8763932 -0.1683814, 0.3992021 -0.8763932 -0.3189863, 0.8014407 0.0472136 -0.6201961, 0.8271671 0.3527864 -0.4695912, 0.663699 0.6472136 -0.4120653, 0.3734757 0.818034 -0.4695912, -0.8302037 -0.1527864 -0.5626702, -0.2694102 0.8 -0.5626702, -0.5339072 -0.7236068 -0.4695912, -0.2436839 -0.8944272 -0.4120653, 0.09307895 -0.8944272 -0.4695912, 0.3477493 -0.7236068 -0.6201961, 0.5963465 -0.1527864 -0.806354, 0.06735256 0.8 -0.6201961, -0.6667356 -0.4472136 -0.6201961, -0.5914332 -0.1708204 -0.806354, -0.1377417 0.6 -0.806354, 0.4230517 -0.4472136 -0.806354, 0.2902233 -0.1708204 -0.9569589, -0.3367628 0 -0.9569589, -0.1634681 0.2944272 -0.9569589, 0 0 -1.014485
		# 0 3 1 -1 2 6 5 -1 4 8 9 -1 7 12 13 -1 10 17 16 -1 11 19 18 -1 14 22 23 -1 15 24 25 -1 20 26 29 -1 21 30 31 -1 27 35 34 -1 28 37 36 -1 32 40 41 -1 33 42 43 -1 38 46 47 -1 39 48 49 -1 44 53 52 -1 45 51 54 -1 50 55 56 -1 57 58 59 -1 0 1 4 9 15 25 19 11 6 2 -1 0 2 5 10 16 26 20 12 7 3 -1 1 3 7 13 21 31 22 14 8 4 -1 5 6 11 18 28 36 35 27 17 10 -1 8 14 23 32 41 42 33 24 15 9 -1 12 20 29 38 47 48 39 30 21 13 -1 16 17 27 34 44 52 46 38 29 26 -1 18 19 25 24 33 43 51 45 37 28 -1 22 31 30 39 49 55 50 40 32 23 -1 34 35 36 37 45 54 58 57 53 44 -1 40 50 56 59 58 54 51 43 42 41 -1 46 52 53 57 59 56 55 49 48 47 -1';
		$truncated_icosahedron = '@ truncated_icosahedron # 0 0 1.02, .404 0 .938, -.227 .333 .938, -.147 -.376 .938, .58 .333 .772, .506 -.376 .803, -.602 .291 .772, -.0514 .667 .772, .165 -.608 .803, -.522 -.418 .772, .858 .291 .471, .352 .667 .688, .784 -.418 .503, -.657 .598 .503, -.749 -.0849 .688, -.317 .83 .503, .104 -.883 .503, -.584 -.693 .471, .803 .598 .202, .96 -.0849 .336, .49 .83 .336, .722 -.693 .202, -.86 .529 .15, -.952 -.154 .336, -.179 .994 .15, .382 -.925 .202, -.271 -.925 .336, -.849 -.529 .202, .849 .529 -.202, 1.01 -.154 -.0673, .224 .994 .0673, .86 -.529 -.15, -.722 .693 -.202, -1.01 .154 .0673, -.382 .925 -.202, .179 -.994 -.15, -.224 -.994 -.0673, -.803 -.598 -.202, .584 .693 -.471, .952 .154 -.336, .271 .925 -.336, .657 -.598 -.503, -.784 .418 -.503, -.96 .0849 -.336, -.104 .883 -.503, .317 -.83 -.503, -.49 -.83 -.336, -.858 -.291 -.471, .522 .418 -.772, .749 .0849 -.688, .602 -.291 -.772, -.506 .376 -.803, -.165 .608 -.803, .0514 -.667 -.772, -.352 -.667 -.688, -.58 -.333 -.772, .147 .376 -.938, .227 -.333 -.938, -.404 0 -.938, 0 0 -1.02
		# 0 3 8 5 1 -1 2 7 15 13 6 -1 4 10 18 20 11 -1 9 14 23 27 17 -1 12 21 31 29 19 -1 16 26 36 35 25 -1 22 32 42 43 33 -1 24 30 40 44 34 -1 28 39 49 48 38 -1 37 47 55 54 46 -1 41 45 53 57 50 -1 51 52 56 59 58 -1 0 1 4 11 7 2 -1 0 2 6 14 9 3 -1 1 5 12 19 10 4 -1 3 9 17 26 16 8 -1 5 8 16 25 21 12 -1 6 13 22 33 23 14 -1 7 11 20 30 24 15 -1 10 19 29 39 28 18 -1 13 15 24 34 32 22 -1 17 27 37 46 36 26 -1 18 28 38 40 30 20 -1 21 25 35 45 41 31 -1 23 33 43 47 37 27 -1 29 31 41 50 49 39 -1 32 34 44 52 51 42 -1 35 36 46 54 53 45 -1 38 48 56 52 44 40 -1 42 51 58 55 47 43 -1 48 49 50 57 59 56 -1 53 54 55 58 59 57 -1';
		$truncated_icosidodecahedron = '@ truncated_icosidodecahedron # 0 0 1.008759, 0.2629922 0 0.973874, -0.00462747 0.2629515 0.973874, -0.2211363 -0.1423503 0.973874, 0.2583647 0.2629515 0.9389886, 0.4673861 -0.1423503 0.8825429, -0.2303913 0.3835526 0.9041033, -0.3159502 -0.372678 0.8825429, -0.4469001 -0.02174919 0.9041033, 0.4581312 0.3835526 0.8127722, 0.5351104 -0.372678 0.7696515, 0.6671526 -0.02174919 0.7563265, -0.3326926 0.5786893 0.7563265, -0.4515276 0.2412023 0.8692179, -0.541714 -0.2520769 0.8127722, -0.248226 -0.6030057 0.7696515, 0.518368 0.5786893 0.6434351, 0.6625252 0.2412023 0.7214412, 0.7348768 -0.2520769 0.6434351, 0.4402965 -0.6030057 0.6783205, -0.5538289 0.436339 0.7214412, -0.2724557 0.7738261 0.5869894, -0.6997536 -0.3618034 0.6301101, -0.04383203 -0.745356 0.6783205, -0.4062656 -0.7127322 0.5869894, 0.722762 0.436339 0.552104, 0.4160667 0.7738261 0.4956583, 0.8398294 -0.3618034 0.4258876, 0.2191601 -0.745356 0.6434351, 0.5452491 -0.7127322 0.460773, -0.7147284 0.4891254 0.5172187, -0.07268925 0.8944272 0.460773, -0.4333553 0.8266125 0.3827669, -0.8606531 -0.309017 0.4258876, -0.6320294 -0.5921311 0.5172187, -0.2018716 -0.8550825 0.4956583, 0.8248546 0.4891254 0.3129962, 0.1903029 0.8944272 0.4258876, 0.5181594 0.8266125 0.2565505, 0.9419221 -0.309017 0.1867798, 0.7450156 -0.5921311 0.3345566, 0.3241127 -0.8550825 0.4258876, -0.8727679 0.3793989 0.3345566, -0.6544916 0.6842621 0.3478816, -0.2335888 0.9472136 0.2565505, -0.7929289 -0.5393447 0.3129962, -0.9629544 -0.1138803 0.2781109, -0.096919 -0.9648091 0.2781109, 0.9298072 0.3793989 0.09544872, 0.7225533 0.6842621 0.1652194, 0.2923956 0.9472136 0.1867798, 0.8471082 -0.5393447 0.09544872, 1.002159 -0.1138803 0.01744268, 0.1660732 -0.9648091 0.2432255, -0.8125311 0.5745356 0.1652194, -0.9675818 0.1490712 0.2432255, -0.1314961 1. 0.01744268, -0.8275059 -0.5745356 0.05232804, -0.9975315 -0.1490712 0.01744268, -0.1314961 -1. 0.01744268, 0.8275059 0.5745356 -0.05232804, 0.9975315 0.1490712 -0.01744268, 0.1314961 1. -0.01744268, 0.8125311 -0.5745356 -0.1652194, 0.9675818 -0.1490712 -0.2432255, 0.1314961 -1. -0.01744268, -0.8471082 0.5393447 -0.09544872, -1.002159 0.1138803 -0.01744268, -0.1660732 0.9648091 -0.2432255, -0.7225533 -0.6842621 -0.1652194, -0.9298072 -0.3793989 -0.09544872, -0.2923956 -0.9472136 -0.1867798, 0.7929289 0.5393447 -0.3129962, 0.9629544 0.1138803 -0.2781109, 0.096919 0.9648091 -0.2781109, 0.6544916 -0.6842621 -0.3478816, 0.8727679 -0.3793989 -0.3345566, 0.2335888 -0.9472136 -0.2565505, -0.7450156 0.5921311 -0.3345566, -0.9419221 0.309017 -0.1867798, -0.3241127 0.8550825 -0.4258876, -0.8248546 -0.4891254 -0.3129962, -0.5181594 -0.8266125 -0.2565505, -0.1903029 -0.8944272 -0.4258876, 0.6320294 0.5921311 -0.5172187, 0.8606531 0.309017 -0.4258876, 0.2018716 0.8550825 -0.4956583, 0.7147284 -0.4891254 -0.5172187, 0.4333553 -0.8266125 -0.3827669, 0.07268925 -0.8944272 -0.460773, -0.8398294 0.3618034 -0.4258876, -0.5452491 0.7127322 -0.460773, -0.2191601 0.745356 -0.6434351, -0.722762 -0.436339 -0.552104, -0.4160667 -0.7738261 -0.4956583, 0.6997536 0.3618034 -0.6301101, 0.4062656 0.7127322 -0.5869894, 0.04383203 0.745356 -0.6783205, 0.5538289 -0.436339 -0.7214412, 0.2724557 -0.7738261 -0.5869894, -0.7348768 0.2520769 -0.6434351, -0.4402965 0.6030057 -0.6783205, -0.6625252 -0.2412023 -0.7214412, -0.518368 -0.5786893 -0.6434351, 0.541714 0.2520769 -0.8127722, 0.248226 0.6030057 -0.7696515, 0.4515276 -0.2412023 -0.8692179, 0.3326926 -0.5786893 -0.7563265, -0.6671526 0.02174919 -0.7563265, -0.5351104 0.372678 -0.7696515, -0.4581312 -0.3835526 -0.8127722, 0.4469001 0.02174919 -0.9041033, 0.3159502 0.372678 -0.8825429, 0.2303913 -0.3835526 -0.9041033, -0.4673861 0.1423503 -0.8825429, -0.2583647 -0.2629515 -0.9389886, 0.2211363 0.1423503 -0.973874, 0.00462747 -0.2629515 -0.973874, -0.2629922 0 -0.973874, 0 0 -1.008759
		# 0 1 4 2 -1 3 8 14 7 -1 5 10 18 11 -1 6 12 20 13 -1 9 17 25 16 -1 15 24 35 23 -1 19 28 41 29 -1 21 31 44 32 -1 22 33 45 34 -1 26 38 50 37 -1 27 40 51 39 -1 30 43 54 42 -1 36 48 60 49 -1 46 55 67 58 -1 47 59 65 53 -1 52 64 73 61 -1 56 62 74 68 -1 57 70 81 69 -1 63 75 87 76 -1 66 78 90 79 -1 71 82 94 83 -1 72 85 95 84 -1 77 89 99 88 -1 80 92 101 91 -1 86 96 105 97 -1 93 102 110 103 -1 98 107 113 106 -1 100 109 114 108 -1 104 111 116 112 -1 115 118 119 117 -1 0 2 6 13 8 3 -1 1 5 11 17 9 4 -1 7 14 22 34 24 15 -1 10 19 29 40 27 18 -1 12 21 32 43 30 20 -1 16 25 36 49 38 26 -1 23 35 47 53 41 28 -1 31 37 50 62 56 44 -1 33 46 58 70 57 45 -1 39 51 63 76 64 52 -1 42 54 66 79 67 55 -1 48 61 73 85 72 60 -1 59 71 83 89 77 65 -1 68 74 86 97 92 80 -1 69 81 93 103 94 82 -1 75 88 99 107 98 87 -1 78 91 101 109 100 90 -1 84 95 104 112 105 96 -1 102 108 114 118 115 110 -1 106 113 117 119 116 111 -1 0 3 7 15 23 28 19 10 5 1 -1 2 4 9 16 26 37 31 21 12 6 -1 8 13 20 30 42 55 46 33 22 14 -1 11 18 27 39 52 61 48 36 25 17 -1 24 34 45 57 69 82 71 59 47 35 -1 29 41 53 65 77 88 75 63 51 40 -1 32 44 56 68 80 91 78 66 54 43 -1 38 49 60 72 84 96 86 74 62 50 -1 58 67 79 90 100 108 102 93 81 70 -1 64 76 87 98 106 111 104 95 85 73 -1 83 94 103 110 115 117 113 107 99 89 -1 92 97 105 112 116 119 118 114 109 101 -1';
		$truncated_octahedron = '@ truncated_octahedron # 1 2 0, 0 2 1, -1 2 0, 0 2 -1, 1 -2 0, 0 -2 1, -1 -2 0, 0 -2 -1, 2 1 0, 2 0 1, 2 -1 0, 2 0 -1, -2 1 0, -2 0 1, -2 -1 0, -2 0 -1, 1 0 2, 0 1 2, -1 0 2, 0 -1 2, 1 0 -2, 0 1 -2, -1 0 -2, 0 -1 -2
		# 0 3 2 1 -1 4 5 6 7 -1 8 9 10 11 -1 12 15 14 13 -1 16 17 18 19 -1 20 23 22 21 -1 0 1 17 16 9 8 -1 1 2 12 13 18 17 -1 2 3 21 22 15 12 -1 3 0 8 11 20 21 -1 4 10 9 16 19 5 -1 5 19 18 13 14 6 -1 6 14 15 22 23 7 -1 7 23 20 11 10 4 -1';
		$truncated_tetrahedron = '@ truncated_tetrahedron # 0 0 1.105542, 0.8528029 0 0.7035265, -0.7106691 0.4714045 0.7035265, 0.3316456 -0.7856742 0.7035265, 0.9949367 0.4714045 -0.1005038, -1.089693 0.1571348 -0.1005038, -0.5685352 0.942809 -0.1005038, -0.04737794 -1.099944 -0.1005038, 0.6159132 0.1571348 -0.904534, 0.2842676 0.942809 -0.5025189, -0.758047 -0.6285394 -0.5025189, 0.09475587 -0.6285394 -0.904534
		# 0 3 1 -1 2 6 5 -1 4 8 9 -1 7 10 11 -1 0 1 4 9 6 2 -1 0 2 5 10 7 3 -1 1 3 7 11 8 4 -1 5 6 9 8 11 10 -1';
		switch($o)
		{
			case 'cube':
			return $cube;
			break;
			case 'cuboctahedron':
			return $cuboctahedron;
			break;
			case 'dodecahedron':
			return $dodecahedron;
			break;
			case 'icosahedron':
			return $icosahedron;
			break;
			case 'icosidodecahedron':
			return $icosidodecahedron;
			break;
			case 'icosidodecahedron_2':
			return $icosidodecahedron_2;
			break;
			case 'octahedron':
			return $octahedron;
			break;
			case 'rhombicosidodecahedron':
			return $rhombicosidodecahedron;
			break;
			case 'rhombicuboctahedron':
			return $rhombicuboctahedron;
			break;
			case 'snub_cuboctahedron':
			return $snub_cuboctahedron;
			break;
			case 'tetrahedron':
			return $tetrahedron;
			break;
			case 'truncated_cube':
			return $truncated_cube;
			break;
			case 'truncated_cuboctahedron':
			return $truncated_cuboctahedron;
			break;
			case 'truncated_dodecahedron':
			return $truncated_dodecahedron;
			break;
			case 'truncated_icosahedron':
			return $truncated_icosahedron;
			break;
			case 'truncated_icosidodecahedron':
			return $truncated_icosidodecahedron;
			break;
			case 'truncated_octahedron':
			return $truncated_octahedron;
			break;
			case 'truncated_tetrahedron':
			return $truncated_tetrahedron;
			break;
		}
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::
	::                                           ::
	::            Passes parameters              ::
	::                                           ::
	:::::::::::::::::::::::::::::::::::::::::::::::
	*/
	function pointV()
	{
		return $this->pointV;
	}
	/*
	:::::::::::::::::::::::::::::::::::::::::::::::
	::                                           ::
	::            Passes parameters              ::
	::                                           ::
	:::::::::::::::::::::::::::::::::::::::::::::::
	*/
	function pointF()
	{
		return $this->pointF;
	}
}
?>
