<?php
  /* This example file is written for a UNIX/Linux host with PHP4, Zend and the GD Library */

  /* include classfile */
  include("class.image.php4.php");
	
	/* load original image object from file */
	$objPhoto = new clsImage();
	$objPhoto->loadfile("test.jpg");
	
	/* copy original image object to resize image object */	
	$objPhotoResized = $objPhoto;
	$objPhotoResized->resize(100,100);
	/* write text on memoryimage
	   params: 
		   text           = resized
			 fontsize       = 16 pixels
			 fontcolor      = 255,0,0 [R,G,B] = red
			 fontfile       = arial.ttf = <fontfiledir>\arial.ttf
			 x-start-pos    = 30
			 y-start-pos    = 80
			 rotation-angle = 45 (degrees)
	*/
	$objPhotoResized->writetext('resized',16,'255,0,0','arial.ttf',30,80,45);
	$objPhotoResized->convert('png');
	//$objPhotoResized->preview();		
	$objPhotoResized->savefile('test-resized.png');			
	
	/* copy original image object to resizewidth image object*/	
	$objPhotoResizedWidth = $objPhoto;
	$objPhotoResizedWidth->resizetowidth(150);
	//$objPhotoResizedWidth->writetext('to width',14,'0,255,0','times.ttf',30,80,0);
	//$objPhotoResizedWidth->writetext($objPhotoResizedWidth->width . ' pixels',12,'100,255,255','arial.ttf',5,100,0);	
	$objPhotoResizedWidth->convert('gif');	
	$objPhotoResizedWidth->savefile('test-resized-width.gif');
	
	/* copy original image object to resizeheight image object*/	
	$objPhotoResizedHeight = $objPhoto;
	$objPhotoResizedHeight->resizetoheight(500);	
	//$objPhotoResizedHeight->writetext('to height',14,'0,255,0','arial.ttf',30,80,0);
	//$objPhotoResizedHeight->writetext($objPhotoResizedHeight->height . ' pixels',16,'0,0,255','verdana.ttf',100,250,0);
	//$objPhotoResizedHeight->writetext('BAD JPEG QUALITY IS SET TO 25 Image->jpegquality',10,'255,0,0','arial.ttf',10,350,0);
  //$objPhotoResizedHeight->jpegquality = 25;				
	$objPhotoResizedHeight->savefile('test-resized-height.jpg');
	
	/* copy original image object to resizepercentage image object*/	
	$objPhotoResizedPercentage = $objPhoto;
	$objPhotoResizedPercentage->resizetopercentage(25);					
	$objPhotoResizedPercentage->savefile('test-resized-percentage.jpg');	
	
	/* copy original image object to crop image object*/	
	$objPhotoCropped = $objPhoto;
	$objPhotoCropped->crop(300,250,150);
	//$objPhotoCropped->writetext('cropped',12,'255,0,0','arial.ttf',10,35,20);	
  $objPhotoCropped->interlace = false; 
	$objPhotoCropped->savefile('test-cropped.jpg');
	
	/* copy cropped (landscape image object) to crop2 image object*/	
	$objPhotoCropped2 = $objPhotoCropped;
	$objPhotoCropped2->crop(100,100);
	$objPhotoCropped2->writetext('cropped',16,'0,255,0','verdana.ttf',10,80,0);
  $objPhotoCropped2->jpegquality = 100;			
	$objPhotoCropped2->savefile('test-cropped2.jpg');							
?>
<html>
<head> 
<title>PHP CLASS clsImage [ PHP4 | UNIX/Linux ] example</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
.imageResized {	border: solid 1px #FF0000; }
-->
</style>
</head>
<body>
<?php 
	/* show the html imagetag (source = clsImage->filename)
	   params:
		   html image alt-tag (optional) = this is the original image
	*/
  $objPhoto->showhtml("this is the original image");
?>
<br>
<?php print $objPhoto->filename; ?>
<br>
<br>
<?php 
  $objPhotoResized->showhtml("this is the resized image (resized without keep ratio)","imageResized"); 
?>
<br>
<?php print $objPhotoResized->filename; ?>
<br>
<br>
<?php 
  $objPhotoResizedWidth->showhtml("this is the resized to width image (resized with keep ratio)","imageResized"); 
?>
<br>
<?php print $objPhotoResizedWidth->filename; ?>
<br>
<br>
<?php 
  $objPhotoResizedHeight->showhtml("this is the resized to height image (resized with keep ratio)","imageResized"); 
?>
<br>
<?php print $objPhotoResizedHeight->filename; ?>
<br>
<br>
<?php 
  $objPhotoResizedPercentage->showhtml("this is the resized to percentage image (resized with keep ratio)","imageResized"); 
?>
<br>
<?php print $objPhotoResizedPercentage->filename; ?>
<br>
<br>
<?php 
  $objPhotoCropped->showhtml("this is the cropped image (cropped with keep ratio)","imageResized"); 
?>
<br>
<?php print $objPhotoCropped->filename; ?>
<br>
<br>
<?php 
  $objPhotoCropped2->showhtml("this is the second cropped image (cropped with keep ratio)","imageResized"); 
?>
<br>
<?php print $objPhotoCropped2->filename; ?>
</body>
</html>
