<?php
/**
 * This class writes some text over a image
 * 
 * @author Rochak Chauhan
 */

class TestOnImage {

	var $text = "Rochak Chauhan";

	var $backgroundImage = 'bg.jpg';
	var $alphabetDir = 'alphabets';
	var $imageResource = '';
	
	var $text_X = 0;
	var $text_Y = 0;
	
	/**
	 * Contructor function
	 *
	 * @param string $string
	 * @param int $text_X
	 * @param int $text_Y
	 * @param string $backgroundImage
	 * @param string $alphabetDir
	 * 
	 * @return object
	 */
	function TestOnImage($string, $text_X = 0, $text_Y = 0, $backgroundImage = '', $alphabetDir = '') {
		
		$text_X = (int) $text_X;
		$text_Y = (int) $text_Y;
		
		if ($text_X < 0 || $text_X > 999) {
			trigger_error('Please enter a numeric value for Y coordinate between 0 - 999. You entered: '.$text_X, E_USER_ERROR);
			exit;
		}
		else {
			$this->text_X = $text_X;
		}
				
		if ($text_Y < 0 || $text_Y > 999) {
			trigger_error('Please enter a numeric value for the Y coordinate between 0 - 999. You entered: '.$text_Y, E_USER_ERROR);
			exit;
		}
		else {
			$this->text_Y = $text_Y;
		}
		
		if(trim($backgroundImage)  != '') {
			$this->backgroundImage = $backgroundImage;
		}
		
		if(trim($alphabetDir)  != '') {
			$this->alphabetDir = $alphabetDir;
		}
		
		if(trim($string) != '') {
			$this->text = $string;
			$this->createImage();
		}
	}


   /**
	* Function to create image from text 
	*
	*/
	function createImage() {
		$letterArray = array();

		for ($i=0; $i < strlen($this->text); $i++) {

			$var  = strtolower($this->text[$i]);

			if ($var == ' ') {
				$var = $this->alphabetDir.DIRECTORY_SEPARATOR."space.gif";
			}
			elseif ($var == '.') {
				$var = $this->alphabetDir.DIRECTORY_SEPARATOR."dot.gif";
			}
			else {
				$var = $this->alphabetDir.DIRECTORY_SEPARATOR."$var.gif";
			}
			$letterArray[] = $var;
		}
		$imgArray = getimagesize($this->backgroundImage);
		
		switch ($imgArray['mime']) {
			
			case 'image/gif':
				$this->imageResource = imagecreatefromgif($this->backgroundImage);				
				break;
				
			case 'image/jpeg';
				$this->imageResource = imageCreateFromJPEG($this->backgroundImage);				
				break;
			
			case 'image/png';
				$this->imageResource = imagecreatefrompng($this->backgroundImage);				
				break;
					
			default:
				die("Unsupported image type:  ".$this->backgroundImage);
					
		}
		
		$y = 0;

		for ($i=0; $i<count($letterArray); $i++) {

			$s[$i] = imagecreatefromgif($letterArray[$i]);
			
			imagecopymerge($this->imageResource, $s[$i], ($this->text_X+$y), $this->text_Y, 0, 0, 20, 30, 100);
			$y = $y+20;
		}

	}
	
	/**
	 * Function to display the images (FIREFOX)
	 * 
	 */
	function displayImage($fileName = '') {
		if(trim($fileName == '')) {
			header("Content-type: image/jpg");
			imagejpeg($this->imageResource);
		}
		else {
			imagejpeg($this->imageResource, $fileName);
		}
	}
	
	/**
	 * Function to display the images (INTERNET EXPLORER)
	 * 
	 */
	function displayImageIE() {
		
		imagejpeg($this->imageResource, 'image.jpg');
		echo '<img src="image.jpg" />';
	}
}
?>