<?php

  /************************************************************\
  *
  *    Basic Thumbnail Generator Copyright 2007 Derek Harvey
  *		 www.lotsofcode.com
  *
  *    This file is part of Basic Thumbnail Generator.
  *
  *    Basic Thumbnail Generator is free software; you can redistribute it and/or modify
  *    it under the terms of the GNU General Public License as published by
  *    the Free Software Foundation; either version 2 of the License, or
  *    (at your option) any later version.
  *
  *    Basic Thumbnail Generator is distributed in the hope that it will be useful,
  *    but WITHOUT ANY WARRANTY; without even the implied warranty of
  *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *    GNU General Public License for more details.
  *
  *    You should have received a copy of the GNU General Public License
  *    along with Basic Thumbnail Generator; if not, write to the Free Software
  *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  *
  *
  \************************************************************/

  require_once 'thumbnail.class.php';	
  $thumbnail = new thumbnail;
  
  if (!empty($_REQUEST['submit']))
  {
  	$tmp = $_FILES['uploaded_file']['tmp_name']; 
  	$org = $_FILES['uploaded_file']['name'];
  	
  	if ($tmp)
  	{
  		$directory = 'uploads'; // Upload files to here.
  		$prefix = 'uploaded_'; // Filename prefixes
  		
  		// Upload all image files
  		$lrgImage = $thumbnail->generate($tmp, $org, $directory, $prefix.'lrg', 300); // large file
  		$medImage = $thumbnail->generate($tmp, $org, $directory, $prefix.'med', 200); // medium file
  		$smlImage = $thumbnail->generate($tmp, $org, $directory, $prefix.'sml', 100); // small file
  		
  		if ($smlImage && $medImage && $lrgImage) // If all files are ok
  		{
  			$info = '
        <fieldset>
          <legend>Files uploaded successfully</legend>
          <img src="'.$lrgImage.'">
          <img src="'.$medImage.'">
          <img src="'.$smlImage.'">
        </fieldset><br />
        ';
  		}
  	}
  	else
  	{
  		$info = '<p>No file selected</p>';
  	}
  }
  
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
<html>
  <head>
    <title>LotsOfCode - PHP & GD Library Thumbnail Generator</title>
    <style>
      body {
        font-size: 90%;
        font-family: Tahoma;
      }
      legend {
        font-weight: bold;
        padding: 12px;
      }
    </style>
  </head>
  <body>
  <!-- BEGIN - HTML Form -->
  <h1>Thumbnail Generator</h1>
  <form action="" method="post"	enctype="multipart/form-data">
  <fieldset>
    <legend>Upload File & Create Thumbnails</legend>
    <input type="file" name="uploaded_file"><input type="submit" name="submit" value=" go ">
  </fieldset><br />
  </form>
  <?
    if (!empty($info))
    {
      echo $info;
    }
  ?>
  <!-- END - HTML Form -->
  </body>
</html>
