<?php
/************************************************/
/*	script name: PhpNeoGallery					*/
/*	author: CubaLibre <Andrea Cardone>			*/
/*	contact: info(at)area82.it					*/
/* 	website: http://phpneogallery.area82.it		*/
/* 	  											*/
/************************************************/

if(!defined('IN_GALLERY'))
{
	die('<h1>Access Error</h1>');
}

class core
{
	
	var $folder = "album";
	
	
	
	/*-----------------------------------------
	Funzione per la creazione del Breadcrumbs 
	(bricciole di pane, ndr)
	sarebbe il menu di navigazione :P
	-----------------------------------------*/
	
	function GetNav($string = "")
	{
		
		$files = $this->folder."/".$string;
		$nav = "";
		
		/* Controllo se il valore passato esiste */
		if(!file_exists($files))
		{
			return "<a href=\"index.php\">Home Gallery</a>";
		}
		
		/* Base di navigazione */
		$nav .= "<a href=\"index.php\">Home Gallery</a>";
		
		if(!isset($string))
		{
			
			$nav .= "";
			
		} else {
			
			/* Se  specificato un album suddivido le eventuali cartelle e sotto-cartelle nell'array $links */
			$link = explode('/', $string);
			
			/* Cancello gli elementi vuoti e... */
			foreach($link as $chiave => $valore)
			{
				if($link[$chiave] == "" || $link[$chiave] == "." || $link[$chiave] == "..")
				{
					unset($link[$chiave]);
				}
			}
			
			/* ...ricreo gli indici dell'array */
			$links = array_values($link);
			
			/* Ottengo il numero di cartelle nella "query-string" */
			$num_f = count($links);
			
			/* Se  stato passato un nome file cancello l'ultimo elemento */
			if(!is_dir($files))
			{
				/* Trovo la chiave dell'ultimo elemento */
				$last = --$num_f;
				
				/* Elimino l'ultimo elemento */
				unset($links[$last]);
				
				/* Ricreo gli indici */
				$links = array_values($links);
				
			}
	
			if($num_f > 0)
			{
				/* Prima cartella di navigazione */
				$nav .= " > <a href=\"index.php?album={$links[0]}\">{$links[0]}</a>";
				
			}
			
			for($i = 1; $i < $num_f; $i++)
			{
				/* Prima cartella di navigazione */
				$path = "{$links[0]}";
				
				/* Creo un nuovo array partendo dalla seconda directory ed escludendo gli elementi superiori ad $i */
				$new_array = array_slice($links, 1, $i);
				
				for($i = 0; $i < count($new_array); $i++)
				{
					$path .= "/{$new_array[$i]}";
				}
				
				/* Link relativo ad ogni singola directory */
				$nav .= " > <a href=\"index.php?album={$path}\">{$links[$i]}</a>";
				
			}
			
		} 
		
		return $nav;
	}
	
	
	
	
	/*-----------------------------------------
	Funzione per leggere e scorrere il 
	contenuto di una directory + vari controlli
	sui tipi di file etc etc...
	-----------------------------------------*/
	
	function read_folder($dir = "")
	{
		global $config, $lang, $skin;
		
		$directory = ($dir != "") ? "".$this->folder."/".$dir."" : $this->folder;
		$separator = ($dir != "") ? "/" : "";
		
		/* Controllo che non siano presenti '.' o '..' nel link passato al browser */
		$check = explode('/', $directory);
		
		if(in_array('.', $check) || in_array('..', $check))
		{
			$result_f = "<p>{$lang->lg['error_query']}</p>";
			
			echo $skin->album_view_folder($result_f);
			
			return false;
		}
		
		/* Controllo se la directory esiste */
		if(!is_dir($directory))
		{
			$result_f = "<p>{$lang->lg['error_query2']}</p>";
		}
		else
		{
		
			/* Inserisco le estensioni prese da config.php in un array */
			$type_allowed = explode(',', strtolower($config['allowed']));
		  
			/* Apro la cartella contenente gli album */
			$open_handle = opendir($directory);
		
			/* Ciclo per ricercare le directory e le immagini */
			while(false !== ($file = readdir($open_handle)))
			{
				if($file != '.' && $file != '..')
				{
					/* Se trovo una sotto-directory inserisco il link in un array*/
					if(is_dir(''.$directory.'/'.$file.''))
					{
						$name = (strlen($file) > 10) ? substr($file, 0, 7)."..." : $file;
						
						$result_folder[] = 
						"<div class=\"folder\"><a href=\"index.php?album={$dir}{$separator}{$file}\"><img src=\"images/{$config['skin']}/folder.gif\" alt=\"{$directory}/{$file}\" title=\"{$file}\" /><br />{$name}</a></div>";
					}
				
					/* Ottengo l'estensione dei file contenuti nella cartella per poi confrontarli con quelli del config.php */
					$ext = strtolower(end(explode('.', $file)));
					
					/* Se trovo un file valido inserisco il link in un array */
					if(in_array($ext, $type_allowed) && !eregi('thumb_', $file) && !eregi('full_', $file))
					{
						
						/* Se non esiste creo thumbnail, full-size e rinomino il file*/
						if(!file_exists($directory."/thumb_".$file))
						{
							$this->thumb($directory, $file, $ext);
							$this->full($directory, $file, $ext);
							
							if($config['full_size'])
							{
								@rename($directory."/".$file, $directory."/full_".$file);
							}
							else
							{
								@unlink($directory."/".$file);
							}
							
							@rename($directory."/normal_".$file, $directory."/".$file);
						}
						
						$result_pics[] = 
						"<a href=\"index.php?pics={$dir}{$separator}{$file}\"><img src=\"{$directory}/thumb_{$file}\" alt=\"{$file}\" title=\"{$lang->lg['zoom']}\" /></a>";

					}
				}
			}
			
			/* Se settato in config.php ordino gli array alfabeticamente, altrimenti sar in base in base all'ultima modifica (data) */
			if($config['order_abc'])
			{
				@natcasesort($result_folder);
				@natcasesort($result_pics);
				
				$result_folder = @array_values($result_folder);
				$result_pics = @array_values($result_pics);
			}
			
			if(is_array($result_folder))
			{
				/* Stampo tutti gli elementi in una variabile*/
				foreach($result_folder as $chiave => $valore)
				{
					/* Inserisco il divisorio nella variabile se ho raggiunto gli elementi massimi per riga */
					if($chiave % $config['folder_row'] == 0)
					{
						$result_f .= "<div class=\"clear\"> </div>";
					}
					
					$result_f .= $valore;
				}
			
			}
			
			if(is_array($result_pics))
			{
				/* Stampo tutti gli elementi in una variabile*/
				foreach($result_pics as $chiave => $valore)
				{
					/* Inserisco il divisorio nella variabile se ho raggiunto gli elementi massimi per riga */
					if($chiave % $config['pics_row'] == 0)
					{
						$result_p .= "<div class=\"clear\"> </div>";
					}
					
					$result_p .= $valore;
				}
			}
		
			if(!isset($result_folder) && !isset($result_pics))
			{
				$result_f = ($dir == "") ? "<p>{$lang->lg['zero_album']}</p>" : "<p>{$lang->lg['empty_dir']}: {$dir}</p>";
				
			}
		
			/* Chiudo la cartella aperta */
			closedir($open_handle);
		}
		
		if(isset($result_f))
		{
			echo $skin->album_view_folder($result_f);
		}
		
		if(isset($result_p))
		{
			echo $skin->album_view_pics($result_p);
		}
	}
	
	
	
	/*-----------------------------------------
	Funzione per stampare a video un immagine
	-----------------------------------------*/
	
	function get_pics($pics)
	{
		global $config, $lang, $skin;
		
		$pics = $this->folder."/".$pics;
		
		/* Inserisco le estensioni prese da config.php in un array */
		$type_allowed = explode(',', strtolower($config['allowed']));
		
		/* Ottengo l'estensione dei file contenuti nella cartella per poi confrontarli con quelli del config.php */
		$ext = strtolower(end(explode('.', $pics)));
		
		/* Verifico se il file esista, se non sia una cartella e che sia dell'estensione corretta */
		if(!file_exists($pics) || is_dir($pics) || !in_array($ext, $type_allowed))
		{
			$picture = "<p>{$lang->lg['error_file']}: {$pics}</p>";
			
			echo $skin->album_view_folder($picture);
			
			return false;
		}
		
		/* Divido path e nome file */
		$array = explode('/', $pics);
		$file = array_pop($array);
		$path = implode('/', $array);
		
		/* Eventuali thumbnail o full-size potrebbero aver passato il controllo sull'esistenza del file */
		$file = preg_replace('/thumb_/', '', $file);
		$file = preg_replace('/full_/', '', $file);
		
		/* Creiamo o meno il link al full-size, in base al settaggio in config.php */
		$picture =  ($config['full_size'] && file_exists($path."/full_".$file)) 
					? "<a href=\"{$path}/full_{$file}\" class=\"blank\"><img src=\"{$path}/{$file}\" alt =\"{$pics}\" title=\"{$lang->lg['full']}\" /></a>" 
					: "<img src=\"{$path}/{$file}\" alt =\"{$pics}\" title=\"{$pics}\" />";
		
		if(isset($picture))
		{
			echo $skin->pics_view($file, $picture);
			
			if($config['comments'])
			{
				$this->GetComment($pics);
				echo $skin->form_comment();
			}
			
			echo $skin->end_pics();
		}
	}
		
	
	/*-----------------------------------------
	Funzione interna creare la selezione 
	lingua
	-----------------------------------------*/
	
	function OptionLang()
	{
		global $config, $lang;
		
		$handle = opendir('language');
		
		while (($file = readdir($handle)) !== false) 
		{
			if(substr($file, -4) == ".php")
			{
				$file = basename($file, '.php');
				
				if($file == $_COOKIE['gallery_lang'])
				{
					$option .= "<option selected value=\"{$file}\">".ucfirst($file)."</option>";
				}
				else 
				{
					$option .= "<option value=\"{$file}\">".ucfirst($file)."</option>";
				}
			}
		}
		
		return $option;
	}
	
	
	/*-----------------------------------------
	Funzione interna per il controllo di skin
	di terse parti che potrebbero contenere
	codice pericoloso
	-----------------------------------------*/
	
	function check_skin()
	{
		global $config, $lang;
		
		$check_skin = @file_get_contents("skin/".$config['skin'].".php");

		$pattern = array('require', 'include', 'phpinfo\(', 'echo', 'print', 'mysql');

		foreach($pattern as $string)
		{
			if(eregi($string, $check_skin))
			{
				die($lang->lg['warn_skin']);
			}
		}
	}
	
	/*-----------------------------------------
	Funzione interna per creare thumbnail
	-----------------------------------------*/

	function thumb($dir, $file, $ext)
	{
		global $config, $skin;
		
		$fullfile = $dir."/".$file;
		
		/* File di destinazione */
		$new_file = $dir."/thumb_".$file;
		
		/* Info Immagine originale */
		$info = @getimagesize($fullfile);
		
		$new_width = $info[0];
		$new_height = $info[1];
		
		/* Se l'immagine  + larga dei valori di config.php, riassegno le dimensioni */
		if($new_width > $config['thumb_width'])
		{
			$new_width = $config['thumb_width'];
			$new_height = ceil($new_width * $info[1] / $info[0]);
		}
		
		/* Se l'immagine  + alta dei valori di config.php, riassegno le dimensioni */
		if($new_height > $config['thumb_height'])
		{
			$new_height = $config['thumb_height'];
			$new_width = ceil($new_height * $info[0] / $info[1]);
		}
		
		switch($ext) {
		case "gif": $source = imagecreatefromgif($fullfile); $out = 1; break;
		case "png": $source = imagecreatefrompng($fullfile); $out = 2; break;
		case "jpg": $source = imagecreatefromjpeg($fullfile); $out = 3; break;
		case "jpeg": $source = imagecreatefromjpeg($fullfile); $out = 4; break;
		default: $source = imagecreatefromjpeg($fullfile); $out = 3;
		}
		
		/* Creo un immagine delle dimensioni desiderate*/
		$thumb = imagecreatetruecolor($new_width, $new_height);
		
		/* Se  un file gif setto un background "trasparente" */
		if($ext == "gif" || $ext == "png")
		{
			sscanf($skin->transparent_thumb, "%2x%2x%2x", $red, $green, $blue);
			$transparent = imagecolorallocate($thumb, $red, $green, $blue);
			@imagefill($thumb, 0, 0, $transparent);
		}
		
		@imagecopyresampled($thumb,$source,0,0,0,0,$new_width,$new_height,imagesx($source),imagesy($source));
		
		switch($out){
		case 1: function_exists('imagegif') ? @imagegif($thumb, $new_file, 80): @imagepng($thumb, $new_file, 80); break;
		case 2: @imagepng($thumb, $new_file, 80); break;
		case 3: @imagejpeg($thumb, $new_file, 80); break;
		case 4: @imagejpeg($thumb, $new_file, 80); break;
		default: @imagejpeg($thumb, $new_file, 80);
		}
		
		imagedestroy($source);
		
	}
	
	
	
	
	/*-----------------------------------------
	Funzione interna per creare immagini che
	stiano nel layout
	-----------------------------------------*/

	function full($dir, $file, $ext)
	{
		global $config, $skin;
		
		$fullfile = $dir."/".$file;
		
		/* File di destinazione */
		$new_file = $dir."/normal_".$file;
		
		/* Info Immagine originale */
		$info = @getimagesize($fullfile);
		
		$new_width = $info[0];
		$new_height = $info[1];
		
		/* Se l'immagine  + larga dei valori di config.php, riassegno le dimensioni */
		if($new_width > $config['max_width'])
		{
			$new_width = $config['max_width'];
			$new_height = ceil($new_width * $info[1] / $info[0]);
		}
		
		switch($ext) {
		case "gif": $source = imagecreatefromgif($fullfile); $out = 1; break;
		case "png": $source = imagecreatefrompng($fullfile); $out = 2; break;
		case "jpg": $source = imagecreatefromjpeg($fullfile); $out = 3; break;
		case "jpeg": $source = imagecreatefromjpeg($fullfile); $out = 4; break;
		default: $source = imagecreatefromjpeg($fullfile); $out = 3;
		}
		
		/* Creo un immagine delle dimensioni desiderate*/
		$thumb = imagecreatetruecolor($new_width, $new_height);
		
		/* Se  un file gif setto un background "trasparente" */
		if($ext == "gif" || $ext == "png")
		{
			sscanf($skin->transparent_pics, "%2x%2x%2x", $red, $green, $blue);
			$transparent = imagecolorallocate($thumb, $red, $green, $blue);
			@imagefill($thumb, 0, 0, $transparent);
		}
		
		
		@imagecopyresampled($thumb,$source,0,0,0,0,$new_width,$new_height,imagesx($source),imagesy($source));
		
		switch($out){
		case 1: function_exists('imagegif') ? @imagegif($thumb, $new_file, 80): @imagepng($thumb, $new_file, 80); break;
		case 2: @imagepng($thumb, $new_file, 80); break;
		case 3: @imagejpeg($thumb, $new_file, 80); break;
		case 4: @imagejpeg($thumb, $new_file, 80); break;
		default: @imagejpeg($thumb, $new_file, 80);
		}
		
		imagedestroy($source);
		
		/* Se l'immagine originale era gi pronta per il layout la cancello e tengo solo la nuova creata */
		if($new_width < $config['max_width'])
		{
			@unlink($fullfile);
		}
		
	}
	
	
	
	
	/*-----------------------------------------
	Funzione per inserire i commenti
	-----------------------------------------*/
	
	function add_comment()
	{
		global $skin, $lang, $config;
		
		
		/* Destinazione file commenti */
		$cfile = $this->folder.'/'.$_POST['file'].'.comment';
		
		/* Data commento */
		$data = time();
		
		/* URL commentatore */
		$sito = ($_POST['sito'] != "") ? $_POST['sito'] : "";
		$sito = $this->parse($sito, 'url');
		
		/* Nick commentatore, se esiste anche un URL sar linkato tramite il nick */
		$nome = ($_POST['nome'] != "") ? $_POST['nome'] : $lang->lg['guest'];
		$nome = $this->parse($nome, 'nick');
		
		$lnome = ($sito != "") ? "<a href=\"http://{$sito}\" class=\"blank\">{$nome}</a>" : $nome;
		
		/* Commento */
		$commento = $this->parse($_POST['commento'], 'commento');
		
		if($commento == "")
		{
			header("Location: index.php?pics=".$_POST['file']."#comment_form");
			exit();
		}

		/* Se il file non esiste o non ha i permessi adatti tento di crearlo e dargli i permessi */
		if(!is_writable($cfile))
		{
			@touch($cfile);
			@chmod($cfile, 0755);
		}

		
		/* Apro il file in scrittura */
		$open_handle = fopen($cfile, 'a');

		/* Stringa da inserire*/
		$comment = "{$data}|{$lnome}|{$commento}\n";

		if($open_handle)
		{
			/* Se il file  aperto correttamente scrivo il commento... */
			fputs($open_handle, $comment);
		}
		else
		{
			/* ...altrimenti restituisco un errore */
			die($lang->lg['error_comment']);
		}

		/* Chiudo il file*/
		fclose($open_handle);

		/* Redirect */
		header("Location: index.php?pics=".$_POST['file']);
	
	}
	
	/*-----------------------------------------
	Funzione per leggere i commenti
	-----------------------------------------*/
	
	function GetComment($file)
	{
		global $skin;
		
		$i = 0;
		
		/* File contenente i commenti */
		$filecom = $file.".comment";
		
		/* Apro il file se esiste */
		if(file_exists($filecom))
		{
			$open_handle = fopen($filecom, 'r');
		
			if($open_handle)
			{
				while(!feof($open_handle))
				{
					
					$com = fgets($open_handle, filesize($filecom));
					
					$part = explode('|', $com);
					
					$autore = $part[1];
					
					$comment = stripslashes($part[2]);
					
					$data = date('d/m/Y', $part[0]);
					
					if($data != "01/01/1970")
					{
						$i++;
						
						/* Alterno i colori di sfondo dei commenti */
						$class = ($i % 2 == 0) ? 'pari' : 'dispari';
						
						/* Html commenti*/
						$commento .= $skin->comment($class, $autore, $data, $comment);
					}
				}
			
				echo $skin->comment_list($commento);
			}
			else
			{
				die($lang->lg['error_comment2']);
			}
		}
	
	}
	
	
	
	/*-----------------------------------------
	Funzione per parsare i commenti
	-----------------------------------------*/
	
	function parse($string, $type)
	{
		global $lang;
		
		if($string == "")
		{
			return "";
		}
		
		$string = strip_tags($string);
		$string = htmlentities($string);
		$string = addslashes($string);
		
		/* Se il nick  troppo lungo restituisco i primi 15 caratteri */
		if($type == 'nick')
		{
			if(strlen($string) > 15)
			{
				$string = substr($string, 0, 15);
			}
		}
		
		if($type == 'url')
		{
			$string = preg_replace('=([^\s]*)(www.)([^\s]*)=', '\\2\\3', $string);
		}
		
		if($type == 'commento')
		{
			$string = wordwrap($string, 60, '<br />', '\n');
			$string = ucfirst($string);
			$string = preg_replace("/[\r\n]+[\s\t]*[\r\n]+/", " ", $string);
			$string = trim($string);
			
			/* Replace faccine */
			$search = array(
							'/:incazz:/',
							'/:bacino:/',
							'/:medio:/',
							'/:perfavore:/',
							'/:cry:/',
							'/:risata:/'
							);
			
			$replace = array(
							 ' <!-- Emo --><img src="images/arrabbiato.gif" alt="" title="*" />',
							 ' <!-- Emo --><img src="images/bacino.gif" alt="" title="*" />',
							 ' <!-- Emo --><img src="images/medio.gif" alt="" title="*" />',
							 ' <!-- Emo --><img src="images/perfavore.gif" alt="" title="*" />',
							 ' <!-- Emo --><img src="images/piangere.gif" alt="" title="*" />',
							 ' <!-- Emo --><img src="images/ridere.gif" alt="" title="*" />'
							 );
			
			$string = preg_replace($search, $replace, $string);
			
			
			/* Se sono state inserite pi di 5 emoticons restituisco un avvertimento */
			$numero_emo = substr_count($string, "<!-- Emo -->");
		
			if($numero_emo > 5)
			{
				die($lang->lg['max_emo2']);
			}
		}
		
		
		return $string;
	}
	
}
?>