<?php
/************************************************/
/*	script name: PhpNeoGallery					*/
/*	author: CubaLibre <Andrea Cardone>			*/
/*	contact: info(at)area82.it					*/
/* 	website: http://phpneogallery.area82.it		*/
/* 	  											*/
/************************************************/

define('IN_GALLERY', 1);


require "config.php";
require "lib/language.php";
require "lib/core.php";


$global = new core;
$lang = new language;

if($config['check_skin'])
{
	/* Controllo skin */
	$global->check_skin();
}

if(!file_exists("skin/".$config['skin'].".php"))
{
	die('<h1>Error:</h1><br />Skin '.$config['skin'].' not found');
}

require "skin/".$config['skin'].".php";

$skin_class = "skin_{$config[skin]}";

$skin = new $skin_class;

ob_start();
$init = new init;
$init->start();
ob_end_flush();

class init
{
	var $version = "1.1";
	var $copyright = "";
	
	function init()
	{
		global $global, $config;
		
		$this->copyright = "Powered by <a href='http://phpneogallery.area82.it'>PhpNeoGallery</a> ".$this->version;
		
		if(isset($_GET['album']))
		{
			$this->navig = $_GET['album'];
		}
		else if(isset($_GET['pics']))
		{
			$this->navig = $_GET['pics'];
		}
		else
		{
			$this->navig = null;
		}
		
		if($config['comments'] && isset($_GET['act']) && $_GET['act'] == "add_comment")
		{
			$global->add_comment();
		}
		
		if(!is_writable($global->folder) || !is_dir($global->folder))
		{
			/* 	
			Se la cartella contenente gli album non esiste, o non ha i permessi di scrittura necessari (CHMOD 777)
			interrompo lo script e stampo un messaggio di errore
			*/
			die("La cartella {$this->folder} non esiste, oppure non ha i permessi di scrittura adatti");
		}
	}
	
	function start()
	{
		global $lang, $skin, $config, $global;
		
		$nav = $global->GetNav($this->navig);
		$lang_option = $global->OptionLang();
		
		echo $skin->testata($lang_option);
		echo $skin->navigazione($nav);
		
		if(!isset($_GET['album']) && !isset($_GET['pics']))
		{
			/* Se non sono specificati nessun album o nessuna foto stampo la lista degli album */
			$global->read_folder();
		}
		else if(isset($_GET['album']))
		{
			/* Stampo i contenuto di $_GET['album'] */
			$global->read_folder($_GET['album']);
		}
		else if(isset($_GET['pics']))
		{
			/* Visualizzo la foto */
			$global->get_pics($_GET['pics']);
		}
		
		$this->footer();
		
	}
	
	function footer()
	{
		global $skin;
		
		echo $skin->coda($this->copyright);
	}
}
?>