#!/usr/bin/perl
use MPEG::ID3v1Tag;

###########################################################
# This program requires very specific command line input  #
#                                                         #
# ./mp32txt local_dir method (f or 1) http_address        #
###########################################################

$output_file="/home/httpd/html/netamp/mp3s.all";

$mp3_dir=$ARGV[0];
$method=$ARGV[1];
$url=$ARGV[2];

open(FILEOUT, ">"."$output_file");
#print FILEOUT "test";
@dir_listing=`ls --format=single-column "$mp3_dir" |grep mp3`;

foreach $file_name (@dir_listing)
{
	chop($file_name);
	if ($method eq "i")
	{
		get_by_id3($filename);
	}
	else
	{
		get_by_filename($file_name);
	}
}

close(FILEOUT);
#print "Thank You for using mp32txt.pl\n";


sub get_by_filename($file_name)
{
	print FILEOUT "$file_name";
	$file_size=get_filesize($file_name);
	$file_name=~ s/.mp3// ;
	@split_file=split(/ - /, $file_name);
	foreach $file_part (@split_file)
	{
		print FILEOUT ("|". "$file_part");
	}
	print FILEOUT "|".$url."|".$file_size."\n";

}

sub get_by_id3($file_name)
{
	print FILEOUT "$file_name";
	$file_size=get_filesize($file_name);
	$full_path="$mp3_dir"."/".$file_name;
	#print "$full_path\n";
	$mp3_file_new = new MPEG::ID3v1Tag("$full_path");
	
	if ($mp3_file_new->got_tag())
	{
		$title=$mp3_file_new->get_title();
		$artist=$mp3_file_new->get_artist();
		print FILEOUT ("|"."$artist"."|"."$title"."|"."$url"."|"."$file_size"."\n");
	}
	else
	{
		print ("No ID3 tag for $full_path\n");
		print FILEOUT "|"."\n";
	}
}

sub get_filesize($file_name)
{
	$total_file=$mp3_dir."/".$file_name;
	#print $total_file." - ";
	open(MP3FILE,$total_file);
	@filestuff=stat(MP3FILE);
	
	$sizer=$filestuff[7].
	close(MP3FILE);
	chop($sizer);
	$sizer=($sizer/1024);
	$sizer=($sizer/1024);
	$sizer =~ s/^([0-9]+)\.([0-9]{2}).*$/$1.$2/;
	return $sizer;
}
