<?php
//PHP5
//This class calculates the arc of three points on a circle. Call the class with -help argv[1]
//if you create an improved versionhttp://www.jeanpierredaviau.com/feedback.htm

class arcLength {

  private $pentes = array();
  private $pnteInvs = array();
  private $pteInvDroitAlg = array();
  private $data = array();

  private $pt1a;
  private $pt1b;
  private $pt2a;
  private $pt2b;
  private $pt3a;
  private $pt3b;
  private $pt4;

  public function __construct($argv) {
    $this->pt1a = $argv[1];
    $this->pt1b = $argv[2];
    $this->pt2a = $argv[3];
    $this->pt2b = $argv[4];
    $this->pt3a = $argv[5];
    $this->pt3b = $argv[6];
	 $this->pt4 = $argv[7];
  }


  function __destruct() {
    ob_clean();
  }

	function usage(){
	print <<<END

		Usage:
		a) ligne de commande: php -check-f arcLength.php 0 14 73.5 9 96 0 4 >si y 1=y3=0 augmenter l'ordonne de [ex:4]
		b) arcLength.php 0 14 73.5 9 96 0  4 >si y 1=y3=0 augmenter l'ordonne de [ex:4]
		c) si y 1=y3=0 augmenter l'ordonne de [ex:4] est facultatif.
				.
				.
				.(0,14)
				.	. .
				.		.   .
				.			.    .
				.				.      .   (75.5, 9)
				.					.   .  .
				.					  .     .
				.				     . .    .
				.			   	  .   .   .
				.		  (73.12,9).     . 
				.					 ...      . .
				.	 		.		  .     .    ..
				. .				  .           .(96,0)
				...................................
				(0,0)										(97.02,0)

		php -check-f arcLength.php 0  0  73.12  9  97.02  0  14  [arc] => 98.705349301392
		php -check-f arcLength.php 0 14 73.5 9 96 0					[arc] => 98.554522503617
		php -check-f arcLength.php 1  4  26  2  51  0				[arc] => 51.629657987267
END;
	}

  function pentes($a, $b, $a, $b) {

    if (($a - $a) != 0) {
      (float)$pte = ($b - $b) / ($a - $a);
      $this->pentes[] = $pte;
      if ($pte != 0)
        $this->pnteInvs[] = -1 / (float)$pte;
      else
        $this->pnteInvs[] = 0;
      return $pte;
    } else {
      $this->pentes[] = ($b - $b);
      $this->pnteInvs[] = ($b - $b);
      return null;
    }
  }

  function longueurdArc($pta, $ptb, $pta, $ptb) {

    $pnte = $this->pentes[2];
    $c = ($ptb - $ptb) - ($pta * $pnte);
	 $pta = ($this->data['centrex'] - $pta);
	 $pta = ($pta - $this->data['centrex']);

	 $m  = abs(1 / (($this->data['centrey'] - $c)/$pta));
	 $m  = abs(1 / (($this->data['centrey'] + $c)/$pta));

    //$m = 1 / (($this->data['centrey'] - $c) / ($pta - $this->data['centrex']));
    //$m = -1 / (($this->data['centrey'] + $c) / ($pta - $this->data['centrex']));
	 $this->pnteInvs['m'] = $m;
	 $this->pnteInvs['m'] = $m;

    echo 'angle1= ' . (rad2deg(atan($m)) ) . '  angle2= ' . (rad2deg(atan($m))) . '  $c= ' . $c . "\n";  //

    $perimetre = ($this->data['rayon'] * 2 * M_PI);
    $this->data['perimetre'] = $perimetre;
    $sommeDesAngles = (rad2deg(atan($m)) + rad2deg(atan($m)));
    $this->data['sommeDesAngles'] = $sommeDesAngles;


    $arc = $perimetre * ($sommeDesAngles / 360);
    $this->data['arc'] = $arc;
  }

  function rayon($x2, $y2, $m, $n) {

    $rayon = sqrt(pow($m - $x2, 2) + pow(($n - $y2), 2));

    $this->data['rayon'] = $rayon;
    return $rayon;
  }

  //$y = ((1 / $pente) * $x) + $c;
  function pointsdIntersection() {

    $x2 = ($this->pteInvDroitAlg[6] - $this->pteInvDroitAlg[10]) / ($this->pteInvDroitAlg[11] - $this->pteInvDroitAlg[7]);
    $y2 = (($this->pteInvDroitAlg[11] * $x2) + $this->pteInvDroitAlg[10]);

    $this->data['centrex'] = $x2;
    $this->data['centrey'] = $y2;
    $this->rayon($x2, $y2, $this->pt3a, $this->pt3b);
  }

  function penteXYC($x, $y, $c, $pente) {
    static $i = -1;
    $this->pteInvDroitAlg[++$i] = $x;
    $this->pteInvDroitAlg[++$i] = $y;
    $this->pteInvDroitAlg[++$i] = $c;
    $this->pteInvDroitAlg[++$i] = $pente;
    $y = ($pente * $x) + $c; //528.725
    return $y;
  }

  function pteInv($pta, $ptb, $pta, $ptb, $pente, $c) {

    $x = ($pta + $pta) / 2;
    $y = ($ptb + $ptb) / 2;
    $pente2 = -(1 / $pente );   //$pente2 ngatif donne la bonne rponse

    $c = $y - ($pente2 * $x);

    $y = $this->penteXYC($x, $y, $c, $pente2);

    $texte = "\n\npteInv\n--\n";
    $texte = $texte . "\$pente= " . $pente . "\n";
    $texte = $texte . "\$penteInv= " . $pente2 . "\n";
    $texte = $texte . "\$x= " . $x . "\n";
    $texte = $texte . "\$y= " . $y . "\n";
    $texte = $texte . "\$y= " . $y . "\n";
    $texte = $texte . "\$c= " . $c;
    echo $texte . "\n--\n\n";
  }

  function segments($pta, $ptb, $pta, $ptb, $pente) {

    $texte = "\n\nsegments--\n";

    (float)$c = $ptb - ($pta * $pente);
    $texte = $texte . "\$c= " . $c . "\n";

    (float)$y = ($pente * $pta) + $c;
    $texte = $texte . "\$y= " . $y;
    echo $texte . "\n--\n\n";

    $this->pteInv($pta, $ptb, $pta, $ptb, $pente, $c);
  }

	function modifiedPoints(){
	$this->pt1b = $this->pt4;
	$hypothenuse = $this->pt3a - $this->pt1a;
	$hypothenuse = sqrt(pow(($hypothenuse/2), 2) + pow($this->pt2b, 2));

	$this->pt2a = sqrt(pow($hypothenuse, 2) - pow($this->pt4, 2));

	$somme = (rad2deg(asin($this->pt4/$hypothenuse)) + rad2deg(asin( pow(($this->pt2b/$hypothenuse), 2) ) ));

	$this->pt2a = $this->pt2a - (cos(rad2deg($somme))*$hypothenuse);
	$this->pt2b = (sin(rad2deg($somme))*$hypothenuse);
	
	echo    'modifiedPoints ' . $this->pt2a .  '  '  .  $this->pt2b .  '  '  . $this->pt1a .  '  '  . $this->pt1b . "\n";
	}

//modifiedPoints 3.1843779080454  5.1827228169486
	function main() {

	 if($this->pt1a == "-help" || $this->pt1a == "-h" || $this->pt1a == "/?"){
		 $this->usage();
		 return;
	 }

	  if($this->pt1b == 0 && $this->pt3b == 0){
		$this->modifiedPoints();
	  }

    if ($this->pentes($this->pt1a, $this->pt1b, $this->pt2a, $this->pt2b) != null)
      $this->segments($this->pt1a, $this->pt1b, $this->pt2a, $this->pt2b, $this->pentes[0]);
    else
      echo 'null'. "\n";

    if ($this->pentes($this->pt2a, $this->pt2b, $this->pt3a, $this->pt3b) != null)
      $this->segments($this->pt2a, $this->pt2b, $this->pt3a, $this->pt3b, $this->pentes[1]);
    else
      echo 'null'. "\n";

    if ($this->pentes($this->pt1a, $this->pt1b, $this->pt3a, $this->pt3b) != null)
      $this->segments($this->pt1a, $this->pt1b, $this->pt3a, $this->pt3b, $this->pentes[2]);
    else
      echo 'null'. "\n";

    $this->pointsdIntersection();
    print "\n";
    $this->longueurdArc($this->pt1a, $this->pt1b, $this->pt3a, $this->pt3b);

    print 'pentes' . "\t=";
    print_r ($this->pentes) . "\n";
    print 'pnteInvs' . "\t=";
    print_r ($this->pnteInvs) . "\n";
    print 'penteXYC' . "\t=";
    print_r ($this->pteInvDroitAlg) . "\n";
    print 'data' . "\t=";
    print_r ($this->data) . "\n";
  }
}
//		php -check-f arcLength.php 0 14 73.5 9 96 0					[arc] => 98.554522503617

$R = new arcLength($argv);
$R->main();

?>    
