<?php
class Tabela{
	var $_cabecalho = array(
		'id' => '',
		'align' => '',
		'border' => '',
		'cellspacing' => '',
		'cellpadding' => '',
		'background' => '',
		'bgcolor' => '',
		'bordercolor' => '',
		'bordercolordark' => '',
		'bordercolorlight' => '',
		'class' => '',
		'height' => '',
		'width' => '',
		'style' => '',
		'onClick' => '',
		'onDblClick' => '',
		'onKeyDown' => '',
		'onKeyPress' => '',
		'onKeyUp' => '',
		'onMouseDown' => '',
		'onMouseMove' => '',
		'onMouseOut' => '',
		'onMouseOver' => '',
		'onMouseUp' => '');
	var $_linhas = array();
	var $_linha_atributos;
	var $_temp = null;
	var $_nulas = array('colunas'=>null,'linhas'=>null);
	var $_numColunas = 0;
	var $_numLinhas = 0;

function Tabela(){
	$this->_add_cels_in_row(null);
	$this->_add_cels_in_col(null);
}
function set_header($chave,$valor){
	if( is_string($chave) && $valor!=null ){
		if( isset($this->_cabecalho[$chave]) )
			return $this->_cabecalho[$chave] = $valor;
		else
			return false;
	} else
		return false;
}
function set_linha($linha,$chave,$valor){
	if( is_string($chave) && $valor!=null ){
		if( isset($this->_linhas[$linha][$chave]) )
			return $this->_linhas[$linha][$chave] = $valor;
		else
			return false;
	} else
		return false;
}
function set_celula($l,$c,$chave,$valor){
	if( is_string($chave) && $valor!=null ){
		if( isset($this->_linhas[$l][$c][$chave]) )
			return $this->_linhas[$l][$c][$chave] = $valor;
		else
			return false;
	} else
		return false;
}
function out_put($mode = 1){
	$saida = $this->_draw_header();
	for( $i=0;$i<$this->_numLinhas;$i++ ){
		$saida .= $this->_draw_linha($i);
		for( $j=0;$j<$this->_numColunas;$j++ ){
			$saida .= $this->_draw_cel($i,$j,$mode);
		}
		$saida .= '</tr>' . "\n";
	}
	$saida .= '</table>' . "\n";
	return $saida;
}
function add_linha($pos = null,$flag = 1){
	if( $flag==-1 )
		return $this->_add_cels_in_row($pos-1);
	elseif( $flag==1 )
		return $this->_add_cels_in_row($pos);
	else
		return false;
}
function del_linha($pos = 0){
	if( $pos>=0 && $pos<$this->_numLinhas ){
		for( $i=0;$i<$this->_numColunas;$i++ ){
			$this->_unset_cel($pos,$i);
			if( !$this->_colunaExiste($i) )
				$this->_nulas['colunas'][$i]=1;
		}
		unset($this->_linhas[$pos]);
		$this->_numLinhas--;
		$this->_reIndice($this->_linhas,$this->_numLinhas);
		$this->_inc_dec('rowspan','-');
		$this->_deletar('colunas');
		return true;
	} else
		return false;
}
function add_coluna($pos = null,$flag = 1){
	if( $flag==-1 ) {
		return $this->_add_cels_in_col($pos-1);
	} elseif( $flag==1 ) {
		return $this->_add_cels_in_col($pos);
	} else
		return false;
}
function del_coluna($pos = 0){
	if( $pos>=0 && $pos<$this->_numColunas ){
		for( $i=0;$i<$this->_numLinhas;$i++ ){
			$this->_unset_cel($i,$pos,-1);
			if( !$this->_linhaExiste($i) && $i!=$this->numLinhas-1 )
				$this->_nulas['linhas'][$i]=1;
			unset($this->_linhas[$i][$pos]);
			$this->_reIndice($this->_linhas[$i],$this->_numColunas-1);
		}
		$this->_numColunas--;
		$this->_inc_dec('colspan','-');
		$this->_deletar('linhas');
		return true;
	} else
		return false;
}
function mesclar($cel1,$cel2){
	list($l0,$c0) = explode(":",$cel1);
	list($l1,$c1) = explode(":",$cel2);
	if( $this->_isCel($l0,$c0) && $this->_isCel($l1,$c1) ){
		$cel1 = & $this->_linhas[$l0][$c0];
		$cel2 = & $this->_linhas[$l1][$c1];
		if( $l0==$l1 ){
			if( $c0<$c1 ){
				if( ($c1-$c0)!=$cel1['colspan'] )
					return false;
				return $this->_celSpan($l0,$c0,$l1,$c1,'colspan');
			} else{
				if( ($c0-$c1)!=$cel2['colspan'] )
					return false;
				return $this->_celSpan($l1,$c1,$l0,$c0,'colspan');
			}
		} elseif( $c0==$c1 ) {
			if( $l0<$l1 ){
				if( ($l1-$l0)!=$cel1['rowspan'] )
					return false;
				return $this->_celSpan($l0,$c0,$l1,$c1,'rowspan');
			} else{
				if( ($l0-$l1)!=$cel2['rowspan'] )
					return false;
				return $this->_celSpan($l1,$c1,$l0,$c0,'rowspan');
			}
		} else
			return false;
	} else
		return false;
}
function dividir($cel,$mode = 1){
	list($l,$c) = explode(":",$cel);
	if( $this->_isCel($l,$c) ){
		if( $mode==-1 )
			$mode='colspan';
		elseif( $mode==1 )
			$mode='rowspan';
		else
			return false;
		return $this->_celDiv($l,$c,$mode);
	} else
		return false;
}
function _draw_header(){
	$cab = & $this->_cabecalho;
	$saida = '<table';
	foreach( $cab as $k=>$v ){
		if( $cab[$k]!=null )
			$saida.= ' ' . $k . '="' . $v . '"';
	}
	$saida .= '>' . "\n";
	return $saida;
}
function _draw_linha($linha){
	$lin = & $this->_linhas[$linha];
	$saida = '<tr';
	foreach( $lin as $k=>$v ){
		if( is_string($k) ){
			if( $lin[$k]!=null )
				$saida.= ' ' . $k . '="' . $v . '"';
		}
	}
	$saida .= '>' . "\n";
	return $saida;
}
function _draw_cel($l,$c,$mode = 1){
	$cel = & $this->_linhas[$l][$c];
	if( ($cel['colspan']<1) || ($cel['rowspan']<1) )
		return '';
	$saida = '<td';
	foreach( $cel as $k=>$v ){
		if( $cel[$k]!=null && $k!='dec' && $k!='valor' ){
			if( ($k=='colspan' && $cel[$k]<=1) || ($k=='rowspan' && $cel[$k]<=1) )
				continue;
			$saida.= ' ' . $k . '="' . $v . '"';
		}
	}
	$saida .= '>';
	if( $mode==-1 )
		$saida.='<input type="checkbox" name="cel[]" value="' . $l . ':' . $c . '"><br>';
	$saida.= $cel['valor'] .  "</td>\n";
	return $saida;
}
function _deletar($mode){
	if( !is_array($this->_nulas[$mode]) )
		return false;
	krsort($this->_nulas[$mode]);
	foreach( $this->_nulas[$mode] as $k=>$v ){
		if( $mode=='linhas' )
			$this->del_linha($k);
		else
			$this->del_coluna($k);
	}
	return true;
}
function _celSpan($l0,$c0,$l1,$c1,$mode){
	$this->_linhas[$l0][$c0][$mode]+=$this->_linhas[$l1][$c1][$mode];
	$this->_linhas[$l1][$c1][$mode] = 0;
	$this->_linhas[$l1][$c1]['dec'] = $l0 . ":" . $c0;
	$this->_reDec($l0,$c0);
	if( $mode=='rowspan' ){
		if( !$this->_linhaExiste($l1) )
			return $this->del_linha($l1);
	} else{
		if( !$this->_colunaExiste($c1) )
			return $this->del_coluna($c1);
	}
}
function _celDiv($l,$c,$mode){
	$cel = & $this->_linhas[$l][$c];
	if( $cel[$mode]>1 ){
		$cel[$mode]--;
		if( $mode=='colspan' )
			$c+=$cel[$mode];
		else
			$l+=$cel[$mode];
		$this->_linhas[$l][$c][$mode] = 1;
		$this->_linhas[$l][$c]['dec'] = null;
	} elseif( $cel[$mode]==1 ){
		if( $mode=='colspan' ){
			$this->_add_cels_in_col($c);
			for( $i=0;$i<$this->_numLinhas;$i++ ){
				if( $i==$l )
					continue;
				if( $this->_linhas[$i][$c][$mode]==1 )
					$this->_celSpan($i,$c,$i,$c+1,$mode);
			}
		} else{
			$this->_add_cels_in_row($l);
			for( $i=0;$i<$this->_numColunas;$i++ ){
				if( $i==$c )
					continue;
				if( $this->_linhas[$l][$i][$mode]==1 )
					$this->_celSpan($l,$i,$l+1,$i,$mode);
			}
		}
	} else
		return false;
}
function _add_cels_in_row($linha){
	if( $linha>$this->_numLinhas-1 )
		return false;
	switch ($linha){
	case -1:
		array_unshift($this->_linhas,array(null));
		$linha++;
		break;
	case null:
		$linha = $this->_numLinhas;
		break;
	default:
		$linha++;
		$this->_insert($this->_linhas,$linha,$this->_numLinhas);
	}
	$this->_numLinhas++;
	$this->_linhas[$linha] = array(
		'align' => '',
		'valign' => '',
		'bgcolor' => '',
		'bordercolor' => '',
		'bordercolordark' => '',
		'bordercolorlight' => '',
		'class' => '',
		'height' => '',
		'style' => '');
	for( $i=0;$i<$this->_numColunas;$i++ ){
		$this->_set_cel($linha,$i);
	}
	$this->_inc_dec('rowspan','+');
	return true;
}
function _add_cels_in_col($coluna){
	if( $coluna>$this->_numColunas-1 )
		return false;
	switch ($coluna){
	case -1:
		for( $i=0;$i<$this->_numLinhas;$i++ ){
			array_unshift($this->_linhas[$i],null);
		}
		$coluna++;
		break;
	case null:
		$coluna = $this->_numColunas;
		break;
	default:
		$coluna++;
		for( $i=0;$i<$this->_numLinhas;$i++ ){
			$this->_insert($this->_linhas[$i],$coluna,$this->_numColunas);
		}
	}
	$this->_numColunas++;
	for( $i=0;$i<$this->_numLinhas;$i++ ){
		$this->_set_cel($i,$coluna,-1);
	}
	$this->_inc_dec('colspan','+');
	return true;
}
function _inc_dec($mode,$sign){
	if( is_array($cels= & $this->_temp) && ($mode=='colspan' || $mode=='rowspan') ){
		foreach( $cels as $k=>$v ){
			foreach( $v as $k1=>$v1 ){
				if( $sign=='+' ){
					if( $this->_isCel($k,$k1) )
						$this->_linhas[$k][$k1][$mode]++;
				} elseif( $sign=='-' ){
					if( $this->_isCel($k,$k1) )
						$this->_linhas[$k][$k1][$mode]--;
				} else
					return false;
			}
		}
		$this->_temp = null;
		return true;
	} else
		return false;
}
function _set_cel($linha,$coluna,$mode = 1){
	$array = & $this->_linhas;
	$cel = & $this->_linhas[$linha][$coluna];
	$cel['colspan'] = 1;
	$cel['rowspan'] = 1;
	if( $mode==-1 ){
		$coluna++;
		$mode = 'colspan';
	} elseif( $mode==1 ){
		$linha++;
		$mode = 'rowspan';
	} else
		return false;
	if( ($dec=$this->_linhas[$linha][$coluna]['dec'])!=null ){
		list($l,$c) = explode(":",$cel1['dec']);
		$this->_temp[$l][$c]=1;
		$cel['dec']=$dec;
		$cel[$mode]=0;
	} else
		$cel['dec'] = null;
	$cel['valor'] = '';
	$cel['align'] = '';
	$cel['valign'] = '';
	$cel['background'] = '';
	$cel['bgcolor'] = '';
	$cel['bordercolor'] = '';
	$cel['bordercolordark'] = '';
	$cel['bordercolorlight'] = '';
	$cel['class'] = '';
	$cel['height'] = '';
	$cel['width'] = '';
	$cel['style'] = '';
	$cel['onClick'] = '';
	$cel['onDblClick'] = '';
	$cel['onKeyDown'] = '';
	$cel['onKeyPress'] = '';
	$cel['onKeyUp'] = '';
	$cel['onMouseDown'] = '';
	$cel['onMouseMove'] = '';
	$cel['onMouseOut'] = '';
	$cel['onMouseOver'] = '';
	$cel['onMouseUp'] = '';
	return true;
}
function _unset_cel($linha,$coluna,$mode = 1){
	$array = & $this->_linhas;
	$cel = & $this->_linhas[$linha][$coluna];
	if( $mode==-1 ){
		$mode = 'colspan';
		$destroy = 'rowspan';
		$coluna++;
	} elseif( $mode==1 ){
		$mode = 'rowspan';
		$destroy = 'colspan';
		$linha++;
	} else
		return false;
	if( $cel[$mode]==0 ){
		list($l,$c) = explode(":",$cel['dec']);
		$this->_temp[$l][$c]=1;
		$cel[$destroy] = 0;
	} elseif( $cel[$mode]>1 ){
		$array[$linha][$coluna] = $cel;
		$array[$linha][$coluna][$mode]--;
		$this->_reDec($linha,$coluna);
	} else
		$cel[$destroy] = 0;
	return true;
}
function _reDec($l,$c){
	$cel = $this->_linhas[$l][$c];
	for( $i=$c+1;$i<$c+($cel['colspan']);$i++ ){
		$this->_linhas[$l][$i]['colspan']=0;
		$this->_linhas[$l][$i]['dec']=$l . ':' . $c;
	}
	for( $i=$l+1;$i<$l+($cel['rowspan']);$i++ ){
		$this->_linhas[$i][$c]['rowspan']=0;
		$this->_linhas[$i][$c]['dec']=$l . ':' . $c;
	}
	return true;
}
function _insert(&$array,$pos,$ate){
	$aux = $array;
	$j=0;
	for($i=0;$i<$ate;$i++){
		if( $i==$pos )
			$array[$j++] = array(null);
		$array[$j++] = $aux[$i];
	}
	return true;
}
function _reIndice(&$array,$ate){
	$aux = $array;
	$j=0;
	for( $i=0;$i<$ate;$i++ ){
		if( !isset($aux[$j]) )
			$j++;
		$array[$i] = $aux[$j];
		$j++;
	}
	unset($array[$ate]);
	return true;
}
function _isCel($l,$c){
	if( isset($this->_linhas[$l][$c]) )
		return true;
	else
		return false;
}
function _linhaExiste($l){
	$existe = false;
	for($i=0;$i<$this->_numColunas;$i++){
		if( $this->_linhas[$l][$i]['rowspan']>0 ){
			$existe = true;
			break;
		}
	}
	return $existe;
}
function _colunaExiste($c){
	$existe = false;
	for($i=0;$i<$this->_numLinhas;$i++){
		if( $this->_linhas[$i][$c]['colspan']>0 ){
			$existe = true;
			break;
		}
	}
	return $existe;
}
}
?>