<?php
/**
 *	Fileman - Classe para manipulacao de arquivo e diretrios.
 *            Recomendada para edio de sites e para uso em webserver pessoal
 *  
 *  Autor: Lucas Brito Arruda (llbra) - http://llbra.tk - llbra@bol.com.br
 *
 *  $Id: fileman.php v 0.1.0 Initiated: ? Finished: ? Published: 05/02/2004 (mm/dd/yyyy) - File Manipulation class $
 */


class fileman{


	/* 
		arr() - lista um conteudo de uma arquivo em um array ou o n de linhas de um
				arquivo

		Notes:  ($file) -> arquivo a ser processado
				($what) -> 0 (default) p/ listar em array e 1 p/ mostrar n de linhas
	*/

	function arr($file,$what=0){

		$list = @file($file);
		$lines = count($list);
		if ($what == 0){ return $list; }else{ return $lines; }
	}

	/* 
		stock() - grava algo em um arquivo na posicao desejada, tenta criar o arquivo
				  se ele nao existir

		Notes:  ($method) -> 1 grava no inicio do arquivo, 0 grava no fim dele
				($content) -> conteudo que sera gravado no arquivo
				($file) -> arquivo
				($jump) -> 1 acrescenta um quebra de linha antes do conteudo quando
						   se grava no fim do arquivo e depois do conteudo quando
						   se grava no comecao do arquivo, 0 grava na mesma linha			
	*/

	function stock($file,$content,$method=0,$jump=0){

		if ($jump == 1){ $put = "\r\n"; }else{ $put = ""; }
		if ($method == 1){ $metodo = "w+"; $content = $content.$put; 
		}else{ $metodo = "a+"; $content = $put.$content; }
		
		$fp = fopen($file,$metodo);	
		fwrite($fp,$content);
		fclose($fp);		
	}

	/*
		clean() - susbtitui caracteres HTML pelos suas reais representacoes

		Notes:  ($content) - conteudo em que sera feita a substituicao

				esta funcao faz extamente o contrario de htmlspecialchars().
				serve para que um conteudo enviado atraves do formulario seja
				fielmente reproduzido.
	*/

	function clean($content){
/*
    	$trans_tbl = get_html_translation_table (HTML_ENTITIES);
    	$trans_tbl = array_flip ($trans_tbl);
    	return stripslashes(strtr($content, $trans_tbl));
*/
		$pattern = array ("/&lt;/","/&gt;/","/&quot;/","/&amp;/");
		$replace = array ("<",">","\"","&");
		$content = stripslashes(preg_replace($pattern,$replace,$content));		
		return $content;

	}
		

	/* 
		read_file() - le arquivos e mostra seu codigo fonte

		Notes:  ($start) -> linha a partir da qual sera mostrado o conteudo do arquivo
				($end) -> linha limite para mostrar o conteudo, null para mostrar tudo
				($key) -> 0 para nao enumerar as linhas, 1 para enumerar
				($file) -> arquivo a ser lido
				($ret) -> 0 retorna em forma de echo, 1 retorna o valor

				escolhendo o mesmo valor para ($start) e ($end), somente a linha com
				aquele valor ser mostrada
	*/
	function read_file($file,$start=0,$end="null",$key=0,$ret=0,$high=0){

		$list = $this->arr($file);
		$lines = $this->arr($file,1);

		if ($end == "null"){ $end=$lines; }		
		for($x=$start; $x<=$end; $x++){
			if ($key != 0 AND $high == 0){
				if ($x != $end){ 
					if ($ret == 0){
						echo "$x. ";
					}else{ 
						$return .= "$x. "; 
					}
				}			
			}
			if ($ret == 0){
				if ($high == 0){
					echo htmlspecialchars($list[$x]);
					if ($x != $end){ echo "<br>"; }
				}else{
					$hlight .= $list[$x];
				}
			}else{
				$return .= htmlspecialchars($list[$x]);				
			}			
		}
		if ($ret != 0){ return $return; }
		if ($light != 1){ $hlight = highlight_string($hlight,1); echo $hlight; }
	}

	/* 
		write_file() - grava algo em um arquivo na posicao desejada, tenta criar o arquivo
					   se ele nao existir

		Notes:  ($method) -> 1 grava no inicio do arquivo, 0 grava no fim dele
				($content) -> conteudo que sera gravado no arquivo
				($file) -> arquivo
				($line) -> linha que o conteudo ser gravado
				($jump) -> acrescenta um quebra de linha antes do conteudo quando
						   se grava no fim do arquivo e depois do conteudo quando
						   se grava no comecao do arquivo				

				se um arquivo terminar com a linha ? > (a interrogacao  junta do > )
				vc pode gravar algum dado nele sem ter de delet-lo, copiar seu 
				conteudo com read_file() e grav-lo com write_file(). 
				 uma funo extremamente til, uma ferramenta poderosa de manipulacao de 
				dados em arquivos ja existentes.
	*/

	function write_file($file,$content,$method=0,$line="null",$jump=0){
		
		if ($line == "null"){
			$grava = $content;

		}else{
			$list = $this->arr($file);
			$lines = $this->arr($file,1);			
			
			for($x=0;$x<=$lines;$x++){
				if ($x == $line){
					$grava .= $content."\r\n";
					$grava .= $list[$x];
				}else{
					$grava .= $list[$x];
				}
			}
		unlink($file);
		}
		
		$grava = $this->clean($grava);
		$this->stock($file,$grava,$method,$jump);
		
	}

	/* 
		del_file() - deleta linha em arquivos ou arquivos inteiros

		Notes:  ($file) -> arquivo a ser manipulado
				($line) -> linha que o conteudo ser deletada
				($all) -> 0 so deleta linha especificada, 1 deleta o arquivo				
	*/
	function del_file($file,$line,$all=0){

		if ($all != 0){
			unlink($file); 
		}else{
		
			$list = $this->arr($file);
			$lines = $this->arr($file,1);
			
			for($x=0;$x<=$lines;$x++){
				if ($x != $line){				
					$grava .= $list[$x];
				}
			}
			unlink($file);
			$this->stock($file,trim($grava),1,0);
		}
	}


	/* 
		find_file() - procura por palavras em um arquivo

		Notes:  ($file) -> arquivo no qual sera procurada a palavra
				($content) -> palavra a ser procurada

				a funcao retorna 'x' resultados se achar o conteudo no arquivo 
				e '0', se nao achar
	*/
	function find_file($file,$content){

		$list = $this->arr($file);		

		$data = implode("",$list);
		$content = preg_quote($content);

		preg_match_all("/$content/",htmlspecialchars($data),$result);
		return count($result[0]);			
	}
			
	/* 
		replace_file() - substitui linha em um arquivo

		Notes:  ($file) -> arquivo que sera usado na substituicao
				($content) -> conteudo que sera gravado na linha especificada
				($line) -> linha que sera substituida				
	*/
	function replace_file($file,$content,$line){
			
		$list = $this->arr($file);
		$lines = $this->arr($file,1);

		for($x=0;$x<=$lines;$x++){
			if($x != $line){
				$grava .= $list[$x];
			}else{
				$grava .= $content."\r\n";
			}
		}
		unlink($file);

		$grava = $this->clean($grava);
		$this->stock($file,$grava,0,0);
	}

}


?>